/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.common.data.map;

import com.beatcraft.common.utils.JsonUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SongData {
    private final Path songFolder;
    private String title;
    private String subtitle;
    private String author;
    private ArrayList<String> mappers = new ArrayList();
    private float bpm;
    private float length;
    private String uid = null;
    private String coverImageFilename;
    private float previewStartTime;
    private float previewDuration;
    private String previewFilename;
    private final LinkedHashMap<String, LinkedHashMap<String, BeatmapInfo>> beatmaps = new LinkedHashMap();

    public SongData(String songFolder) throws IOException {
        File folder = new File(songFolder);
        String songIdBase = folder.getName();
        if (songIdBase.matches("[a-z0-9]+ \\(.*")) {
            this.uid = songIdBase.split(" ")[0];
        }
        this.songFolder = folder.toPath();
        File infoFile = SongData.getFile(songFolder, folder);
        if (infoFile == null) {
            throw new FileNotFoundException("Info.dat not found for song: '" + songFolder + "'");
        }
        String rawInfo = Files.readString(infoFile.toPath());
        JsonObject json = JsonParser.parseString((String)rawInfo).getAsJsonObject();
        if (json.has("_version")) {
            this.loadV2(json, folder.toPath());
        } else {
            this.loadV4(json, folder.toPath());
        }
        this.mappers = new ArrayList(this.mappers.stream().distinct().toList());
    }

    @Nullable
    private static File getFile(String songFolder, File folder) throws FileNotFoundException {
        if (!folder.exists()) {
            throw new FileNotFoundException("Cannot find folder: '" + songFolder + "'");
        }
        if (!folder.isDirectory()) {
            throw new FileNotFoundException("Expected a folder, not a file: '" + songFolder + "'");
        }
        File[] files = folder.listFiles();
        assert (files != null);
        File infoFile = null;
        for (File file : files) {
            if (!file.getName().equals("Info.dat") && !file.getName().equals("info.dat")) continue;
            infoFile = file;
        }
        return infoFile;
    }

    private void loadV2(JsonObject json, Path folder) {
        this.title = json.get("_songName").getAsString();
        this.subtitle = JsonUtil.getOrDefault(json, "_songSubName", JsonElement::getAsString, "");
        this.author = json.get("_songAuthorName").getAsString();
        String mapper = json.get("_levelAuthorName").getAsString();
        this.bpm = json.get("_beatsPerMinute").getAsFloat();
        this.previewStartTime = json.get("_previewStartTime").getAsFloat();
        this.previewDuration = json.get("_previewDuration").getAsFloat();
        this.previewFilename = String.valueOf(folder.toAbsolutePath()) + "/" + json.get("_songFilename").getAsString();
        this.coverImageFilename = String.valueOf(folder.toAbsolutePath()) + "/" + json.get("_coverImageFilename").getAsString();
        this.length = 0.0f;
        JsonArray difficultySets = json.getAsJsonArray("_difficultyBeatmapSets");
        difficultySets.forEach(rawSet -> {
            JsonObject set = rawSet.getAsJsonObject();
            String setName = set.get("_beatmapCharacteristicName").getAsString();
            this.beatmaps.put(setName, new LinkedHashMap());
            JsonArray difficulties = set.getAsJsonArray("_difficultyBeatmaps");
            difficulties.forEach(o -> {
                JsonObject cd;
                JsonObject obj = o.getAsJsonObject();
                String diff = obj.get("_difficulty").getAsString().replace("ExpertPlus", "Expert+");
                String fileName = obj.get("_beatmapFilename").getAsString();
                if (obj.has("_customData") && (cd = obj.getAsJsonObject("_customData")).has("_difficultyLabel")) {
                    diff = cd.get("_difficultyLabel").getAsString();
                }
                this.mappers.add(mapper);
                BeatmapInfo info = new BeatmapInfo(this, fileName, fileName, List.of(mapper), List.of(mapper));
                this.beatmaps.get(setName).put(diff, info);
            });
        });
    }

    private void loadV4(JsonObject json, Path folder) throws IOException {
        JsonObject songData = json.getAsJsonObject("song");
        JsonObject audioData = json.getAsJsonObject("audio");
        String audioDataFilename = audioData.get("audioDataFilename").getAsString();
        String rawAudioFileData = Files.readString(Path.of(folder.toString() + "/" + audioDataFilename, new String[0]));
        JsonObject rawAudioFileJson = JsonParser.parseString((String)rawAudioFileData).getAsJsonObject();
        float samples = rawAudioFileJson.get("songSampleCount").getAsFloat();
        float frequency = rawAudioFileJson.get("songFrequency").getAsFloat();
        this.length = samples / frequency;
        JsonArray beatmapInfo = json.getAsJsonArray("difficultyBeatmaps");
        this.title = songData.get("title").getAsString();
        this.subtitle = "";
        this.author = songData.get("author").getAsString();
        this.bpm = audioData.get("bpm").getAsFloat();
        this.previewFilename = String.valueOf(folder.toAbsolutePath()) + "/" + json.get("songPreviewFilename").getAsString();
        this.coverImageFilename = String.valueOf(folder.toAbsolutePath()) + "/" + json.get("coverImageFilename").getAsString();
        this.previewStartTime = audioData.get("previewStartTime").getAsFloat();
        this.previewDuration = audioData.get("previewDuration").getAsFloat();
        beatmapInfo.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            String set = obj.get("characteristic").getAsString();
            String diff = obj.get("difficulty").getAsString().replace("ExpertPlus", "Expert+");
            String mapFile = obj.get("beatmapDataFilename").getAsString();
            String lightFile = obj.get("lightshowDataFilename").getAsString();
            JsonObject authorData = obj.getAsJsonObject("beatmapAuthors");
            JsonArray rawMappers = authorData.getAsJsonArray("mappers");
            JsonArray rawLighters = authorData.getAsJsonArray("lighters");
            ArrayList<String> mappers = new ArrayList<String>();
            ArrayList<String> lighters = new ArrayList<String>();
            rawMappers.forEach(m -> mappers.add(m.getAsString()));
            rawLighters.forEach(l -> lighters.add(l.getAsString()));
            this.mappers.addAll(mappers);
            this.mappers.addAll(lighters);
            BeatmapInfo info = new BeatmapInfo(this, mapFile, lightFile, mappers, lighters);
            if (!this.beatmaps.containsKey(set)) {
                this.beatmaps.put(set, new LinkedHashMap());
            }
            this.beatmaps.get(set).put(diff, info);
        });
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public String getId() {
        return this.uid;
    }

    public String getAuthor() {
        return this.author;
    }

    public List<String> getMappers() {
        return this.mappers;
    }

    public float getLength() {
        return this.length;
    }

    public float getBpm() {
        return this.bpm;
    }

    public float getPreviewDuration() {
        return this.previewDuration;
    }

    public float getPreviewStartTime() {
        return this.previewStartTime;
    }

    public String getCoverImageFilename() {
        return this.coverImageFilename;
    }

    public String getPreviewFilename() {
        return this.previewFilename;
    }

    public List<String> getDifficultySets() {
        return this.beatmaps.keySet().stream().toList();
    }

    public List<String> getDifficulties(String difficultySet) {
        return this.beatmaps.get(difficultySet).keySet().stream().toList();
    }

    public BeatmapInfo getBeatMapInfo(String difficultySet, String difficulty) {
        return this.beatmaps.get(difficultySet).get(difficulty);
    }

    public Path getSongFolder() {
        return this.songFolder;
    }

    public String toString() {
        return "SongData{songFolder=" + String.valueOf(this.songFolder) + ", title='" + this.title + "', subtitle='" + this.subtitle + "', author='" + this.author + "', bpm=" + this.bpm + ", length=" + this.length + ", coverImageFilename='" + this.coverImageFilename + "', previewStartTime=" + this.previewStartTime + ", previewDuration=" + this.previewDuration + ", previewFilename='" + this.previewFilename + "', beatmaps=" + String.valueOf(this.beatmaps) + "}";
    }

    public record BeatmapInfo(SongData parent, String mapFile, String lightshowFile, List<String> mappers, List<String> lighters) {
        @Override
        @NotNull
        public String toString() {
            return "BeatmapInfo{mapFile='" + this.mapFile + "', lightshowFile='" + this.lightshowFile + "', mappers=" + String.valueOf(this.mappers) + ", lighters=" + String.valueOf(this.lighters) + "}";
        }

        public Path getBeatmapLocation() {
            return Path.of(String.valueOf(this.parent.songFolder.toAbsolutePath()) + "/" + this.mapFile, new String[0]);
        }
    }
}

