/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.common.data.map;

import com.beatcraft.Beatcraft;
import com.beatcraft.common.data.map.song_preview.SongPreview;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;

public class SongDownloader {
    private static final HttpClient httpClient = HttpClient.newHttpClient();
    private static final String SEARCH_LATEST_URL = "https://api.beatsaver.com/maps/latest";
    private static final String SEARCH_USER_URL = "https://api.beatsaver.com/maps/uploader/{userId}/{page}";
    private static final String SEARCH_ID_URL = "https://id/{mapId}";
    private static final String SEARCH_URL = "https://api.beatsaver.com/search/v1/";
    private static final String MAP_ID_URL = "https://api.beatsaver.com/maps/id/";
    private static final String ID_FROM_NAME_URL = "https://api.beatsaver.com/users/name/{name}";
    private static final int PAGE_SIZE = 7;
    public static String search = "";
    public static String before = null;
    public static AutomapperOption automapper = AutomapperOption.NO_AI;
    public static int page = 0;
    public static OrderSort order = OrderSort.None;
    public static ArrayList<SongPreview> songPreviews = new ArrayList();
    public static LeaderBoardSort leaderBoardSort = LeaderBoardSort.All;
    public static Boolean noodle = null;
    public static Boolean chroma = null;
    public static Boolean verified = null;
    private static CompletableFuture<Void> loadRequest = null;
    public static final SearchQueryBuilder queryBuilder = new SearchQueryBuilder();
    private static int currentRequestId = 0;
    public static final Lock listModifyLock = new ReentrantLock();

    public static void pageLeft(Runnable after) {
        page = Math.max(page - 1, 0);
        SongDownloader.loadFromSearch(after);
    }

    public static void pageRight(Runnable after) {
        ++page;
        SongDownloader.loadFromSearch(after);
    }

    public static void downloadSong(SongPreview preview, String runDirectory, Runnable after) {
        CompletableFuture.runAsync(() -> SongDownloader._downloadSong(preview, runDirectory)).thenRun(after);
    }

    public static void downloadFromId(String id, String runDirectory, Runnable after) {
        CompletableFuture.runAsync(() -> SongDownloader._downloadFromId(id, runDirectory, after));
    }

    private static void _downloadFromId(String id, String runDirectory, Runnable after) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(MAP_ID_URL + id)).GET().build();
        try {
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200 || response.body() == null) {
                Beatcraft.LOGGER.error("Failed to download song '{}'", (Object)id);
                return;
            }
            String rawJson = response.body();
            JsonObject responseJson = JsonParser.parseString((String)rawJson).getAsJsonObject();
            SongPreview preview = SongPreview.loadJson(responseJson);
            SongDownloader._downloadSong(preview, runDirectory);
            String songFolder = runDirectory + "/beatmaps/" + preview.id() + " (" + SongDownloader.filterString(preview.metaData().songName() + " - " + preview.metaData().levelAuthorName()) + ")";
            if (new File(songFolder).exists()) {
                after.run();
            } else {
                Beatcraft.LOGGER.error("Something went wrong with processing downloaded song!");
            }
        }
        catch (IOException | InterruptedException e) {
            Beatcraft.LOGGER.error("Failed to download song '{}'", (Object)id, (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    public static String filterString(String in) {
        String replaced = in.replaceAll("[^a-zA-Z0-9._\\-+()\\[\\]' ]", "_");
        if (replaced.length() > 150) {
            replaced = replaced.substring(0, 100);
        }
        return replaced;
    }

    private static void _downloadSong(SongPreview preview, String runDirectory) {
        String url = preview.versions().getFirst().downloadURL();
        String unzipTo = runDirectory + "/beatmaps/" + preview.id() + " (" + SongDownloader.filterString(preview.metaData().songName() + " - " + preview.metaData().levelAuthorName()) + ")";
        String path = unzipTo + ".zip";
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
        try {
            HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
            if (response.statusCode() != 200 || response.body() == null) {
                Beatcraft.LOGGER.error("Failed to download song: {}", (Object)response.statusCode());
                return;
            }
            try (FileOutputStream outputStream = new FileOutputStream(path);){
                outputStream.write(response.body());
            }
            SongDownloader.unzip(path, unzipTo);
        }
        catch (IOException | InterruptedException e) {
            Beatcraft.LOGGER.error("Failed to download song!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private static void unzip(String source, String destination) {
        try (ZipInputStream inputStream = new ZipInputStream(new FileInputStream(source));){
            ZipEntry zipEntry = inputStream.getNextEntry();
            while (zipEntry != null) {
                boolean isDirectory = zipEntry.getName().endsWith(File.separator);
                Path newPath = SongDownloader.zipSlipProtect(zipEntry, Path.of(destination, new String[0]));
                if (isDirectory) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                } else {
                    if (newPath.getParent() != null && Files.notExists(newPath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                    }
                    Files.copy(inputStream, newPath, StandardCopyOption.REPLACE_EXISTING);
                }
                zipEntry = inputStream.getNextEntry();
            }
            inputStream.closeEntry();
        }
        catch (IOException e) {
            Beatcraft.LOGGER.error("Failed to unzip song!", (Throwable)e);
        }
        try {
            Files.deleteIfExists(Path.of(source, new String[0]));
            SongDownloader.convertAllToPng(destination);
        }
        catch (IOException e) {
            Beatcraft.LOGGER.error("Failed to remove temporary zip!", (Throwable)e);
        }
    }

    public static Path zipSlipProtect(ZipEntry zipEntry, Path targetDir) throws IOException {
        Path targetDirResolved = targetDir.resolve(zipEntry.getName());
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir)) {
            throw new IOException("Bad zip entry: " + zipEntry.getName());
        }
        return normalizePath;
    }

    public static void loadFromSearch(Runnable after) {
        int id = ++currentRequestId;
        if (loadRequest != null) {
            loadRequest.cancel(false);
        }
        loadRequest = CompletableFuture.runAsync(SongDownloader::_loadFromSearch).thenRun(() -> {
            if (id == currentRequestId) {
                after.run();
                loadRequest = null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _loadFromSearch() {
        if (SongDownloader.queryBuilder.q.isEmpty()) {
            SongDownloader.loadLatest();
            return;
        }
        ArrayList localPreviews = new ArrayList();
        String searchQuery = queryBuilder.buildUrl();
        HttpRequest searchRequest = HttpRequest.newBuilder().uri(URI.create(searchQuery)).GET().build();
        try {
            HttpResponse<String> response = httpClient.send(searchRequest, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200 || response.body() == null) {
                Beatcraft.LOGGER.error("Failed to find songs from BeatSaver!");
                return;
            }
            String rawJson = response.body();
            JsonObject responseJson = JsonParser.parseString((String)rawJson).getAsJsonObject();
            JsonArray docs = responseJson.getAsJsonArray("docs");
            docs.forEach(rawSongJson -> {
                JsonObject songJson = rawSongJson.getAsJsonObject();
                SongPreview preview = SongPreview.loadJson(songJson);
                localPreviews.add(preview);
            });
            listModifyLock.lock();
            try {
                songPreviews.clear();
                songPreviews.addAll(localPreviews);
            }
            finally {
                listModifyLock.unlock();
            }
        }
        catch (IOException | InterruptedException e) {
            Beatcraft.LOGGER.error("Failed to connect to BeatSaver!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private static void loadLatest() {
        songPreviews.clear();
        page = 0;
        Object listQuery = "https://api.beatsaver.com/maps/latest?pageSize=7";
        if (before != null) {
            listQuery = (String)listQuery + "&before=" + before;
        }
        if (automapper.valLatest() != null) {
            listQuery = (String)listQuery + "&automapper=" + automapper.valLatest();
        }
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create((String)listQuery)).GET().build();
        try {
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200 || response.body() == null) {
                Beatcraft.LOGGER.error("Failed to fetch songs from BeatSaver!");
                return;
            }
            String rawBody = response.body();
            JsonObject responseJson = JsonParser.parseString((String)rawBody).getAsJsonObject();
            JsonArray docs = responseJson.getAsJsonArray("docs");
            docs.forEach(rawSongJson -> {
                JsonObject songJson = rawSongJson.getAsJsonObject();
                SongPreview preview = SongPreview.loadJson(songJson);
                songPreviews.add(preview);
            });
        }
        catch (IOException | InterruptedException e) {
            Beatcraft.LOGGER.error("Failed to connect to BeatSaver!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public static void convertToPng(File inputFile, File outputFile) throws IOException {
        BufferedImage originalImage = ImageIO.read(inputFile);
        if (originalImage == null) {
            throw new IOException("Invalid image file: " + inputFile.getAbsolutePath());
        }
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        BufferedImage convertedImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = convertedImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.drawImage(originalImage, 0, 0, width, height, null);
        g2d.dispose();
        ImageIO.write((RenderedImage)convertedImage, "png", outputFile);
        Files.deleteIfExists(inputFile.toPath());
    }

    public static void convertAllToPng(String folder) {
        File dir = new File(folder);
        if (!dir.exists() || !dir.isDirectory()) {
            System.out.println("Invalid directory: " + folder);
            return;
        }
        File[] files = dir.listFiles((dir1, name) -> name.toLowerCase().endsWith(".jpg") || name.toLowerCase().endsWith(".jpeg"));
        if (files == null) {
            return;
        }
        for (File file : files) {
            String outputFileName = file.getAbsolutePath().replaceAll("(?i)\\.jpe?g$", ".png");
            File outputFile = new File(outputFileName);
            try {
                SongDownloader.convertToPng(file, outputFile);
            }
            catch (IOException e) {
                Beatcraft.LOGGER.error("Failed to convert image to png '{}'", (Object)file.getName(), (Object)e);
            }
        }
    }

    public static class SearchQueryBuilder {
        public int page = 0;
        public Boolean ascending = null;
        public AutomapperOption automapper = AutomapperOption.NO_AI;
        public ArrayList<String> characteristics = new ArrayList();
        public Boolean chroma = null;
        public Boolean cinema = null;
        public ArrayList<String> collaborator = new ArrayList();
        public Boolean curated = null;
        public ArrayList<String> environments = new ArrayList();
        public Instant from = null;
        public Boolean fullSpread = null;
        public LeaderBoardSort leaderboard = LeaderBoardSort.None;
        public Float maxBlStars = null;
        public Float maxBpm = null;
        public Integer maxDownVotes = null;
        public Integer maxDuration = null;
        public Float maxNps = null;
        public Float maxRating = null;
        public Float maxSsStars = null;
        public Integer maxUpVotes = null;
        public Integer maxVotes = null;
        public Float minBlStars = null;
        public Float minBpm = null;
        public Integer minDownVotes = null;
        public Integer minDuration = null;
        public Float minNps = null;
        public Float minRating = null;
        public Float minSsStars = null;
        public Integer minUpVotes = null;
        public Integer minVotes = null;
        public Boolean noodle = null;
        public OrderSort order = OrderSort.None;
        public String q = "";
        public String tags = null;
        public Instant to = null;
        public Boolean verified = null;
        public Boolean vivify = null;

        public String buildUrl() {
            StringBuilder url = new StringBuilder("https://api.beatsaver.com/search/text/" + this.page);
            ArrayList<String> params = new ArrayList<String>();
            this.addParam(params, "pageSize", String.valueOf(7));
            this.addParam(params, "q", this.q);
            this.addBool(params, "ascending", this.ascending);
            if (this.automapper != null && this.automapper != AutomapperOption.NO_AI) {
                this.addBool(params, "automapper", this.automapper.valSearch());
            }
            this.addList(params, "characteristics", this.characteristics);
            this.addBool(params, "chroma", this.chroma);
            this.addBool(params, "cinema", this.cinema);
            this.addList(params, "collaborator", this.collaborator);
            this.addBool(params, "curated", this.curated);
            this.addList(params, "environments", this.environments);
            this.addDate(params, "from", this.from);
            this.addBool(params, "fullSpread", this.fullSpread);
            if (this.leaderboard != null && this.leaderboard != LeaderBoardSort.None) {
                this.addParam(params, "leaderboard", this.leaderboard.val());
            }
            this.addFloat(params, "maxBlStars", this.maxBlStars);
            this.addFloat(params, "maxBpm", this.maxBpm);
            this.addInt(params, "maxDownVotes", this.maxDownVotes);
            this.addInt(params, "maxDuration", this.maxDuration);
            this.addFloat(params, "maxNps", this.maxNps);
            this.addFloat(params, "maxRating", this.maxRating);
            this.addFloat(params, "maxSsStars", this.maxSsStars);
            this.addInt(params, "maxUpVotes", this.maxUpVotes);
            this.addInt(params, "maxVotes", this.maxVotes);
            this.addFloat(params, "minBlStars", this.minBlStars);
            this.addFloat(params, "minBpm", this.minBpm);
            this.addInt(params, "minDownVotes", this.minDownVotes);
            this.addInt(params, "minDuration", this.minDuration);
            this.addFloat(params, "minNps", this.minNps);
            this.addFloat(params, "minRating", this.minRating);
            this.addFloat(params, "minSsStars", this.minSsStars);
            this.addInt(params, "minUpVotes", this.minUpVotes);
            this.addInt(params, "minVotes", this.minVotes);
            this.addBool(params, "noodle", this.noodle);
            if (this.order != null && this.order != OrderSort.None) {
                this.addParam(params, "order", this.order.val());
            }
            this.addParam(params, "tags", this.tags);
            this.addDate(params, "to", this.to);
            this.addBool(params, "verified", this.verified);
            this.addBool(params, "vivify", this.vivify);
            if (!params.isEmpty()) {
                url.append("?").append(String.join((CharSequence)"&", params));
            }
            return url.toString();
        }

        private void addParam(ArrayList<String> params, String key, String value) {
            if (value != null && !value.isEmpty()) {
                params.add(key + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8));
            }
        }

        private void addBool(ArrayList<String> params, String key, Boolean value) {
            if (value != null) {
                params.add(key + "=" + value.toString());
            }
        }

        private void addInt(ArrayList<String> params, String key, Integer value) {
            if (value != null) {
                params.add(key + "=" + value);
            }
        }

        private void addFloat(ArrayList<String> params, String key, Float value) {
            if (value != null) {
                params.add(key + "=" + value);
            }
        }

        private void addDate(ArrayList<String> params, String key, Instant value) {
            if (value != null) {
                params.add(key + "=" + URLEncoder.encode(value.toString(), StandardCharsets.UTF_8));
            }
        }

        private void addList(ArrayList<String> params, String key, ArrayList<String> list) {
            if (list != null && !list.isEmpty()) {
                StringJoiner joiner = new StringJoiner(",");
                for (String item : list) {
                    if (item == null || item.isEmpty()) continue;
                    joiner.add(item);
                }
                if (joiner.length() > 0) {
                    params.add(key + "=" + URLEncoder.encode(joiner.toString(), StandardCharsets.UTF_8));
                }
            }
        }
    }

    public static enum AutomapperOption {
        BOTH(true, true),
        AI(false, null),
        NO_AI(null, false);

        private final Boolean val;
        private final Boolean val2;

        private AutomapperOption(Boolean val, Boolean val2) {
            this.val = val;
            this.val2 = val2;
        }

        public Boolean valSearch() {
            return this.val;
        }

        public Boolean valLatest() {
            return this.val2;
        }
    }

    public static enum OrderSort {
        None(null),
        Latest("Latest"),
        Relevance("Relevance"),
        Rating("Rating"),
        Curated("Curated"),
        Random("Random");

        private final String val;

        private OrderSort(String val) {
            this.val = val;
        }

        public String val() {
            return this.val;
        }
    }

    public static enum LeaderBoardSort {
        None(null),
        All("All"),
        Ranked("Ranked"),
        BeatLeader("BeatLeader"),
        ScoreSaber("ScoreSaber");

        private final String val;

        private LeaderBoardSort(String val) {
            this.val = val;
        }

        public String val() {
            return this.val;
        }
    }
}

