/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.common.data.types;

import com.beatcraft.common.data.types.ISplinePath;
import com.beatcraft.common.memory.MemoryPool;
import java.util.ArrayList;
import java.util.List;
import org.joml.Vector3f;

public class BezierPath
implements ISplinePath {
    private final ArrayList<Vector3f> points = new ArrayList();

    public BezierPath(List<Vector3f> points) {
        this.points.addAll(points);
    }

    @Override
    public Vector3f evaluate(float t) {
        int n = this.points.size() - 1;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (int i = 0; i <= n; ++i) {
            float coefficient = (float)BezierPath.binomialCoefficient(n, i) * (float)Math.pow(1.0f - t, n - i) * (float)Math.pow(t, i);
            x += coefficient * this.points.get((int)i).x;
            y += coefficient * this.points.get((int)i).y;
            z += coefficient * this.points.get((int)i).z;
        }
        return MemoryPool.newVector3f(x, y, z);
    }

    private static int binomialCoefficient(int n, int k) {
        if (k < 0 || k > n) {
            return 0;
        }
        if (k == 0 || k == n) {
            return 1;
        }
        return BezierPath.binomialCoefficient(n - 1, k - 1) + BezierPath.binomialCoefficient(n - 1, k);
    }

    @Override
    public Vector3f getTangent(float t) {
        int n = this.points.size() - 1;
        if (n == 0) {
            return MemoryPool.newVector3f(0.0f, 0.0f, 0.0f);
        }
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (int i = 0; i < n; ++i) {
            float coefficient = (float)(n * BezierPath.binomialCoefficient(n - 1, i)) * (float)Math.pow(1.0f - t, n - 1 - i) * (float)Math.pow(t, i);
            x += coefficient * (this.points.get((int)(i + 1)).x - this.points.get((int)i).x);
            y += coefficient * (this.points.get((int)(i + 1)).y - this.points.get((int)i).y);
            z += coefficient * (this.points.get((int)(i + 1)).z - this.points.get((int)i).z);
        }
        return MemoryPool.newVector3f(x, y, z);
    }

    @Override
    public List<Vector3f> getControlPoints() {
        return this.points;
    }
}

