/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.common.data.types;

import com.beatcraft.common.data.types.ISplinePath;
import com.beatcraft.common.memory.MemoryPool;
import java.util.ArrayList;
import java.util.List;
import org.joml.Vector3f;

public class PiecewiseCurve
implements ISplinePath {
    private final ArrayList<Curve> curves = new ArrayList();

    public void addCurve(float globalStart, float globalEnd, float localStart, float localEnd, ISplinePath curve) {
        Curve spline = new Curve(globalStart, globalEnd, localStart, localEnd, curve);
        this.curves.add(spline);
    }

    @Override
    public Vector3f evaluate(float t) {
        for (Curve curve : this.curves) {
            if (!(curve.globalStart <= t) || !(t <= curve.globalEnd)) continue;
            float local = (t - curve.globalStart) / (curve.globalEnd - curve.globalStart);
            float mapped = curve.localStart + local * (curve.localEnd - curve.localStart);
            return curve.spline.evaluate(mapped);
        }
        return MemoryPool.newVector3f(0.0f, 0.0f, 0.0f);
    }

    @Override
    public Vector3f getTangent(float t) {
        for (Curve curve : this.curves) {
            if (!(curve.globalStart <= t) || !(t <= curve.globalEnd)) continue;
            float local = (t - curve.globalStart) / (curve.globalEnd - curve.globalStart);
            float mapped = curve.localStart + local * (curve.localEnd - curve.localStart);
            return curve.spline.getTangent(mapped);
        }
        return MemoryPool.newVector3f(0.0f, 0.0f, 0.0f);
    }

    @Override
    public List<Vector3f> getControlPoints() {
        return List.of();
    }

    public static class Curve {
        public float localStart;
        public float localEnd;
        public float globalStart;
        public float globalEnd;
        public ISplinePath spline;

        public Curve(float globalStart, float globalEnd, float localStart, float localEnd, ISplinePath curve) {
            this.globalStart = globalStart;
            this.globalEnd = globalEnd;
            this.localStart = localStart;
            this.localEnd = localEnd;
            this.spline = curve;
        }
    }
}

