/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.neoforge.client.services;

import com.beatcraft.client.commands.ClientCommands;
import com.beatcraft.client.commands.CommandTree;
import com.beatcraft.client.services.ICommandManager;
import com.beatcraft.neoforge.client.command.NeoforgeCommandCallback;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;

public class CommandManager
implements ICommandManager {
    public static CommandDispatcher<CommandSourceStack> dispatcher;

    @Override
    public void register(CommandTree ... commands) {
        for (CommandTree cmd : commands) {
            dispatcher.register((LiteralArgumentBuilder)this.parse(cmd));
        }
    }

    private ArgumentBuilder<CommandSourceStack, ?> parse(CommandTree cmd) {
        LiteralArgumentBuilder builder;
        if (cmd.type == CommandTree.ArgumentType.Literal) {
            builder = LiteralArgumentBuilder.literal((String)cmd.name);
        } else {
            builder = RequiredArgumentBuilder.argument((String)cmd.name, this.getArg(cmd.type));
            if (cmd.suggestionProvider != null) {
                ((RequiredArgumentBuilder)builder).suggests((ctx, suggestionsBuilder) -> {
                    NeoforgeCommandCallback callback = new NeoforgeCommandCallback((CommandContext<CommandSourceStack>)ctx);
                    return cmd.suggestionProvider.apply(callback, suggestionsBuilder);
                });
            }
        }
        if (cmd.callback != null) {
            builder.executes(ctx -> {
                NeoforgeCommandCallback cb = new NeoforgeCommandCallback((CommandContext<CommandSourceStack>)ctx);
                ClientCommands.CommandResult fb = cmd.callback.apply(cb);
                if (fb.msg != null) {
                    if (fb.state == 0) {
                        ((CommandSourceStack)ctx.getSource()).sendSystemMessage(fb.msg);
                    } else {
                        ((CommandSourceStack)ctx.getSource()).sendFailure(fb.msg);
                    }
                }
                return fb.state;
            });
        }
        for (CommandTree subBranch : cmd.branches) {
            builder.then(this.parse(subBranch));
        }
        return builder;
    }

    private ArgumentType<?> getArg(CommandTree.ArgumentType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case CommandTree.ArgumentType.Literal -> throw new RuntimeException("Tried to parse literal as argument");
            case CommandTree.ArgumentType.Integer -> IntegerArgumentType.integer();
            case CommandTree.ArgumentType.Float -> FloatArgumentType.floatArg();
            case CommandTree.ArgumentType.Vec3i -> Vec3Argument.vec3((boolean)false);
            case CommandTree.ArgumentType.Vec3f -> Vec3Argument.vec3((boolean)false);
            case CommandTree.ArgumentType.Vec2i -> Vec2Argument.vec2((boolean)false);
            case CommandTree.ArgumentType.Vec2f -> Vec2Argument.vec2((boolean)false);
            case CommandTree.ArgumentType.Uuid -> UuidArgument.uuid();
            case CommandTree.ArgumentType.String -> StringArgumentType.string();
        };
    }
}

