/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.audio.AudioController;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.BeatmapManager;
import com.beatcraft.client.beatmap.BeatmapRenderer;
import com.beatcraft.client.commands.ClientCommands;
import com.beatcraft.client.logic.PhysicsTransform;
import com.beatcraft.client.menu.SongList;
import com.beatcraft.common.data.PlayerConfig;
import com.beatcraft.common.items.ModItems;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.provider.MCVR;
import oshi.util.tuples.Triplet;

@OnlyIn(value=Dist.CLIENT)
public class BeatcraftClient {
    public static SongList songs = new SongList();
    public static RandomSource random = RandomSource.create();
    public static PlayerConfig playerConfig;
    public static boolean wearingHeadset;
    public static boolean FPFC;
    public static final HashMap<UUID, Triplet<PhysicsTransform, PhysicsTransform, PhysicsTransform>> controllerTransforms;
    public static BeatmapController headsetLinkedBeatmap;
    private static final Matrix4f mat4;
    private static final Quaternionf rot;

    public static void earlyInit() {
        Beatcraft.LOGGER.info("Initializing Beatcraft Neoforge");
        playerConfig = PlayerConfig.loadFromFile();
    }

    public static void initCommands() {
        Beatcraft.LOGGER.info("Initializing commands");
        ClientCommands.init();
    }

    private static float snapAngle(float degrees) {
        float angle = (float)Math.round(degrees / 45.0f) * 45.0f;
        return (float)Math.toRadians(angle);
    }

    public static void updatePlayerSabers(float tickDelta) {
        MCVR vr = ClientDataHolderVR.getInstance().vr;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        UUID uuid = player.getUUID();
        if (!controllerTransforms.containsKey(uuid)) {
            controllerTransforms.put(uuid, (Triplet<PhysicsTransform, PhysicsTransform, PhysicsTransform>)new Triplet((Object)new PhysicsTransform(-0.4f, 0.0f, 0.0f), (Object)new PhysicsTransform(0.0f, 0.0f, 0.0f), (Object)new PhysicsTransform(0.4f, 0.0f, 0.0f)));
        }
        Triplet<PhysicsTransform, PhysicsTransform, PhysicsTransform> sabers = controllerTransforms.get(uuid);
        boolean newWearingHeadset = player.getItemBySlot(EquipmentSlot.HEAD).is(ModItems.HEADSET_ITEM);
        if (wearingHeadset && !newWearingHeadset) {
            if (headsetLinkedBeatmap != null) {
                BeatmapManager.beatmaps.remove(headsetLinkedBeatmap);
                headsetLinkedBeatmap = null;
                AudioController.stopPreview();
            }
        } else if (newWearingHeadset && !wearingHeadset && headsetLinkedBeatmap == null) {
            headsetLinkedBeatmap = new BeatmapController((Level)player.clientLevel, player.blockPosition().getBottomCenter().toVector3f(), BeatcraftClient.snapAngle(-player.getViewYRot(tickDelta)), BeatmapRenderer.RenderStyle.HEADSET);
            BeatmapManager.beatmaps.add(headsetLinkedBeatmap);
            headsetLinkedBeatmap.trackPlayer(player.getUUID());
        }
        wearingHeadset = newWearingHeadset;
        Vector3f headPos = player.getPosition(tickDelta).toVector3f().add(0.0f, player.getEyeHeight(), 0.0f);
        rot.identity().rotateY(-player.getViewYRot(tickDelta) * ((float)Math.PI / 180)).normalize().rotateX(player.getViewXRot(tickDelta) * ((float)Math.PI / 180)).normalize();
        if (vr != null && vr.isActive()) {
            mat4.identity().translate((Vector3fc)headPos).rotate((Quaternionfc)rot);
            ((PhysicsTransform)sabers.getB()).update(mat4);
        } else if (FPFC) {
            rot.rotateX(1.5707964f);
            mat4.identity().translate((Vector3fc)headPos).rotate((Quaternionfc)rot);
            ((PhysicsTransform)sabers.getA()).update(mat4);
            ((PhysicsTransform)sabers.getB()).update(mat4);
            ((PhysicsTransform)sabers.getC()).update(mat4);
        }
    }

    static {
        wearingHeadset = false;
        FPFC = false;
        controllerTransforms = new HashMap();
        headsetLinkedBeatmap = null;
        mat4 = new Matrix4f();
        rot = new Quaternionf();
    }
}

