/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.animation.base_providers;

import com.beatcraft.client.animation.base_providers.RotationProvider;
import com.beatcraft.client.animation.base_providers.UpdatableValue;
import com.beatcraft.common.memory.MemoryPool;
import java.util.function.Consumer;
import org.joml.Quaternionf;
import org.joml.Vector3f;

class BaseRotationProvider
extends UpdatableValue
implements RotationProvider {
    private final float[] values;
    private final Consumer<Quaternionf> updater;
    private final Quaternionf rotation = new Quaternionf();

    public BaseRotationProvider(Consumer<Quaternionf> valueUpdater) {
        this.values = new float[3];
        this.updater = valueUpdater;
    }

    @Override
    public void update() {
        this.updater.accept(this.rotation);
        Vector3f e = MemoryPool.newVector3f();
        this.rotation.getEulerAnglesXYZ(e);
        this.values[0] = e.x;
        this.values[1] = e.y;
        this.values[2] = e.z;
        MemoryPool.releaseSafe(e);
    }

    @Override
    public float[] getValues() {
        return this.values;
    }

    @Override
    public Quaternionf getRotation() {
        return this.rotation;
    }
}

