/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.animation.base_providers;

import com.beatcraft.client.animation.base_providers.RotationProvider;
import com.beatcraft.client.animation.base_providers.UpdatableValue;
import com.beatcraft.common.memory.MemoryPool;
import org.joml.Quaternionf;
import org.joml.Vector3f;

class QuaternionProvider
extends UpdatableValue
implements RotationProvider {
    private final float[] source;
    private final float[] values;
    private final Quaternionf rotation;

    QuaternionProvider(float[] source) {
        this.source = source;
        this.values = new float[3];
        this.rotation = new Quaternionf();
    }

    @Override
    public Quaternionf getRotation() {
        return this.rotation;
    }

    @Override
    public void update() {
        this.rotation.set(this.source[0], this.source[1], this.source[2], this.source[3]);
        Vector3f e = MemoryPool.newVector3f();
        this.rotation.getEulerAnglesXYZ(e);
        this.values[0] = e.x;
        this.values[1] = e.y;
        this.values[2] = e.z;
        MemoryPool.releaseSafe(e);
    }

    @Override
    public float[] getValues() {
        return this.values;
    }
}

