/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.animation.event;

import com.beatcraft.client.animation.pointdefinition.PointDefinition;
import com.beatcraft.client.beatmap.data.event.AnimateTrack;
import com.beatcraft.common.event.IEvent;

public class AnimatedPropertyEvent<T>
implements IEvent {
    private final PointDefinition<T> property;
    private final AnimateTrack origin;

    public AnimatedPropertyEvent(PointDefinition<T> property, AnimateTrack origin) {
        this.property = property;
        this.origin = origin;
    }

    private boolean isRepeating() {
        return this.origin.getRepeat() != null;
    }

    private boolean hasEasing() {
        return this.origin.getEasing() != null;
    }

    @Override
    public float getEventBeat() {
        return this.origin.getBeat();
    }

    @Override
    public float getEventDuration() {
        return this.origin.getRepeatedDuration();
    }

    public T getEventData(float normalTime) {
        if (this.isRepeating()) {
            normalTime = normalTime * (float)this.origin.getRepeat().intValue() % 1.0f;
        }
        if (this.hasEasing()) {
            normalTime = this.origin.getEasing().apply(Float.valueOf(normalTime)).floatValue();
        }
        return this.property.interpolate(normalTime);
    }
}

