/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.audio;

import java.io.File;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;
import org.lwjgl.stb.STBVorbis;
import org.lwjgl.stb.STBVorbisInfo;
import org.lwjgl.system.MemoryStack;

public class SpectrogramAnalyzer {
    private final int numBars;
    private final int sampleRate;
    private final int channels;
    private final float duration;
    private final File audioFile;
    private final boolean loadedSuccessfully;
    private static final int FFT_SIZE = 1024;
    private static final float MAGNITUDE_MULTIPLIER = 1.0E-5f;
    private long decoder;

    public SpectrogramAnalyzer(File audioFile, int numBars) {
        boolean success;
        float tempDuration;
        int tempChannels;
        int tempSampleRate;
        block10: {
            this.numBars = numBars;
            this.audioFile = audioFile;
            tempSampleRate = 44100;
            tempChannels = 2;
            tempDuration = 0.0f;
            success = false;
            if (audioFile.exists()) {
                try (MemoryStack stack = MemoryStack.stackPush();){
                    IntBuffer error = stack.mallocInt(1);
                    this.decoder = STBVorbis.stb_vorbis_open_filename((CharSequence)audioFile.getAbsolutePath(), (IntBuffer)error, null);
                    if (this.decoder != 0L) {
                        STBVorbisInfo info = STBVorbisInfo.malloc((MemoryStack)stack);
                        STBVorbis.stb_vorbis_get_info((long)this.decoder, (STBVorbisInfo)info);
                        tempChannels = info.channels();
                        tempSampleRate = info.sample_rate();
                        tempDuration = STBVorbis.stb_vorbis_stream_length_in_seconds((long)this.decoder);
                        success = true;
                    }
                }
                catch (Exception e) {
                    if (this.decoder == 0L) break block10;
                    STBVorbis.stb_vorbis_close((long)this.decoder);
                    this.decoder = 0L;
                }
            }
        }
        this.channels = tempChannels;
        this.sampleRate = tempSampleRate;
        this.duration = tempDuration;
        this.loadedSuccessfully = success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float[] getLevels(float timeInSeconds) {
        if (!this.loadedSuccessfully) return new float[this.numBars];
        if (this.decoder == 0L) {
            return new float[this.numBars];
        }
        timeInSeconds = Math.max(0.0f, Math.min(this.duration, timeInSeconds));
        try (MemoryStack stack = MemoryStack.stackPush();){
            int i;
            ShortBuffer audioBuffer = stack.mallocShort(1024 * this.channels);
            STBVorbis.stb_vorbis_seek_frame((long)this.decoder, (int)((int)(timeInSeconds * (float)this.sampleRate)));
            int samplesRead = STBVorbis.stb_vorbis_get_samples_short_interleaved((long)this.decoder, (int)this.channels, (ShortBuffer)audioBuffer);
            if (samplesRead <= 0) {
                float[] fArray2 = new float[this.numBars];
                return fArray2;
            }
            double[] windowedData = new double[1024];
            for (i = 0; i < 1024 && i < samplesRead; ++i) {
                short sample = this.channels == 2 ? (i * 2 + 1 < audioBuffer.capacity() ? (short)((audioBuffer.get(i * 2) + audioBuffer.get(i * 2 + 1)) / 2) : (short)0) : (i < audioBuffer.capacity() ? audioBuffer.get(i) : (short)0);
                double hammingWindow = 0.54 - 0.46 * Math.cos(Math.PI * 2 * (double)i / 1023.0);
                windowedData[i] = (double)sample * hammingWindow;
            }
            for (i = samplesRead; i < 1024; ++i) {
                windowedData[i] = 0.0;
            }
            FastFourierTransformer fft = new FastFourierTransformer(DftNormalization.STANDARD);
            Complex[] spectrum = fft.transform(windowedData, TransformType.FORWARD);
            int numBins = 512;
            float[] amplitudes = new float[numBins];
            for (int i2 = 0; i2 < numBins; ++i2) {
                amplitudes[i2] = (float)spectrum[i2].abs() * 1.0E-5f;
            }
            float[] bars = new float[this.numBars];
            int binsPerBar = numBins / this.numBars;
            for (int i3 = 0; i3 < this.numBars; ++i3) {
                float sum = 0.0f;
                for (int j = 0; j < binsPerBar; ++j) {
                    int binIndex = i3 * binsPerBar + j;
                    if (binIndex >= amplitudes.length) continue;
                    sum += amplitudes[binIndex];
                }
                bars[i3] = sum / (float)binsPerBar;
            }
            float[] fArray = bars;
            return fArray;
        }
        catch (Exception e) {
            return new float[this.numBars];
        }
    }

    public float getDuration() {
        return this.duration;
    }
}

