/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.beatmap;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.BeatcraftClient;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.CutDirection;
import com.beatcraft.client.beatmap.data.NoteType;
import com.beatcraft.client.beatmap.object.data.GameplayObject;
import com.beatcraft.client.beatmap.object.data.ScoreState;
import com.beatcraft.client.beatmap.object.physical.PhysicalBombNote;
import com.beatcraft.client.beatmap.object.physical.PhysicalGameplayObject;
import com.beatcraft.client.beatmap.object.physical.PhysicalObstacle;
import com.beatcraft.client.beatmap.object.physical.PhysicalScorableObject;
import com.beatcraft.client.logic.HapticsHandler;
import com.beatcraft.client.logic.Hitbox;
import com.beatcraft.client.logic.PhysicsTransform;
import com.beatcraft.client.logic.Rank;
import com.beatcraft.client.menu.EndScreenData;
import com.beatcraft.client.render.DebugRenderer;
import com.beatcraft.client.render.HUDRenderer;
import com.beatcraft.common.items.ModItems;
import com.beatcraft.common.utils.MathUtil;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import oshi.util.tuples.Triplet;

public class BeatmapLogicController {
    private final BeatmapController controller;
    public Vector3f headPos = new Vector3f();
    public Quaternionf headRot = new Quaternionf();
    public Vector3f leftSaberPos = new Vector3f();
    public Quaternionf leftSaberRotation = new Quaternionf();
    public Vector3f leftSaberTipVelocity = new Vector3f();
    public Vector3f rightSaberPos = new Vector3f();
    public Quaternionf rightSaberRotation = new Quaternionf();
    public Vector3f rightSaberTipVelocity = new Vector3f();
    public Vector3f playerGlobalPosition = new Vector3f();
    public Quaternionf playerGlobalRotation = new Quaternionf();
    private static final Vector3f SABER_TIP_OFFSET = new Vector3f(0.0f, 1.0f, 0.0f);
    private static final int MISS_HP = 15;
    private static final int BADCUT_HP = 10;
    private static final int BOMB_HP = 15;
    private static final int WALL_HP = 10;
    private static final int HEAL_HP = 5;
    public int goodCuts = 0;
    public int badCuts = 0;
    public int misses = 0;
    public double loseFCTime = 0.0;
    public int combo = 0;
    public int maxCombo = 0;
    public int bonusModifier = 1;
    public int modifierProgress = 0;
    public int maxPossibleScore = 0;
    public int score = 0;
    public boolean failed = false;
    public boolean noFail = false;
    public int maxHealth = 100;
    public float health = 50.0f;
    public float mapSpeed = 1.0f;
    private boolean failAnim = false;
    public float globalDissolve = 0.0f;
    public float globalArrowDissolve = 0.0f;
    public float ghostNoteDissolve = 0.0f;
    private double failTime = 0.0;
    private static final double DISSOLVE_TIME = 2.5;
    private static final Vector3f wp = new Vector3f();
    private static final Matrix4f invTransform = new Matrix4f();
    private static final Vector3f tipPos = new Vector3f();
    private static final Vector3f localTip = new Vector3f();
    private static final Vector3f localBase = new Vector3f();
    private static final Vector3f localVel = new Vector3f();
    private static final Quaternionf q0 = new Quaternionf();
    private static final Vector3f DOWN = new Vector3f(0.0f, -1.0f, 0.0f);
    private static final Vector3f dir = new Vector3f();
    private static final Vector3f localHeadPos = new Vector3f();

    public BeatmapLogicController(BeatmapController player) {
        this.controller = player;
    }

    public int getCombo() {
        return this.combo;
    }

    public int getMaxPossibleScore() {
        return this.maxPossibleScore;
    }

    public int getScore() {
        return this.score;
    }

    public float getAccuracy() {
        if (this.maxPossibleScore == 0) {
            return 1.0f;
        }
        return (float)this.score / (float)this.maxPossibleScore;
    }

    public float getBonusModifier() {
        return this.bonusModifier;
    }

    public float getHealthPercentage() {
        return this.health / (float)this.maxHealth;
    }

    public boolean update(double deltaTime) {
        if (this.controller.trackedPlayer == null) {
            return true;
        }
        assert (Minecraft.getInstance().level != null);
        Player player = Minecraft.getInstance().level.getPlayerByUUID(this.controller.trackedPlayer);
        if (player == null) {
            return false;
        }
        if (!player.level().equals(this.controller.level)) {
            return false;
        }
        Triplet<PhysicsTransform, PhysicsTransform, PhysicsTransform> sabers = BeatcraftClient.controllerTransforms.get(this.controller.trackedPlayer);
        if (sabers == null) {
            return false;
        }
        this.controller.isInWall = false;
        PhysicsTransform left = (PhysicsTransform)sabers.getA();
        PhysicsTransform head = (PhysicsTransform)sabers.getB();
        PhysicsTransform right = (PhysicsTransform)sabers.getC();
        boolean rightHanded = player.getMainArm() == HumanoidArm.RIGHT;
        EquipmentSlot leftHand = rightHanded ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
        EquipmentSlot rightHand = rightHanded ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        boolean leftItem = player.getItemBySlot(leftHand).is(ModItems.SABER_ITEM);
        boolean rightItem = player.getItemBySlot(rightHand).is(ModItems.SABER_ITEM);
        if (leftItem) {
            left.getPosition(this.leftSaberPos);
            left.getRotation(this.leftSaberRotation);
            left.getPositionalVelocity((float)deltaTime, SABER_TIP_OFFSET, this.leftSaberTipVelocity);
        } else {
            this.leftSaberPos.set(0.0f, -600.0f, 0.0f);
        }
        if (rightItem) {
            right.getPosition(this.rightSaberPos);
            right.getRotation(this.rightSaberRotation);
            right.getPositionalVelocity((float)deltaTime, SABER_TIP_OFFSET, this.rightSaberTipVelocity);
        } else {
            this.rightSaberPos.set(0.0f, -600.0f, 0.0f);
        }
        head.getPosition(this.headPos);
        head.getRotation(this.headRot);
        return true;
    }

    public void lateUpdate(double deltaTime) {
        if (this.controller.isInWall) {
            this.processDamage(10.0f * (float)deltaTime);
            this.checkFail();
            this.breakCombo();
        }
        if (this.failAnim) {
            double t = (double)System.nanoTime() / 1.0E9;
            double normalized = MathUtil.inverseLerp(this.failTime, this.failTime + 2.5, t);
            float n = (float)Math.clamp(normalized, 0.0, 1.0);
            this.controller.setSpeed(0.1f * this.mapSpeed + (this.mapSpeed - n) * (0.9f * this.mapSpeed));
            if (normalized <= 1.0) {
                this.globalDissolve = Math.max(this.globalDissolve, (float)normalized);
                this.globalArrowDissolve = Math.max(this.globalArrowDissolve, (float)normalized);
            } else if (normalized >= 1.1) {
                this.failAnim = false;
                this.failTime = 0.0;
                this.resetToMenu();
                this.controller.setSpeed(1.0f);
            }
        }
    }

    public void checkNote(PhysicalGameplayObject<? extends GameplayObject> obj) {
        obj.getWorldPos(wp);
        double cd = 1.2 + (double)obj.getCollisionDistance();
        if ((double)this.rightSaberPos.distance((Vector3fc)wp) <= cd) {
            this.checkSaber(obj, this.rightSaberPos, this.rightSaberRotation, this.rightSaberTipVelocity, NoteType.BLUE);
        }
        if ((double)this.leftSaberPos.distance((Vector3fc)wp) <= cd) {
            this.checkSaber(obj, this.leftSaberPos, this.leftSaberRotation, this.leftSaberTipVelocity, NoteType.RED);
        }
    }

    private void processNote(PhysicalScorableObject obj, Hitbox gc, Hitbox bc, NoteType expectedNoteType, Vector3f vel) {
        CutDirection cd = obj.score$getCutDirection();
        if (obj.score$getData().score$getNoteType() == expectedNoteType) {
            if (cd == CutDirection.DOT) {
                if (gc.checkCollision(localBase, localTip)) {
                    this.calculateScore(obj, localVel, localBase, localTip);
                    obj.score$cutNote();
                    BeatmapLogicController.getPlaneNormal(localBase, localTip, vel, dir);
                    obj.score$spawnDebris(localBase.add(0.25f, 0.25f, 0.25f, new Vector3f()), dir);
                }
            } else if (BeatmapLogicController.isPointingDown(localVel)) {
                if (gc.checkCollision(localBase, localTip)) {
                    this.calculateScore(obj, localVel, localBase, localTip);
                    obj.score$cutNote();
                    BeatmapLogicController.getPlaneNormal(localBase, localTip, vel, dir);
                    obj.score$spawnDebris(localBase.add(0.25f, 0.25f, 0.25f, new Vector3f()), dir);
                }
            } else if (bc.checkCollision(localBase, localTip)) {
                obj.score$setScoreState(ScoreState.badCut());
                obj.score$cutNote();
                BeatmapLogicController.getPlaneNormal(localBase, localTip, vel, dir);
                obj.score$spawnDebris(localBase.add(0.25f, 0.25f, 0.25f, new Vector3f()), dir);
                this.processBadCut(obj.score$getMaxFollowThroughScore() + obj.score$getMaxSwingInScore() + 15);
            }
        } else if (bc.checkCollision(localBase, localTip)) {
            obj.score$setScoreState(ScoreState.badCut());
            obj.score$cutNote();
            BeatmapLogicController.getPlaneNormal(localBase, localTip, vel, dir);
            obj.score$spawnDebris(localBase.add(0.25f, 0.25f, 0.25f, new Vector3f()), dir);
            this.processBadCut(obj.score$getMaxFollowThroughScore() + obj.score$getMaxSwingInScore() + 15);
        }
    }

    private void checkSaber(PhysicalGameplayObject<? extends GameplayObject> obj, Vector3f pos, Quaternionf rot, Vector3f vel, NoteType expectedNoteType) {
        Matrix4f t = obj.getWorldTransform();
        t.invert(invTransform);
        SABER_TIP_OFFSET.rotate((Quaternionfc)rot, tipPos).add((Vector3fc)pos);
        invTransform.transformPosition((Vector3fc)pos, localBase);
        invTransform.transformPosition((Vector3fc)tipPos, localTip);
        vel.rotate((Quaternionfc)invTransform.getNormalizedRotation(q0), localVel);
        Hitbox gc = obj.getGoodCutBounds();
        Hitbox bc = obj.getBadCutBounds();
        Hitbox ac = obj.getAccurateHitbox();
        if (BeatcraftClient.playerConfig.debug.beatmap.renderSaberColliders()) {
            DebugRenderer.renderParticle(new Vector3f((Vector3fc)localBase), DebugRenderer.GREEN_DUST);
            DebugRenderer.renderParticle(obj.getWorldPos(new Vector3f()), DebugRenderer.ORANGE_DUST);
            DebugRenderer.renderParticle(new Vector3f((Vector3fc)localTip), DebugRenderer.MAGENTA_DUST);
            DebugRenderer.renderLine(new Vector3f((Vector3fc)tipPos), tipPos.add((Vector3fc)vel, new Vector3f()), -16711936, 0x7FFF0000);
            DebugRenderer.renderLine(new Vector3f((Vector3fc)localTip), localTip.add((Vector3fc)localVel, new Vector3f()), 0x7F007F00, 654343936);
            int c = 0x7F000000 + (expectedNoteType == NoteType.BLUE ? 255 : 0xFF0000);
            DebugRenderer.renderLine(new Vector3f((Vector3fc)localBase), new Vector3f((Vector3fc)localTip), c, Integer.MAX_VALUE);
            DebugRenderer.renderHitbox(gc, new Vector3f(), new Quaternionf(), 65280);
            DebugRenderer.renderHitbox(bc, new Vector3f(), new Quaternionf(), 0xFF0000);
        }
        if (BeatcraftClient.playerConfig.debug.beatmap.renderHitboxes()) {
            Matrix4f wt = obj.getWorldTransform();
            Vector3f wp = wt.getTranslation(new Vector3f());
            Quaternionf wr = wt.getNormalizedRotation(new Quaternionf());
            DebugRenderer.renderHitbox(gc, wp, wr, 65280);
            DebugRenderer.renderHitbox(bc, wp, wr, 0xFF0000);
            DebugRenderer.renderHitbox(ac, wp, wr, 0x7F7F7F);
        }
        if (this.failAnim) {
            return;
        }
        if (obj instanceof PhysicalScorableObject) {
            PhysicalScorableObject scorable = (PhysicalScorableObject)((Object)obj);
            this.processNote(scorable, gc, bc, expectedNoteType, vel);
        } else if (obj instanceof PhysicalBombNote) {
            PhysicalBombNote bombNote = (PhysicalBombNote)obj;
            if (bc.isPointInHitbox(localTip)) {
                obj.cutNote();
                this.processBadCut(0);
            }
        }
    }

    private static boolean isPointingDown(Vector3f velocity) {
        if (velocity.lengthSquared() == 0.0f) {
            return false;
        }
        dir.set((Vector3fc)velocity).normalize();
        float dot = dir.dot((Vector3fc)DOWN);
        return dot >= 0.7071f;
    }

    private void calculateScore(PhysicalScorableObject colorNote, Vector3f velocity, Vector3f base, Vector3f tip) {
        Vector3f normal = BeatmapLogicController.getPlaneNormal(base, tip, velocity, new Vector3f());
        float dist = BeatmapLogicController.distanceToOrigin(tip, normal);
        float angle = (float)(colorNote.score$getMaxSwingInAngle() + colorNote.score$getMaxFollowThroughAngle()) * ((float)Math.PI / 180);
        int angleScore = colorNote.score$getMaxSwingInScore() + colorNote.score$getMaxFollowThroughScore();
        int accPoints = (int)Math.clamp(15.0f * (1.0f - MathUtil.inverseLerp(0.0f, 0.25f, dist)), 0.0f, 15.0f);
        int swingPoints = (int)Math.clamp((double)angleScore * MathUtil.inverseLerp(0.0, Math.PI * (double)angle, (double)velocity.length()), 0.0, 100.0);
        colorNote.score$setScoreState(ScoreState.goodCut(accPoints + swingPoints));
        this.processGoodCut(accPoints + swingPoints, angleScore);
    }

    public void checkObstacle(PhysicalObstacle obstacle, Vector3f position, Quaternionf rotation) {
        Hitbox hitbox = obstacle.getBounds();
        rotation.invert(q0);
        BeatmapLogicController.checkSaberAgainstObstacle(hitbox, position, q0, this.rightSaberPos, this.rightSaberRotation, NoteType.BLUE);
        BeatmapLogicController.checkSaberAgainstObstacle(hitbox, position, q0, this.leftSaberPos, this.leftSaberRotation, NoteType.RED);
        this.headPos.sub((Vector3fc)position, localHeadPos).rotate((Quaternionfc)q0);
        if (!this.controller.isInWall) {
            this.controller.isInWall = hitbox.isPointInHitbox(localHeadPos);
        }
    }

    private static void checkSaberAgainstObstacle(Hitbox hitbox, Vector3f position, Quaternionf inv, Vector3f saberPos, Quaternionf saberRot, NoteType saber) {
        SABER_TIP_OFFSET.rotate((Quaternionfc)saberRot, localTip).add((Vector3fc)saberPos);
        saberPos.sub((Vector3fc)position, localBase).rotate((Quaternionfc)inv);
        localTip.sub((Vector3fc)position).rotate((Quaternionfc)inv);
        if (hitbox.checkCollision(localBase, localTip)) {
            if (saber.equals((Object)NoteType.BLUE)) {
                HapticsHandler.vibrateRight(0.25f, 1.0f);
            } else {
                HapticsHandler.vibrateLeft(0.25f, 1.0f);
            }
        }
    }

    public static Vector3f getPlaneNormal(Vector3f start, Vector3f end, Vector3f velocity, Vector3f dest) {
        Vector3f s1 = end.sub((Vector3fc)start, dest);
        Vector3f cross = s1.cross((Vector3fc)velocity);
        return cross.normalize();
    }

    public static float distanceToOrigin(Vector3f planeIncident, Vector3f planeNormal) {
        return Math.abs(planeNormal.dot((Vector3fc)planeIncident)) / planeNormal.length();
    }

    private void processDamage(float damage) {
        this.health = this.maxHealth == 100 ? (this.health -= damage) : (this.maxHealth == 4 ? (this.health -= 1.0f) : 0.0f);
    }

    private void checkFail() {
        if (this.health <= 0.0f && !this.failed) {
            this.health = 0.0f;
            this.failed = true;
            if (!this.noFail) {
                this.failAnim = true;
                this.failTime = (double)System.nanoTime() / 1.0E9;
            }
        }
    }

    private void resetToMenu() {
        this.unloadAll();
    }

    public float getModifierPercentage() {
        return (float)this.modifierProgress / (float)this.bonusModifier;
    }

    public float getComboBarOpacity() {
        if (this.badCuts == 0 && this.misses == 0) {
            return 1.0f;
        }
        return 1.0f - (float)Math.clamp(MathUtil.inverseLerp(this.loseFCTime, this.loseFCTime + 0.3, (double)System.nanoTime() / 1.0E9), 0.0, 1.0);
    }

    public Rank getRank() {
        float acc = this.getAccuracy() * 100.0f;
        if (acc < 20.0f) {
            return Rank.E;
        }
        if (acc < 35.0f) {
            return Rank.D;
        }
        if (acc < 50.0f) {
            return Rank.C;
        }
        if (acc < 65.0f) {
            return Rank.B;
        }
        if (acc < 80.0f) {
            return Rank.A;
        }
        if (acc < 90.0f) {
            return Rank.S;
        }
        return Rank.SS;
    }

    private void breakCombo() {
        this.combo = 0;
        this.modifierProgress = 0;
        if (this.bonusModifier > 1) {
            this.bonusModifier /= 2;
        }
    }

    private void unloadAll() {
        this.controller.reset();
        this.reset();
    }

    public void reset() {
        this.score = 0;
        this.maxPossibleScore = 0;
        this.combo = 0;
        this.maxCombo = 0;
        this.bonusModifier = 1;
        this.goodCuts = 0;
        this.loseFCTime = 0.0;
        this.badCuts = 0;
        this.misses = 0;
        this.failed = false;
        this.health = this.maxHealth == 100 ? 50.0f : (this.maxHealth == 4 ? 4.0f : 1.0f);
        this.controller.isInWall = false;
        this.failTime = 0.0;
        this.failAnim = false;
        this.globalDissolve = 0.0f;
        this.globalArrowDissolve = 0.0f;
    }

    public void processGoodCut(int score, int maxScore) {
        this.addGoodCut();
        this.incrementCombo();
        this.addScore(score, maxScore);
    }

    public void processBadCut(int maxScore) {
        if (this.misses == 0 && this.badCuts == 0) {
            this.loseFCTime = (double)System.nanoTime() / 1.0E9;
        }
        this.addBadCut();
        this.breakCombo();
        this.addScore(0, maxScore);
    }

    public void processNoCut(int maxScore) {
        if (this.misses == 0 && this.badCuts == 0) {
            this.loseFCTime = (double)System.nanoTime() / 1.0E9;
        }
        this.addMiss();
        this.breakCombo();
        this.addScore(0, maxScore);
    }

    public void addGoodCut() {
        ++this.goodCuts;
        if (!(this.maxHealth != 100 || this.failed && this.noFail)) {
            this.health = Math.min((float)this.maxHealth, this.health + 5.0f);
        }
    }

    public void addMiss() {
        ++this.misses;
        if (this.failed && this.noFail) {
            return;
        }
        this.processDamage(15.0f);
        this.checkFail();
    }

    public void addBadCut() {
        ++this.badCuts;
        if (this.failed && this.noFail) {
            return;
        }
        this.processDamage(10.0f);
        this.checkFail();
    }

    public void hitBomb() {
        ++this.badCuts;
        if (this.failed && this.noFail) {
            return;
        }
        this.processDamage(10.0f);
        this.checkFail();
    }

    public void incrementCombo() {
        ++this.combo;
        this.maxCombo = Math.max(this.combo, this.maxCombo);
        if (this.bonusModifier < 8) {
            ++this.modifierProgress;
            if (this.modifierProgress == this.bonusModifier) {
                this.bonusModifier *= 2;
                this.modifierProgress = 0;
            }
        }
    }

    public void addScore(int earned, int possible) {
        this.score += earned * this.bonusModifier;
        this.maxPossibleScore += possible * this.bonusModifier;
    }

    public void triggerSongEnd() {
        this.controller.scene = HUDRenderer.MenuScene.EndScreen;
        this.controller.hudRenderer.endScreenPanel.setData(new EndScreenData(this.controller.hudRenderer, this.getScore(), this.getRank(), this.maxCombo, this.goodCuts, this.getAccuracy() * 100.0f, this.goodCuts + this.badCuts + this.misses));
        try {
            this.controller.playRecorder.save();
        }
        catch (IOException e) {
            Beatcraft.LOGGER.error("Error saving recording", (Throwable)e);
        }
        this.unloadAll();
    }
}

