/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.beatmap;

import com.beatcraft.client.BeatcraftClient;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.Difficulty;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.beatcraft.client.render.effect.Bloomfog;
import com.beatcraft.client.render.effect.MirrorHandler;
import com.beatcraft.client.render.effect.ObstacleGlowRenderer;
import com.beatcraft.client.render.instancing.debug.TransformationWidgetInstanceData;
import com.beatcraft.client.render.instancing.lightshow.light_object.LightMesh;
import com.beatcraft.client.render.mesh.MeshLoader;
import com.beatcraft.common.utils.MathUtil;
import com.beatcraft.mixin_utils.BufferBuilderAccessor;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.ArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BeatmapRenderer {
    private final BeatmapController mapController;
    public RenderStyle renderStyle;
    public boolean doSkyEffects = true;
    public boolean skipWorldRender = false;
    public final ArrayList<TriConsumer<Matrix4f, BufferBuilder, Vector3f>> bloomfogPosColCalls = new ArrayList();
    public final ArrayList<Runnable> renderCalls = new ArrayList();
    public final ArrayList<TriConsumer<BufferBuilder, Vector3f, Integer>> obstacleRenderCalls = new ArrayList();
    public final ArrayList<BiConsumer<BufferBuilder, Vector3f>> laserRenderCalls = new ArrayList();
    public final ArrayList<BiConsumer<BufferBuilder, Vector3f>> laserPreRenderCalls = new ArrayList();
    public final ArrayList<BiConsumer<BufferBuilder, Vector3f>> lightRenderCalls = new ArrayList();
    public final ArrayList<BiConsumer<BufferBuilder, Vector3f>> arcRenderCalls = new ArrayList();

    public BeatmapRenderer(BeatmapController map, RenderStyle style) {
        this.mapController = map;
        this.renderStyle = style;
    }

    public void recordObstacleRenderCall(TriConsumer<BufferBuilder, Vector3f, Integer> call) {
        this.obstacleRenderCalls.add(call);
    }

    public void recordMirroredObstacleRenderCall(TriConsumer<BufferBuilder, Vector3f, Integer> call) {
    }

    public void recordRenderCall(Runnable call) {
        this.renderCalls.add(call);
    }

    public void recordArcRenderCall(BiConsumer<BufferBuilder, Vector3f> call) {
        this.arcRenderCalls.add(call);
    }

    public void recordLaserRenderCall(BiConsumer<BufferBuilder, Vector3f> call) {
        this.laserRenderCalls.add(call);
    }

    public void recordLaserPreRenderCall(BiConsumer<BufferBuilder, Vector3f> call) {
        this.laserPreRenderCalls.add(call);
    }

    public void recordLightRenderCall(BiConsumer<BufferBuilder, Vector3f> call) {
        this.lightRenderCalls.add(call);
    }

    public void recordBloomfogPosColCall(TriConsumer<Matrix4f, BufferBuilder, Vector3f> call) {
        this.bloomfogPosColCalls.add(call);
    }

    public void recordPlainMirrorCall(BiConsumer<BufferBuilder, Vector3f> call) {
    }

    private void renderLightDepth(Tesselator tesselator, Vector3f cameraPos) {
        BeatcraftRenderer.bloomfog.overrideBuffer = true;
        BeatcraftRenderer.bloomfog.overrideFramebuffer = Bloomfog.lightDepth;
        Bloomfog.lightDepth.bindWrite(true);
        Bloomfog.lightDepth.setClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Bloomfog.lightDepth.clear(Minecraft.ON_OSX);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        for (BiConsumer<BufferBuilder, Vector3f> call : this.lightRenderCalls) {
            call.accept((Object)buffer, (Object)cameraPos);
        }
        MeshData buff = buffer.build();
        if (buff != null) {
            BufferUploader.drawWithShader((MeshData)buff);
        }
        Bloomfog.lightDepth.unbindWrite();
        BeatcraftRenderer.bloomfog.overrideFramebuffer = null;
        BeatcraftRenderer.bloomfog.overrideBuffer = false;
        Minecraft.getInstance().getMainRenderTarget().bindWrite(true);
    }

    private void renderBloomfogPosCol(Matrix4f transform, Tesselator tesselator, Vector3f cameraPos) {
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        for (TriConsumer<Matrix4f, BufferBuilder, Vector3f> call : this.bloomfogPosColCalls) {
            call.accept((Object)transform, (Object)buffer, (Object)cameraPos);
        }
        this.bloomfogPosColCalls.clear();
        MeshData buff = buffer.build();
        if (buff != null) {
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.setShader(() -> Bloomfog.bloomfogPositionColor);
            BeatcraftRenderer.bloomfog.loadTex();
            BufferUploader.drawWithShader((MeshData)buff);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableDepthTest();
        }
    }

    private void renderEnvironmentLights(Tesselator tesselator, Vector3f cameraPos) {
        Matrix4f worldTransform = new Matrix4f();
        worldTransform.translate((Vector3fc)cameraPos);
        worldTransform.rotate((Quaternionfc)MirrorHandler.invCameraRotation.conjugate(new Quaternionf()));
        this.renderLightDepth(tesselator, cameraPos);
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.setShader(() -> Bloomfog.backlightsPositionColorShader);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        for (BiConsumer<BufferBuilder, Vector3f> call : this.lightRenderCalls) {
            call.accept((Object)buffer, (Object)cameraPos);
        }
        this.lightRenderCalls.clear();
        MeshData buff = buffer.build();
        if (buff != null) {
            Bloomfog.backlightsPositionColorShader.setSampler("Sampler0", (Object)Bloomfog.lightDepth.getDepthTextureId());
            RenderSystem.setShaderTexture((int)0, (int)Bloomfog.lightDepth.getDepthTextureId());
            Bloomfog.backlightsPositionColorShader.safeGetUniform("WorldTransform").set(worldTransform);
            Bloomfog.backlightsPositionColorShader.safeGetUniform("u_fog").set(Bloomfog.getFogHeights(this.mapController.worldPosition));
            BufferUploader.drawWithShader((MeshData)buff);
        }
        LightMesh.renderAllSolid();
        RenderSystem.defaultBlendFunc();
    }

    private void renderFloorLightsPhase1(Tesselator tesselator, Vector3f cameraPos) {
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        for (BiConsumer<BufferBuilder, Vector3f> call : this.laserPreRenderCalls) {
            call.accept((Object)buffer, (Object)cameraPos);
        }
        this.laserPreRenderCalls.clear();
        MeshData buff = buffer.build();
        if (buff == null) {
            return;
        }
        buff.sortQuads(((BufferBuilderAccessor)buffer).beatcraft$getAllocator(), VertexSorting.DISTANCE_TO_ORIGIN);
        BufferUploader.drawWithShader((MeshData)buff);
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    private void renderFloorLights(Tesselator tesselator, Vector3f cameraPos) {
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        for (BiConsumer<BufferBuilder, Vector3f> call : this.laserRenderCalls) {
            call.accept((Object)buffer, (Object)cameraPos);
        }
        this.laserRenderCalls.clear();
        MeshData buff = buffer.build();
        if (buff == null) {
            return;
        }
        buff.sortQuads(((BufferBuilderAccessor)buffer).beatcraft$getAllocator(), VertexSorting.DISTANCE_TO_ORIGIN);
        BufferUploader.drawWithShader((MeshData)buff);
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    private void renderObstacles(Tesselator tesselator, Vector3f cameraPos) {
        if (this.mapController.difficulty == null) {
            this.obstacleRenderCalls.clear();
            return;
        }
        int color = this.mapController.difficulty.getSetDifficulty().getColorScheme().getObstacleColor().toARGB(0.15f);
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        for (TriConsumer<BufferBuilder, Vector3f, Integer> call : this.obstacleRenderCalls) {
            call.accept((Object)buffer, (Object)cameraPos, (Object)color);
        }
        this.obstacleRenderCalls.clear();
        MeshData buff = buffer.build();
        if (buff != null) {
            ObstacleGlowRenderer.grabScreen();
            RenderSystem.disableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.depthMask((boolean)true);
            TextureTarget scene = ObstacleGlowRenderer.framebuffer;
            RenderSystem.setShader(() -> ObstacleGlowRenderer.distortionShader);
            RenderSystem.setShaderTexture((int)0, (int)scene.getColorTextureId());
            ObstacleGlowRenderer.distortionShader.safeGetUniform("Time").set((float)System.nanoTime() / 1.0E9f);
            buff.sortQuads(((BufferBuilderAccessor)buffer).beatcraft$getAllocator(), VertexSorting.DISTANCE_TO_ORIGIN);
            BufferUploader.drawWithShader((MeshData)buff);
            RenderSystem.disableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
        }
    }

    public void pre_render(PoseStack matrices, Difficulty difficulty, Camera camera, float distance) {
        Tesselator tesselator = Tesselator.getInstance();
        Vector3f cameraPos = camera.getPosition().toVector3f();
        Matrix4f m = matrices.last().pose();
        this.renderBloomfogPosCol(m, tesselator, cameraPos);
        this.renderEnvironmentLights(tesselator, cameraPos);
        float alpha = 0.0f;
        switch (this.renderStyle.ordinal()) {
            case 1: {
                if (distance <= 10.0f) {
                    alpha = 1.0f;
                    break;
                }
                alpha = Math.clamp(MathUtil.inverseLerp(300.0f, 0.0f, distance - 10.0f), 0.0f, 1.0f);
                break;
            }
            case 0: {
                float f = alpha = BeatcraftClient.wearingHeadset ? 1.0f : 0.0f;
            }
        }
        if (difficulty != null) {
            difficulty.render(matrices, camera, alpha);
        }
        this.renderFloorLightsPhase1(tesselator, cameraPos);
        this.renderFloorLights(tesselator, cameraPos);
        if (BeatcraftClient.playerConfig.debug.beatmap.renderBeatmapPosition()) {
            MeshLoader.MATRIX_LOCATOR_MESH.draw(TransformationWidgetInstanceData.create(m));
        }
    }

    public void render(PoseStack matrices, Difficulty difficulty, Camera camera, float distance) {
        Tesselator tesselator = Tesselator.getInstance();
        Vector3f cameraPos = camera.getPosition().toVector3f();
        this.renderObstacles(tesselator, cameraPos);
    }

    public static enum RenderStyle {
        HEADSET,
        DISTANCE;

    }
}

