/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.beatmap.data;

import com.beatcraft.client.animation.event.AnimatedPathEventContainer;
import com.beatcraft.client.animation.event.AnimatedPropertyEventContainer;
import com.beatcraft.client.animation.track.TrackLibrary;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.Info;
import com.beatcraft.client.beatmap.data.NoteType;
import com.beatcraft.client.beatmap.data.event.AnimateTrack;
import com.beatcraft.client.beatmap.data.event.AssignPathAnimation;
import com.beatcraft.client.beatmap.data.event.AssignTrackParent;
import com.beatcraft.client.beatmap.data.event.AssignTrackParentHandler;
import com.beatcraft.client.beatmap.data.event.RotationEvent;
import com.beatcraft.client.beatmap.data.event.RotationEventHandler;
import com.beatcraft.client.beatmap.object.data.Arc;
import com.beatcraft.client.beatmap.object.data.BeatmapObject;
import com.beatcraft.client.beatmap.object.data.BombNote;
import com.beatcraft.client.beatmap.object.data.ChainNoteHead;
import com.beatcraft.client.beatmap.object.data.ChainNoteLink;
import com.beatcraft.client.beatmap.object.data.GameplayObject;
import com.beatcraft.client.beatmap.object.data.Obstacle;
import com.beatcraft.client.beatmap.object.physical.PhysicalArc;
import com.beatcraft.client.beatmap.object.physical.PhysicalBombNote;
import com.beatcraft.client.beatmap.object.physical.PhysicalChainNoteHead;
import com.beatcraft.client.beatmap.object.physical.PhysicalChainNoteLink;
import com.beatcraft.client.beatmap.object.physical.PhysicalColorNote;
import com.beatcraft.client.beatmap.object.physical.PhysicalGameplayObject;
import com.beatcraft.client.beatmap.object.physical.PhysicalObstacle;
import com.beatcraft.client.lightshow.environment.Environment;
import com.beatcraft.client.render.lightshow_event_visualizer.EventVisualizer;
import com.beatcraft.common.event.EventHandler;
import com.google.gson.JsonArray;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Camera;
import org.joml.Math;
import org.joml.Quaternionf;

public abstract class Difficulty {
    public final BeatmapController mapController;
    private final Info info;
    private final Info.SetDifficulty setDifficulty;
    private final TrackLibrary trackLibrary = new TrackLibrary();
    public final ArrayList<PhysicalColorNote> colorNotes = new ArrayList();
    public final ArrayList<PhysicalBombNote> bombNotes = new ArrayList();
    public final ArrayList<PhysicalChainNoteHead> chainHeadNotes = new ArrayList();
    public final ArrayList<PhysicalChainNoteLink> chainLinkNotes = new ArrayList();
    public final ArrayList<PhysicalObstacle> obstacles = new ArrayList();
    public final ArrayList<PhysicalArc> arcs = new ArrayList();
    public final ArrayList<RotationEvent> rotationEvents = new ArrayList();
    public final ArrayList<AnimateTrack> animateTracks = new ArrayList();
    public final ArrayList<AssignPathAnimation> assignPathAnimations = new ArrayList();
    public final ArrayList<AssignTrackParent> assignTrackParents = new ArrayList();
    public final AssignTrackParentHandler parentHandler = new AssignTrackParentHandler(this.assignTrackParents, this.trackLibrary);
    public final HashMap<String, JsonArray> pointDefinitions = new HashMap();
    public float firstBeat = Float.MAX_VALUE;
    public Environment lightShowEnvironment;

    public Difficulty(BeatmapController controller, Info info, Info.SetDifficulty setDifficulty) {
        this.mapController = controller;
        this.info = info;
        this.setDifficulty = setDifficulty;
    }

    public static int compareObjects(BeatmapObject o1, BeatmapObject o2) {
        float b;
        float a = o1.getBeat();
        if (a == (b = o2.getBeat())) {
            return 0;
        }
        return a > b ? 1 : -1;
    }

    private void indexObjects() {
        int i = 0;
        for (PhysicalColorNote note : this.colorNotes) {
            note.getData().setIndex(i++);
        }
        i = 0;
        for (PhysicalBombNote bomb : this.bombNotes) {
            ((BombNote)bomb.getData()).setIndex(i++);
        }
        i = 0;
        for (PhysicalChainNoteHead head : this.chainHeadNotes) {
            ((ChainNoteHead)head.getData()).setIndex(i++);
        }
        i = 0;
        for (PhysicalChainNoteLink link : this.chainLinkNotes) {
            ((ChainNoteLink)link.getData()).setIndex(i++);
        }
        i = 0;
        for (PhysicalObstacle wall : this.obstacles) {
            ((Obstacle)wall.getData()).setIndex(i++);
        }
        i = 0;
        for (PhysicalArc arc : this.arcs) {
            ((Arc)arc.getData()).setIndex(i++);
        }
    }

    private void sortObjectsByTime() {
        this.colorNotes.sort((o1, o2) -> Difficulty.compareObjects(o1.getData(), o2.getData()));
        this.bombNotes.sort((o1, o2) -> Difficulty.compareObjects(o1.getData(), o2.getData()));
        this.chainHeadNotes.sort((o1, o2) -> Difficulty.compareObjects(o1.getData(), o2.getData()));
        this.chainLinkNotes.sort((o1, o2) -> Difficulty.compareObjects(o1.getData(), o2.getData()));
        this.obstacles.sort((o1, o2) -> Difficulty.compareObjects(o1.getData(), o2.getData()));
        this.arcs.sort((o1, o2) -> Difficulty.compareObjects(o1.getData(), o2.getData()));
        this.rotationEvents.sort(Difficulty::compareObjects);
        this.animateTracks.sort(Difficulty::compareObjects);
        this.assignPathAnimations.sort(Difficulty::compareObjects);
        if (!this.colorNotes.isEmpty()) {
            this.firstBeat = Math.min((float)this.firstBeat, (float)this.colorNotes.getFirst().getData().getBeat());
        }
        if (!this.chainHeadNotes.isEmpty()) {
            this.firstBeat = Math.min((float)this.firstBeat, (float)((ChainNoteHead)this.chainHeadNotes.getFirst().getData()).getBeat());
        }
        if (!this.chainLinkNotes.isEmpty()) {
            this.firstBeat = Math.min((float)this.firstBeat, (float)((ChainNoteLink)this.chainLinkNotes.getFirst().getData()).getBeat());
        }
    }

    private void applyRotationEvents() {
        RotationEventHandler eventHandler = new RotationEventHandler(this.rotationEvents);
        this.applyRotationOnArray(eventHandler, this.colorNotes);
        this.applyRotationOnArray(eventHandler, this.bombNotes);
        this.applyRotationOnArray(eventHandler, this.chainHeadNotes);
        this.applyRotationOnArray(eventHandler, this.chainLinkNotes);
        this.applyRotationOnArray(eventHandler, this.obstacles);
        this.applyRotationOnArray(eventHandler, this.arcs);
    }

    private <T extends PhysicalGameplayObject<K>, K extends GameplayObject> void applyRotationOnArray(EventHandler<Float, RotationEvent> eventHandler, ArrayList<T> array) {
        eventHandler.reset();
        array.forEach(o -> {
            float beat = ((BeatmapObject)o.getData()).getBeat();
            float rotation = ((Float)eventHandler.update(beat)).floatValue();
            if (rotation != 0.0f) {
                o.setLaneRotation(new Quaternionf().rotateY(Math.toRadians((float)rotation)));
            }
        });
    }

    private void checkNotesWindowSnap() {
        Map<NoteType, List<PhysicalColorNote>> noteTypes = this.colorNotes.stream().collect(Collectors.groupingBy(o -> o.getData().getNoteType()));
        noteTypes.forEach((type, typedNotes) -> {
            Map<Float, List<PhysicalColorNote>> timeGroups = typedNotes.stream().collect(Collectors.groupingBy(o -> Float.valueOf(o.getData().getBeat())));
            timeGroups.forEach((time, notes) -> {
                if (notes.size() != 2) {
                    return;
                }
                PhysicalColorNote a = (PhysicalColorNote)notes.get(0);
                PhysicalColorNote b = (PhysicalColorNote)notes.get(1);
                a.checkWindowSnap(b);
                b.checkWindowSnap(a);
            });
        });
    }

    private void finalizeBaseRotations() {
        this.colorNotes.forEach(PhysicalColorNote::finalizeBaseRotation);
        this.chainHeadNotes.forEach(PhysicalChainNoteHead::finalizeBaseRotation);
        this.chainLinkNotes.forEach(PhysicalChainNoteLink::finalizeBaseRotation);
    }

    private void setupAnimatedProperties() {
        this.animateTracks.forEach(event -> {
            AnimatedPropertyEventContainer animatedPropertyEvents = event.toAnimatedPropertyEvents();
            event.getTracks().forEach(track -> track.loadAnimatedPropertyEvents(animatedPropertyEvents));
        });
        this.assignPathAnimations.forEach(event -> {
            AnimatedPathEventContainer animatedPathEvents = event.toAnimatedPathEvents();
            event.getTracks().forEach(track -> track.loadAnimatedPathEvents(animatedPathEvents));
        });
    }

    protected void doPostLoad() {
        this.sortObjectsByTime();
        this.checkNotesWindowSnap();
        this.finalizeBaseRotations();
        this.applyRotationEvents();
        this.setupAnimatedProperties();
        this.indexObjects();
    }

    public Info getInfo() {
        return this.info;
    }

    public Info.SetDifficulty getSetDifficulty() {
        return this.setDifficulty;
    }

    public void render(PoseStack matrices, Camera camera, float alpha) {
        matrices.pushPose();
        if (this.lightShowEnvironment != null) {
            this.lightShowEnvironment.render(matrices, camera, alpha);
        }
        if (this.mapController.isModifierActive("Zen Mode")) {
            return;
        }
        this.colorNotes.forEach(o -> o.render(matrices, camera, alpha));
        if (!this.mapController.isModifierActive("No Bombs")) {
            this.bombNotes.forEach(o -> o.render(matrices, camera, alpha));
        }
        this.chainHeadNotes.forEach(o -> o.render(matrices, camera, alpha));
        this.chainLinkNotes.forEach(o -> o.render(matrices, camera, alpha));
        if (!this.mapController.isModifierActive("No Walls")) {
            this.obstacles.forEach(o -> o.render(matrices, camera, alpha));
        }
        this.arcs.forEach(o -> o.render(matrices, camera, alpha));
        matrices.popPose();
    }

    public void seek(float beat) {
        this.trackLibrary.seek(beat);
        this.parentHandler.seek(beat);
        if (this.lightShowEnvironment != null) {
            this.lightShowEnvironment.seek(beat);
        }
        this.colorNotes.forEach(o -> o.seek(beat));
        this.bombNotes.forEach(o -> o.seek(beat));
        this.chainHeadNotes.forEach(o -> o.seek(beat));
        this.chainLinkNotes.forEach(o -> o.seek(beat));
        this.obstacles.forEach(o -> o.seek(beat));
        this.arcs.forEach(o -> o.seek(beat));
        this.mapController.playRecorder.seek(beat);
        this.mapController.replayer.seek(beat);
    }

    public void update(float beat, double deltaTime) {
        this.trackLibrary.update(beat);
        this.parentHandler.update(beat);
        this.mapController.baseProvider.update();
        if (this.lightShowEnvironment != null) {
            this.lightShowEnvironment.update(beat, deltaTime);
            EventVisualizer.update(beat);
        }
        if (this.mapController.isModifierActive("Zen Mode")) {
            return;
        }
        this.colorNotes.forEach(o -> o.update(beat));
        if (!this.mapController.isModifierActive("No Bombs")) {
            this.bombNotes.forEach(o -> o.update(beat));
        }
        this.chainHeadNotes.forEach(o -> o.update(beat));
        this.chainLinkNotes.forEach(o -> o.update(beat));
        if (!this.mapController.isModifierActive("No Walls")) {
            this.obstacles.forEach(o -> o.update(beat));
        }
        this.arcs.forEach(o -> o.update(beat));
        this.mapController.playRecorder.update(beat);
        this.mapController.replayer.update(beat);
    }

    public TrackLibrary getTrackLibrary() {
        return this.trackLibrary;
    }
}

