/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.beatmap.data.event;

import com.beatcraft.client.animation.Animation;
import com.beatcraft.client.animation.Easing;
import com.beatcraft.client.animation.event.AnimatedPathEventContainer;
import com.beatcraft.client.animation.track.Track;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.Difficulty;
import com.beatcraft.client.beatmap.object.data.BeatmapObject;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.util.GsonHelper;

public class AssignPathAnimation
extends BeatmapObject {
    private ArrayList<Track> tracks;
    private float duration;
    private Function<Float, Float> easing;
    private final Animation animation;

    public AssignPathAnimation(BeatmapController map) {
        this.animation = new Animation(map);
    }

    @Override
    public AssignPathAnimation loadV2(JsonObject json, Difficulty difficulty) {
        super.loadV2(json, difficulty);
        JsonObject data = json.getAsJsonObject("_data");
        this.duration = GsonHelper.getAsFloat((JsonObject)data, (String)"_duration", (float)0.0f);
        if (data.has("_easing")) {
            this.easing = Easing.getEasing(data.get("_easing").getAsString());
        }
        JsonElement trackElement = data.get("_track");
        this.tracks = Track.getTracksAsList(trackElement, difficulty.getTrackLibrary());
        this.animation.loadV2(data, difficulty);
        return this;
    }

    @Override
    public AssignPathAnimation loadV3(JsonObject json, Difficulty difficulty) {
        super.loadV3(json, difficulty);
        JsonObject data = json.getAsJsonObject("d");
        this.duration = GsonHelper.getAsFloat((JsonObject)data, (String)"duration", (float)0.0f);
        if (data.has("easing")) {
            this.easing = Easing.getEasing(data.get("easing").getAsString());
        }
        JsonElement trackElement = data.get("track");
        this.tracks = Track.getTracksAsList(trackElement, difficulty.getTrackLibrary());
        this.animation.loadV3(data, difficulty);
        return this;
    }

    public float getDuration() {
        return this.duration;
    }

    public Function<Float, Float> getEasing() {
        return this.easing;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public ArrayList<Track> getTracks() {
        return this.tracks;
    }

    public AnimatedPathEventContainer toAnimatedPathEvents() {
        return this.animation.toAnimatedPathEvents(this);
    }
}

