/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.beatmap.object.physical;

import com.beatcraft.client.animation.AnimationState;
import com.beatcraft.client.animation.Easing;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.object.data.Obstacle;
import com.beatcraft.client.beatmap.object.physical.PhysicalGameplayObject;
import com.beatcraft.client.logic.Hitbox;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.beatcraft.client.render.effect.ObstacleGlowRenderer;
import com.beatcraft.common.data.types.Color;
import com.beatcraft.common.memory.MemoryPool;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Camera;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PhysicalObstacle
extends PhysicalGameplayObject<Obstacle> {
    private final Hitbox bounds = new Hitbox(new Vector3f(-0.3f, 0.0f, 0.0f), new Vector3f(0.3f, 0.0f, 0.0f));
    private static final Vector3f MODEL_OFFSET = new Vector3f();

    public PhysicalObstacle(BeatmapController map, Obstacle data) {
        super(map, data);
    }

    @Override
    protected Quaternionf getJumpsRotation(float spawnLifetime) {
        return new Quaternionf();
    }

    @Override
    protected Vector3f getModelOffset() {
        return MODEL_OFFSET;
    }

    @Override
    protected void objectRender(PoseStack matrices, Camera camera, AnimationState animationState, float alpha) {
        Vector3f localPos = matrices.last().pose().getTranslation(MemoryPool.newVector3f());
        Quaternionf rotation = matrices.last().pose().getUnnormalizedRotation(MemoryPool.newQuaternionf());
        Vector3f scale = matrices.last().pose().getScale(MemoryPool.newVector3f());
        this.updateBounds(scale);
        Vector3f camPos = MemoryPool.newVector3f(PhysicalObstacle.mc.gameRenderer.getMainCamera().getPosition());
        MemoryPool.release(camPos);
        this.mapController.checkObstacle(this, localPos, rotation);
        this.render(MemoryPool.newVector3f(localPos), MemoryPool.newQuaternionf(rotation));
        this.renderMirrored(MemoryPool.newVector3f(localPos), MemoryPool.newQuaternionf(rotation));
        ObstacleGlowRenderer.render(this.mapController, MemoryPool.newVector3f(localPos), MemoryPool.newQuaternionf(rotation), this.bounds, new Color(((Obstacle)this.data).getColor()).withAlpha(alpha).toARGB());
        ObstacleGlowRenderer.renderMirrored(this.mapController, localPos, rotation, this.bounds, new Color(((Obstacle)this.data).getColor()).withAlpha(alpha).toARGB());
    }

    @Override
    protected boolean doNoteLook() {
        return false;
    }

    @Override
    protected boolean doNoteGravity() {
        return false;
    }

    private void render(Vector3f pos, Quaternionf orientation) {
        this.mapController.recordObstacleRenderCall((TriConsumer<BufferBuilder, Vector3f, Integer>)((TriConsumer)(b, c, i) -> this._render((BufferBuilder)b, (Vector3f)c, (int)i, pos, orientation, false)));
    }

    private void renderMirrored(Vector3f pos, Quaternionf orientation) {
        Vector3f flippedPos = pos.mul(1.0f, -1.0f, 1.0f);
        Quaternionf flippedRot = MemoryPool.newQuaternionf(-orientation.x, orientation.y, -orientation.z, orientation.w);
        MemoryPool.release(orientation);
        this.mapController.recordMirroredObstacleRenderCall((TriConsumer<BufferBuilder, Vector3f, Integer>)((TriConsumer)(b, c, i) -> this._render((BufferBuilder)b, (Vector3f)c, (int)i, flippedPos, flippedRot, true)));
    }

    private void _render(BufferBuilder buffer, Vector3f cameraPos, int _color, Vector3f pos, Quaternionf orientation, boolean mirrored) {
        List<Vector3f[]> faces = BeatcraftRenderer.getCubeFaces(this.bounds.min, this.bounds.max);
        int color = ((Obstacle)this.data).getColor();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        Vector3f c1 = MemoryPool.newVector3f();
        Vector3f c2 = MemoryPool.newVector3f();
        Vector3f c3 = MemoryPool.newVector3f();
        Vector3f c4 = MemoryPool.newVector3f();
        for (Vector3f[] face : faces) {
            c1.set((Vector3fc)face[0]).mul(1.0f, mirrored ? -1.0f : 1.0f, 1.0f).rotate((Quaternionfc)orientation).add((Vector3fc)pos).sub((Vector3fc)cameraPos);
            c2.set((Vector3fc)face[1]).mul(1.0f, mirrored ? -1.0f : 1.0f, 1.0f).rotate((Quaternionfc)orientation).add((Vector3fc)pos).sub((Vector3fc)cameraPos);
            c3.set((Vector3fc)face[2]).mul(1.0f, mirrored ? -1.0f : 1.0f, 1.0f).rotate((Quaternionfc)orientation).add((Vector3fc)pos).sub((Vector3fc)cameraPos);
            c4.set((Vector3fc)face[3]).mul(1.0f, mirrored ? -1.0f : 1.0f, 1.0f).rotate((Quaternionfc)orientation).add((Vector3fc)pos).sub((Vector3fc)cameraPos);
            buffer.addVertex(c1.x, c1.y, c1.z).setColor(color).setUv(0.0f, 0.0f);
            buffer.addVertex(c2.x, c2.y, c2.z).setColor(color).setUv(0.0f, 1.0f);
            buffer.addVertex(c3.x, c3.y, c3.z).setColor(color).setUv(1.0f, 1.0f);
            buffer.addVertex(c4.x, c4.y, c4.z).setColor(color).setUv(1.0f, 0.0f);
        }
        MemoryPool.release(c1, c2, c3, c4);
        MemoryPool.release(pos);
        MemoryPool.release(orientation);
    }

    @Override
    protected Vector2f getJumpsXY(float lifetime) {
        float reverseSpawnTime = 1.0f - Math.abs((float)(lifetime - 0.5f)) * 2.0f;
        float jumpTime = Easing.easeOutQuad(reverseSpawnTime);
        Vector2f grid = this.get2DPosition();
        grid.y = Math.lerp((float)(this.doNoteGravity() ? -0.3f : grid.y), (float)grid.y, (float)jumpTime);
        return grid;
    }

    @Override
    protected Vector2f get2DPosition() {
        return new Vector2f(((Obstacle)this.data).getX() * 0.6f - 0.9f, ((Obstacle)this.data).getY() * 0.6f - 0.6f);
    }

    private void updateBounds(Vector3f scale) {
        this.bounds.min.x = -(((Obstacle)this.data).getWidth() * scale.x * 1.2f - 0.3f);
        this.bounds.max.y = ((Obstacle)this.data).getHeight() * scale.y * 1.2f;
        float length = ((Obstacle)this.data).getNjs() * (60.0f / this.mapController.getBpm(((Obstacle)this.data).getBeat()));
        this.bounds.max.z = ((Obstacle)this.data).getLength(length);
    }

    @Override
    public float getJumpOutPosition() {
        float length = ((Obstacle)this.data).getNjs() * (60.0f / this.mapController.getBpm(((Obstacle)this.data).getBeat()));
        return -((Obstacle)this.data).getLength(length);
    }

    @Override
    public float getJumpOutBeat() {
        return ((Obstacle)this.data).getBeat() + ((Obstacle)this.data).getDuration();
    }

    @Override
    public float getDespawnBeat() {
        return super.getDespawnBeat() + ((Obstacle)this.data).getDuration();
    }

    public Hitbox getBounds() {
        return this.bounds;
    }
}

