/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.lightshow.environment;

import com.beatcraft.client.animation.Easing;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.Difficulty;
import com.beatcraft.client.lightshow.environment.BoostableColor;
import com.beatcraft.client.lightshow.environment.Environment;
import com.beatcraft.client.lightshow.environment.lightgroup.LightGroupV3;
import com.beatcraft.client.lightshow.event.EventBuilder;
import com.beatcraft.client.lightshow.event.Filter;
import com.beatcraft.client.lightshow.event.events.ColorBoostEvent;
import com.beatcraft.client.lightshow.event.events.LightEventV3;
import com.beatcraft.client.lightshow.event.events.RotationEventV3;
import com.beatcraft.client.lightshow.event.events.TranslationEvent;
import com.beatcraft.client.lightshow.event.handlers.ColorBoostEventHandler;
import com.beatcraft.client.lightshow.event.handlers.GroupEventHandlerV3;
import com.beatcraft.client.lightshow.lights.LightState;
import com.beatcraft.client.lightshow.lights.TransformState;
import com.beatcraft.common.utils.JsonUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.client.Camera;
import oshi.util.tuples.Pair;

public abstract class EnvironmentV3
extends Environment {
    protected ColorBoostEventHandler boostEventHandler;
    private static final TransformState.Axis[] rotationAxes = new TransformState.Axis[]{TransformState.Axis.RX, TransformState.Axis.RY, TransformState.Axis.RZ};
    private static final TransformState.Axis[] translationAxes = new TransformState.Axis[]{TransformState.Axis.TX, TransformState.Axis.TY, TransformState.Axis.TZ};

    @Override
    public void loadLightshow(Difficulty difficulty, JsonObject json) {
        String version = json.get("version").getAsString().split("\\.")[0];
        if (version.equals("3")) {
            this.loadV3(difficulty, json);
        } else if (version.equals("4")) {
            this.loadV4(difficulty, json);
        }
    }

    public EnvironmentV3(BeatmapController map) {
        super(map);
    }

    @Override
    public float getVersion() {
        return 3.0f;
    }

    public abstract int getGroupCount();

    public abstract int getLightCount(int var1);

    protected abstract void linkEvents(int var1, int var2, List<LightEventV3> var3, HashMap<TransformState.Axis, ArrayList<RotationEventV3>> var4, HashMap<TransformState.Axis, ArrayList<TranslationEvent>> var5, List<Integer> var6);

    protected abstract HashMap<Integer, Pair<LightGroupV3, GroupEventHandlerV3>> getEventGroups();

    public List<LightEventV3> getLightEvents(int group, int lightID, float start, float end) {
        HashMap<Integer, Pair<LightGroupV3, GroupEventHandlerV3>> eventGroups = this.getEventGroups();
        GroupEventHandlerV3 groupEventHandler = (GroupEventHandlerV3)eventGroups.get(group).getB();
        return groupEventHandler.lightHandlers.get(lightID).getEventsInRange(start, end);
    }

    public List<RotationEventV3> getRotationEvents(int group, int lightID, TransformState.Axis axis, float start, float end) {
        HashMap<Integer, Pair<LightGroupV3, GroupEventHandlerV3>> eventGroups = this.getEventGroups();
        GroupEventHandlerV3 groupEventHandler = (GroupEventHandlerV3)eventGroups.get(group).getB();
        return groupEventHandler.rotationHandlers.get(lightID).get((Object)axis).getEventsInRange(start, end);
    }

    private void preProcessLightEventsV3(EventBuilder builder, JsonArray rawLightEvents) {
        rawLightEvents.forEach(rawBoxGroup -> {
            JsonObject boxGroupData = rawBoxGroup.getAsJsonObject();
            Float baseBeat = JsonUtil.getOrDefault(boxGroupData, "b", JsonElement::getAsFloat, Float.valueOf(0.0f));
            Integer group = JsonUtil.getOrDefault(boxGroupData, "g", JsonElement::getAsInt, Integer.valueOf(0));
            ArrayList coveredIDs = new ArrayList();
            int lightCount = this.getLightCount(group);
            JsonArray rawEventLanes = boxGroupData.getAsJsonArray("e");
            rawEventLanes.forEach(rawEventLane -> {
                JsonObject eventLaneData = rawEventLane.getAsJsonObject();
                JsonObject rawFilter = eventLaneData.getAsJsonObject("f");
                Float beatDistributionValue = JsonUtil.getOrDefault(eventLaneData, "w", JsonElement::getAsFloat, Float.valueOf(1.0f));
                Integer beatDistributionType = JsonUtil.getOrDefault(eventLaneData, "d", JsonElement::getAsInt, Integer.valueOf(0));
                Float brightnessDistributionValue = JsonUtil.getOrDefault(eventLaneData, "r", JsonElement::getAsFloat, Float.valueOf(1.0f));
                Integer brightnessDistributionType = JsonUtil.getOrDefault(eventLaneData, "t", JsonElement::getAsInt, Integer.valueOf(0));
                boolean affectsFirst = JsonUtil.getOrDefault(eventLaneData, "b", JsonElement::getAsInt, Integer.valueOf(0)) > 0;
                Integer rawBrightnessEasing = JsonUtil.getOrDefault(eventLaneData, "group", JsonElement::getAsInt, Integer.valueOf(0));
                Filter filter = Filter.processFilter(lightCount, coveredIDs, rawFilter);
                Function<Float, Float> brightnessEasing = Easing.getEasing(String.valueOf(rawBrightnessEasing));
                EventBuilder.BaseLightData baseData = new EventBuilder.BaseLightData(baseBeat.floatValue(), group, lightCount, filter, beatDistributionType % 2, beatDistributionValue.floatValue(), brightnessDistributionType % 2, brightnessDistributionValue.floatValue(), brightnessEasing, affectsFirst);
                JsonArray rawLightSubEvents = eventLaneData.getAsJsonArray("e");
                AtomicBoolean isFirst = new AtomicBoolean(true);
                rawLightSubEvents.forEach(rawSubEvent -> {
                    JsonObject eventData = rawSubEvent.getAsJsonObject();
                    Float beatOffset = JsonUtil.getOrDefault(eventData, "b", JsonElement::getAsFloat, Float.valueOf(0.0f));
                    Integer transitionType = JsonUtil.getOrDefault(eventData, "i", JsonElement::getAsInt, Integer.valueOf(0));
                    Integer color = JsonUtil.getOrDefault(eventData, "c", JsonElement::getAsInt, Integer.valueOf(0));
                    Float brightness = JsonUtil.getOrDefault(eventData, "s", JsonElement::getAsFloat, Float.valueOf(1.0f));
                    Float strobeFrequency = JsonUtil.getOrDefault(eventData, "f", JsonElement::getAsFloat, Float.valueOf(0.0f));
                    Float strobeBrightness = JsonUtil.getOrDefault(eventData, "sb", JsonElement::getAsFloat, Float.valueOf(0.0f));
                    boolean strobeFade = JsonUtil.getOrDefault(eventData, "sf", JsonElement::getAsInt, Integer.valueOf(0)) > 0;
                    List<EventBuilder.RawLightEventV3> events = baseData.buildEventsV3(isFirst.get(), beatOffset.floatValue(), transitionType, color, brightness.floatValue(), strobeFrequency.floatValue(), strobeBrightness.floatValue(), strobeFade);
                    builder.addRawLightEvents(events);
                    isFirst.set(false);
                });
            });
        });
    }

    private void preProcessRotationEventsV3(EventBuilder builder, JsonArray rawRotationEvents) {
        rawRotationEvents.forEach(rawBoxGroup -> {
            JsonObject boxGroupData = rawBoxGroup.getAsJsonObject();
            Float baseBeat = JsonUtil.getOrDefault(boxGroupData, "b", JsonElement::getAsFloat, Float.valueOf(0.0f));
            Integer group = JsonUtil.getOrDefault(boxGroupData, "g", JsonElement::getAsInt, Integer.valueOf(0));
            HashMap coveredIDs = new HashMap();
            int lightCount = this.getLightCount(group);
            JsonArray rawEventLanes = boxGroupData.getAsJsonArray("e");
            rawEventLanes.forEach(rawEventLane -> {
                JsonObject eventLaneData = rawEventLane.getAsJsonObject();
                JsonObject rawFilter = eventLaneData.getAsJsonObject("f");
                Float beatDistributionValue = JsonUtil.getOrDefault(eventLaneData, "w", JsonElement::getAsFloat, Float.valueOf(0.0f));
                Integer beatDistributionType = JsonUtil.getOrDefault(eventLaneData, "d", JsonElement::getAsInt, Integer.valueOf(0));
                Float rotationDistributionValue = JsonUtil.getOrDefault(eventLaneData, "s", JsonElement::getAsFloat, Float.valueOf(0.0f));
                Integer rotationDistributionType = JsonUtil.getOrDefault(eventLaneData, "t", JsonElement::getAsInt, Integer.valueOf(0));
                boolean affectsFirst = JsonUtil.getOrDefault(eventLaneData, "b", JsonElement::getAsInt, Integer.valueOf(0)) > 0;
                Integer distributionEasing = JsonUtil.getOrDefault(eventLaneData, "i", JsonElement::getAsInt, Integer.valueOf(0));
                Function<Float, Float> rotationEasing = Easing.getEasing(String.valueOf(distributionEasing));
                Integer rawAxis = JsonUtil.getOrDefault(eventLaneData, "a", JsonElement::getAsInt, Integer.valueOf(0));
                boolean invertAxis = JsonUtil.getOrDefault(eventLaneData, "r", JsonElement::getAsInt, Integer.valueOf(0)) > 0;
                TransformState.Axis axis = TransformState.Axis.values()[rawAxis % 3];
                if (!coveredIDs.containsKey((Object)axis)) {
                    coveredIDs.put(axis, new ArrayList());
                }
                ArrayList covered = (ArrayList)coveredIDs.get((Object)axis);
                Filter filter = Filter.processFilter(lightCount, covered, rawFilter);
                EventBuilder.BaseRotationData baseData = new EventBuilder.BaseRotationData(baseBeat.floatValue(), group, lightCount, filter, beatDistributionType % 2, beatDistributionValue.floatValue(), rotationDistributionType % 2, rotationDistributionValue.floatValue(), rotationEasing, axis, invertAxis, affectsFirst);
                JsonArray rawRotationSubEvents = eventLaneData.getAsJsonArray("l");
                AtomicBoolean isFirst = new AtomicBoolean(true);
                rawRotationSubEvents.forEach(rawSubEvent -> {
                    JsonObject eventData = rawSubEvent.getAsJsonObject();
                    Float beatOffset = JsonUtil.getOrDefault(eventData, "b", JsonElement::getAsFloat, Float.valueOf(0.0f));
                    Integer transitionType = JsonUtil.getOrDefault(eventData, "p", JsonElement::getAsInt, Integer.valueOf(0));
                    Integer rawEasing = JsonUtil.getOrDefault(eventData, "e", JsonElement::getAsInt, Integer.valueOf(0));
                    Float magnitude = JsonUtil.getOrDefault(eventData, "r", JsonElement::getAsFloat, Float.valueOf(0.0f));
                    Integer direction = JsonUtil.getOrDefault(eventData, "o", JsonElement::getAsInt, Integer.valueOf(0));
                    Integer loopCount = JsonUtil.getOrDefault(eventData, "l", JsonElement::getAsInt, Integer.valueOf(0));
                    Function<Float, Float> easing = Easing.getEasing(String.valueOf(rawEasing));
                    List<EventBuilder.RawRotationEventV3> events = baseData.buildEvents(isFirst.get(), beatOffset.floatValue(), transitionType, magnitude.floatValue(), direction, loopCount, easing);
                    builder.addRawRotationEvents(events);
                    isFirst.set(false);
                });
            });
        });
    }

    private void preProcessTranslationEventsV3(EventBuilder builder, JsonArray rawTranslationEvents) {
        rawTranslationEvents.forEach(rawBoxGroup -> {
            JsonObject boxGroupData = rawBoxGroup.getAsJsonObject();
            Float baseBeat = JsonUtil.getOrDefault(boxGroupData, "b", JsonElement::getAsFloat, Float.valueOf(0.0f));
            Integer group = JsonUtil.getOrDefault(boxGroupData, "g", JsonElement::getAsInt, Integer.valueOf(0));
            HashMap coveredIDs = new HashMap();
            int lightCount = this.getLightCount(group);
            JsonArray rawEventLanes = boxGroupData.getAsJsonArray("e");
            rawEventLanes.forEach(rawEventLane -> {
                JsonObject eventLaneData = rawEventLane.getAsJsonObject();
                JsonObject rawFilter = eventLaneData.getAsJsonObject("f");
                Float beatDistributionValue = JsonUtil.getOrDefault(eventLaneData, "w", JsonElement::getAsFloat, Float.valueOf(0.0f));
                Integer beatDistributionType = JsonUtil.getOrDefault(eventLaneData, "d", JsonElement::getAsInt, Integer.valueOf(0));
                Float gapDistributionValue = JsonUtil.getOrDefault(eventLaneData, "s", JsonElement::getAsFloat, Float.valueOf(0.0f));
                Integer gapDistributionType = JsonUtil.getOrDefault(eventLaneData, "t", JsonElement::getAsInt, Integer.valueOf(0));
                boolean affectsFirst = JsonUtil.getOrDefault(eventLaneData, "b", JsonElement::getAsInt, Integer.valueOf(0)) > 0;
                Integer distributionEasing = JsonUtil.getOrDefault(eventLaneData, "i", JsonElement::getAsInt, Integer.valueOf(0));
                Function<Float, Float> gapEasing = Easing.getEasing(String.valueOf(distributionEasing));
                Integer rawAxis = JsonUtil.getOrDefault(eventLaneData, "a", JsonElement::getAsInt, Integer.valueOf(0));
                boolean invertAxis = JsonUtil.getOrDefault(eventLaneData, "r", JsonElement::getAsInt, Integer.valueOf(0)) > 0;
                TransformState.Axis axis = TransformState.Axis.values()[rawAxis % 3 + 3];
                if (!coveredIDs.containsKey((Object)axis)) {
                    coveredIDs.put(axis, new ArrayList());
                }
                ArrayList covered = (ArrayList)coveredIDs.get((Object)axis);
                Filter filter = Filter.processFilter(lightCount, covered, rawFilter);
                EventBuilder.BaseTranslationData baseData = new EventBuilder.BaseTranslationData(baseBeat.floatValue(), group, lightCount, filter, beatDistributionType % 2, beatDistributionValue.floatValue(), gapDistributionType % 2, gapDistributionValue.floatValue(), gapEasing, axis, invertAxis, affectsFirst);
                JsonArray rawTranslationSubEvents = eventLaneData.getAsJsonArray("l");
                AtomicBoolean isFirst = new AtomicBoolean(true);
                rawTranslationSubEvents.forEach(rawSubEvent -> {
                    JsonObject eventData = rawSubEvent.getAsJsonObject();
                    Float beatOffset = JsonUtil.getOrDefault(eventData, "b", JsonElement::getAsFloat, Float.valueOf(0.0f));
                    Integer transitionType = JsonUtil.getOrDefault(eventData, "p", JsonElement::getAsInt, Integer.valueOf(0));
                    Integer rawEasing = JsonUtil.getOrDefault(eventData, "e", JsonElement::getAsInt, Integer.valueOf(0));
                    Float magnitude = JsonUtil.getOrDefault(eventData, "t", JsonElement::getAsFloat, Float.valueOf(0.0f));
                    Function<Float, Float> easing = Easing.getEasing(String.valueOf(rawEasing));
                    List<EventBuilder.RawTranslationEvent> events = baseData.buildEvents(isFirst.get(), beatOffset.floatValue(), transitionType, magnitude.floatValue(), easing);
                    builder.addRawTranslationEvents(events);
                    isFirst.set(false);
                });
            });
        });
    }

    private void preProcessLightEventsV4(EventBuilder builder, float baseBeat, int group, JsonArray eventBoxDataArray, JsonArray indexFilters, JsonArray colorEventBoxes, JsonArray colorEventMetaData) {
        ArrayList coveredIDs = new ArrayList();
        int lightCount = this.getLightCount(group);
        eventBoxDataArray.forEach(rawEventBoxData -> {
            JsonObject eventBoxData = rawEventBoxData.getAsJsonObject();
            Integer filterIndex = JsonUtil.getOrDefault(eventBoxData, "f", JsonElement::getAsInt, Integer.valueOf(0));
            Integer boxMetaDataIndex = JsonUtil.getOrDefault(eventBoxData, "e", JsonElement::getAsInt, Integer.valueOf(0));
            JsonArray eventList = eventBoxData.getAsJsonArray("l");
            JsonObject rawFilter = indexFilters.get(filterIndex.intValue()).getAsJsonObject();
            JsonObject boxMetaData = colorEventBoxes.get(boxMetaDataIndex.intValue()).getAsJsonObject();
            Filter filter = Filter.processFilter(lightCount, coveredIDs, rawFilter);
            Float beatDistributionValue = JsonUtil.getOrDefault(boxMetaData, "w", JsonElement::getAsFloat, Float.valueOf(1.0f));
            Integer beatDistributionType = JsonUtil.getOrDefault(boxMetaData, "d", JsonElement::getAsInt, Integer.valueOf(0));
            Float brightnessDistributionValue = JsonUtil.getOrDefault(boxMetaData, "s", JsonElement::getAsFloat, Float.valueOf(1.0f));
            Integer brightnessDistributionType = JsonUtil.getOrDefault(boxMetaData, "t", JsonElement::getAsInt, Integer.valueOf(0));
            boolean affectsFirst = JsonUtil.getOrDefault(boxMetaData, "b", JsonElement::getAsInt, Integer.valueOf(0)) > 0;
            Integer rawDistributionEasing = JsonUtil.getOrDefault(boxMetaData, "e", JsonElement::getAsInt, Integer.valueOf(0));
            Function<Float, Float> distributionEasing = Easing.getEasing(String.valueOf(rawDistributionEasing));
            EventBuilder.BaseLightData baseData = new EventBuilder.BaseLightData(baseBeat, group, lightCount, filter, beatDistributionType, beatDistributionValue.floatValue(), brightnessDistributionType, brightnessDistributionValue.floatValue(), distributionEasing, affectsFirst);
            AtomicBoolean isFirst = new AtomicBoolean(true);
            eventList.forEach(rawEventData -> {
                JsonObject eventData = rawEventData.getAsJsonObject();
                Float beatOffset = JsonUtil.getOrDefault(eventData, "b", JsonElement::getAsFloat, Float.valueOf(0.0f));
                Integer metaDataIndex = JsonUtil.getOrDefault(eventData, "i", JsonElement::getAsInt, Integer.valueOf(0));
                JsonObject metaData = colorEventMetaData.get(metaDataIndex.intValue()).getAsJsonObject();
                Integer eventType = JsonUtil.getOrDefault(metaData, "p", JsonElement::getAsInt, Integer.valueOf(0));
                Integer rawEasing = JsonUtil.getOrDefault(metaData, "e", JsonElement::getAsInt, Integer.valueOf(0));
                Integer color = JsonUtil.getOrDefault(metaData, "c", JsonElement::getAsInt, Integer.valueOf(0));
                Float brightness = JsonUtil.getOrDefault(metaData, "b", JsonElement::getAsFloat, Float.valueOf(0.0f));
                Float strobeFrequency = JsonUtil.getOrDefault(metaData, "f", JsonElement::getAsFloat, Float.valueOf(0.0f));
                Float strobeBrightness = JsonUtil.getOrDefault(metaData, "sb", JsonElement::getAsFloat, Float.valueOf(0.0f));
                boolean strobeFade = JsonUtil.getOrDefault(metaData, "sf", JsonElement::getAsInt, Integer.valueOf(0)) > 0;
                Function<Float, Float> easing = Easing.getEasing(String.valueOf(rawEasing));
                List<EventBuilder.RawLightEventV3> events = baseData.buildEventsV4(isFirst.get(), beatOffset.floatValue(), eventType, color, brightness.floatValue(), strobeFrequency.floatValue(), strobeBrightness.floatValue(), strobeFade, easing);
                builder.addRawLightEvents(events);
                isFirst.set(false);
            });
        });
    }

    private void preProcessRotationEventsV4(EventBuilder builder, float baseBeat, int group, JsonArray eventBoxDataArray, JsonArray indexFilters, JsonArray rotationEventBoxes, JsonArray rotationEventMetaData) {
        ArrayList coveredIDs = new ArrayList();
        int lightCount = this.getLightCount(group);
        eventBoxDataArray.forEach(rawEventBoxData -> {
            JsonObject eventBoxData = rawEventBoxData.getAsJsonObject();
            Integer filterIndex = JsonUtil.getOrDefault(eventBoxData, "f", JsonElement::getAsInt, Integer.valueOf(0));
            Integer boxMetaDataIndex = JsonUtil.getOrDefault(eventBoxData, "e", JsonElement::getAsInt, Integer.valueOf(0));
            JsonArray eventList = eventBoxData.getAsJsonArray("l");
            JsonObject rawFilter = indexFilters.get(filterIndex.intValue()).getAsJsonObject();
            JsonObject boxMetaData = rotationEventBoxes.get(boxMetaDataIndex.intValue()).getAsJsonObject();
            Filter filter = Filter.processFilter(lightCount, coveredIDs, rawFilter);
            Float beatDistributionValue = JsonUtil.getOrDefault(boxMetaData, "w", JsonElement::getAsFloat, Float.valueOf(1.0f));
            Integer beatDistributionType = JsonUtil.getOrDefault(boxMetaData, "d", JsonElement::getAsInt, Integer.valueOf(0));
            Float rotationDistributionValue = JsonUtil.getOrDefault(boxMetaData, "s", JsonElement::getAsFloat, Float.valueOf(0.0f));
            Integer rotationDistributionType = JsonUtil.getOrDefault(boxMetaData, "t", JsonElement::getAsInt, Integer.valueOf(0));
            boolean affectsFirst = JsonUtil.getOrDefault(boxMetaData, "b", JsonElement::getAsInt, Integer.valueOf(0)) > 0;
            Integer rawDistributionEasing = JsonUtil.getOrDefault(boxMetaData, "e", JsonElement::getAsInt, Integer.valueOf(0));
            Function<Float, Float> distributionEasing = Easing.getEasing(String.valueOf(rawDistributionEasing));
            Integer rawAxis = JsonUtil.getOrDefault(boxMetaData, "a", JsonElement::getAsInt, Integer.valueOf(0));
            boolean invertAxis = JsonUtil.getOrDefault(boxMetaData, "f", JsonElement::getAsInt, Integer.valueOf(0)) > 0;
            TransformState.Axis axis = TransformState.Axis.values()[rawAxis % 3];
            EventBuilder.BaseRotationData baseData = new EventBuilder.BaseRotationData(baseBeat, group, lightCount, filter, beatDistributionType, beatDistributionValue.floatValue(), rotationDistributionType, rotationDistributionValue.floatValue(), distributionEasing, axis, invertAxis, affectsFirst);
            AtomicBoolean isFirst = new AtomicBoolean(true);
            eventList.forEach(rawEventData -> {
                JsonObject eventData = rawEventData.getAsJsonObject();
                Float beatOffset = JsonUtil.getOrDefault(eventData, "b", JsonElement::getAsFloat, Float.valueOf(0.0f));
                Integer metaDataIndex = JsonUtil.getOrDefault(eventData, "i", JsonElement::getAsInt, Integer.valueOf(0));
                JsonObject metaData = rotationEventMetaData.get(metaDataIndex.intValue()).getAsJsonObject();
                Integer eventType = JsonUtil.getOrDefault(metaData, "p", JsonElement::getAsInt, Integer.valueOf(0));
                Integer rawEasing = JsonUtil.getOrDefault(metaData, "e", JsonElement::getAsInt, Integer.valueOf(0));
                Float magnitude = JsonUtil.getOrDefault(metaData, "r", JsonElement::getAsFloat, Float.valueOf(0.0f));
                Integer direction = JsonUtil.getOrDefault(metaData, "d", JsonElement::getAsInt, Integer.valueOf(0));
                Integer loopCount = JsonUtil.getOrDefault(metaData, "l", JsonElement::getAsInt, Integer.valueOf(0));
                Function<Float, Float> easing = Easing.getEasing(String.valueOf(rawEasing));
                List<EventBuilder.RawRotationEventV3> events = baseData.buildEvents(isFirst.get(), beatOffset.floatValue(), eventType, magnitude.floatValue(), direction, loopCount, easing);
                builder.addRawRotationEvents(events);
                isFirst.set(false);
            });
        });
    }

    private void preProcessTranslationEventsV4(EventBuilder builder, float baseBeat, int group, JsonArray eventBoxDataArray, JsonArray indexFilters, JsonArray translationEventBoxes, JsonArray translationEventMetaData) {
        ArrayList coveredIDs = new ArrayList();
        int lightCount = this.getLightCount(group);
        eventBoxDataArray.forEach(rawEventBoxData -> {
            JsonObject eventBoxData = rawEventBoxData.getAsJsonObject();
            Integer filterIndex = JsonUtil.getOrDefault(eventBoxData, "f", JsonElement::getAsInt, Integer.valueOf(0));
            Integer boxMetaDataIndex = JsonUtil.getOrDefault(eventBoxData, "e", JsonElement::getAsInt, Integer.valueOf(0));
            JsonArray eventList = eventBoxData.getAsJsonArray("l");
            JsonObject rawFilter = indexFilters.get(filterIndex.intValue()).getAsJsonObject();
            JsonObject boxMetaData = translationEventBoxes.get(boxMetaDataIndex.intValue()).getAsJsonObject();
            Filter filter = Filter.processFilter(lightCount, coveredIDs, rawFilter);
            Float beatDistributionValue = JsonUtil.getOrDefault(boxMetaData, "w", JsonElement::getAsFloat, Float.valueOf(1.0f));
            Integer beatDistributionType = JsonUtil.getOrDefault(boxMetaData, "d", JsonElement::getAsInt, Integer.valueOf(0));
            Float rotationDistributionValue = JsonUtil.getOrDefault(boxMetaData, "s", JsonElement::getAsFloat, Float.valueOf(0.0f));
            Integer rotationDistributionType = JsonUtil.getOrDefault(boxMetaData, "t", JsonElement::getAsInt, Integer.valueOf(0));
            boolean affectsFirst = JsonUtil.getOrDefault(boxMetaData, "b", JsonElement::getAsInt, Integer.valueOf(0)) > 0;
            Integer rawDistributionEasing = JsonUtil.getOrDefault(boxMetaData, "e", JsonElement::getAsInt, Integer.valueOf(0));
            Function<Float, Float> distributionEasing = Easing.getEasing(String.valueOf(rawDistributionEasing));
            Integer rawAxis = JsonUtil.getOrDefault(boxMetaData, "a", JsonElement::getAsInt, Integer.valueOf(0));
            boolean invertAxis = JsonUtil.getOrDefault(boxMetaData, "f", JsonElement::getAsInt, Integer.valueOf(0)) > 0;
            TransformState.Axis axis = TransformState.Axis.values()[rawAxis % 3 + 3];
            EventBuilder.BaseTranslationData baseData = new EventBuilder.BaseTranslationData(baseBeat, group, lightCount, filter, beatDistributionType, beatDistributionValue.floatValue(), rotationDistributionType, rotationDistributionValue.floatValue(), distributionEasing, axis, invertAxis, affectsFirst);
            AtomicBoolean isFirst = new AtomicBoolean(true);
            eventList.forEach(rawEventData -> {
                JsonObject eventData = rawEventData.getAsJsonObject();
                Float beatOffset = JsonUtil.getOrDefault(eventData, "b", JsonElement::getAsFloat, Float.valueOf(0.0f));
                Integer metaDataIndex = JsonUtil.getOrDefault(eventData, "i", JsonElement::getAsInt, Integer.valueOf(0));
                JsonObject metaData = translationEventMetaData.get(metaDataIndex.intValue()).getAsJsonObject();
                Integer eventType = JsonUtil.getOrDefault(metaData, "p", JsonElement::getAsInt, Integer.valueOf(0));
                Integer rawEasing = JsonUtil.getOrDefault(metaData, "e", JsonElement::getAsInt, Integer.valueOf(0));
                Float magnitude = JsonUtil.getOrDefault(metaData, "r", JsonElement::getAsFloat, Float.valueOf(0.0f));
                Function<Float, Float> easing = Easing.getEasing(String.valueOf(rawEasing));
                List<EventBuilder.RawTranslationEvent> events = baseData.buildEvents(isFirst.get(), beatOffset.floatValue(), eventType, magnitude.floatValue(), easing);
                builder.addRawTranslationEvents(events);
                isFirst.set(false);
            });
        });
    }

    private void buildLightEvents(EventBuilder builder, Difficulty difficulty) {
        float finalBeat = difficulty.getInfo().getBeat(difficulty.getInfo().getSongDuration());
        int groupCount = this.getGroupCount();
        for (int group = 0; group < groupCount; ++group) {
            int lightCount = this.getLightCount(group);
            for (int lightID = 0; lightID < lightCount; ++lightID) {
                for (EventBuilder.RawLightEventV3 rawEvent : builder.getRawLightEvents(group, lightID)) {
                    LightEventV3 lastEvent = builder.getLatestLightEvent(group, lightID);
                    float endBeat = rawEvent.eventBeat() + rawEvent.beatOffset() + rawEvent.endOffset();
                    float startBeat = Math.min(lastEvent.getEventBeat() + lastEvent.getEventDuration(), endBeat);
                    float duration = Math.max(0.0f, endBeat - startBeat);
                    if (rawEvent.eventType() == 0) {
                        LightState startState = lastEvent.lightState.copy();
                        LightState endState = new LightState(new BoostableColor(rawEvent.color()), rawEvent.brightness());
                        endState.setStrobeState(rawEvent.strobeBrightness(), rawEvent.strobeFrequency(), rawEvent.strobeFade());
                        LightEventV3 transitionEvent = new LightEventV3(startBeat, startState, endState, duration, lightID, rawEvent.easing());
                        builder.putEvent(group, lightID, transitionEvent);
                        continue;
                    }
                    LightEventV3 extensionEvent = lastEvent.extendTo(endBeat);
                    builder.putEvent(group, lightID, extensionEvent);
                }
                LightEventV3 lastEvent = builder.getLatestLightEvent(group, lightID);
                LightEventV3 endEvent = lastEvent.extendTo(finalBeat);
                builder.putEvent(group, lightID, endEvent);
            }
        }
    }

    private void buildRotationEvents(EventBuilder builder, Difficulty difficulty) {
        float finalBeat = difficulty.getInfo().getBeat(difficulty.getInfo().getSongDuration());
        int groupCount = this.getGroupCount();
        for (int group = 0; group < groupCount; ++group) {
            int lightCount = this.getLightCount(group);
            for (int lightID = 0; lightID < lightCount; ++lightID) {
                for (TransformState.Axis axis : rotationAxes) {
                    for (EventBuilder.RawRotationEventV3 rawEvent : builder.getRawRotationEvents(group, lightID, axis)) {
                        RotationEventV3 lastEvent = builder.getLatestRotationEvent(group, lightID, axis);
                        float endBeat = rawEvent.eventBeat() + rawEvent.beatOffset() + rawEvent.endOffset();
                        float startBeat = Math.min(lastEvent.getEventBeat() + lastEvent.getEventDuration(), endBeat);
                        float duration = Math.max(0.0f, endBeat - startBeat);
                        if (rawEvent.eventType() == 0) {
                            TransformState startState = lastEvent.transformState.copy();
                            TransformState endState = new TransformState(axis, rawEvent.rotation());
                            RotationEventV3 transitionEvent = new RotationEventV3(startBeat, startState, endState, duration, lightID, rawEvent.easing(), rawEvent.loopCount(), rawEvent.direction());
                            builder.putEvent(group, lightID, axis, transitionEvent);
                            continue;
                        }
                        RotationEventV3 extensionEvent = lastEvent.extendTo(endBeat);
                        builder.putEvent(group, lightID, axis, extensionEvent);
                    }
                    RotationEventV3 lastEvent = builder.getLatestRotationEvent(group, lightID, axis);
                    RotationEventV3 endEvent = lastEvent.extendTo(finalBeat);
                    builder.putEvent(group, lightID, axis, endEvent);
                }
            }
        }
    }

    private void buildTranslationEvents(EventBuilder builder, Difficulty difficulty) {
        float finalBeat = difficulty.getInfo().getBeat(difficulty.getInfo().getSongDuration());
        int groupCount = this.getGroupCount();
        for (int group = 0; group < groupCount; ++group) {
            int lightCount = this.getLightCount(group);
            for (int lightID = 0; lightID < lightCount; ++lightID) {
                for (TransformState.Axis axis : translationAxes) {
                    for (EventBuilder.RawTranslationEvent rawEvent : builder.getRawTranslationEvents(group, lightID, axis)) {
                        TranslationEvent lastEvent = builder.getLatestTranslationEvent(group, lightID, axis);
                        float endBeat = rawEvent.eventBeat() + rawEvent.beatOffset() + rawEvent.endOffset();
                        float startBeat = Math.min(lastEvent.getEventBeat() + lastEvent.getEventDuration(), endBeat);
                        float duration = Math.max(0.0f, endBeat - startBeat);
                        if (rawEvent.eventType() == 0) {
                            TransformState startState = lastEvent.transformState.copy();
                            TransformState endState = new TransformState(axis, rawEvent.delta());
                            TranslationEvent transitionEvent = new TranslationEvent(startBeat, startState, endState, duration, lightID, rawEvent.easing());
                            builder.putEvent(group, lightID, axis, transitionEvent);
                            continue;
                        }
                        TranslationEvent extensionEvent = lastEvent.extendTo(endBeat);
                        builder.putEvent(group, lightID, axis, extensionEvent);
                    }
                    TranslationEvent lastEvent = builder.getLatestTranslationEvent(group, lightID, axis);
                    TranslationEvent endEvent = lastEvent.extendTo(finalBeat);
                    builder.putEvent(group, lightID, axis, endEvent);
                }
            }
        }
    }

    private void loadV3(Difficulty difficulty, JsonObject json) {
        JsonArray rawColorEventBoxes = json.getAsJsonArray("lightColorEventBoxGroups");
        JsonArray rawRotationEvents = json.getAsJsonArray("lightRotationEventBoxGroups");
        JsonArray rawTranslationEvents = json.getAsJsonArray("lightTranslationEventBoxGroups");
        if (rawTranslationEvents == null) {
            rawTranslationEvents = new JsonArray();
        }
        JsonArray rawBoostEvents = json.getAsJsonArray("colorBoostBeatmapEvents");
        ArrayList<ColorBoostEvent> boostEvents = new ArrayList<ColorBoostEvent>();
        boostEvents.add(new ColorBoostEvent(0.0f, false));
        rawBoostEvents.forEach(rawEvent -> {
            JsonObject eventData = rawEvent.getAsJsonObject();
            boostEvents.add(new ColorBoostEvent().loadV3(eventData, difficulty));
        });
        this.boostEventHandler = new ColorBoostEventHandler(this.mapController, boostEvents);
        EventBuilder eventBuilder = new EventBuilder();
        this.preProcessLightEventsV3(eventBuilder, rawColorEventBoxes);
        this.preProcessRotationEventsV3(eventBuilder, rawRotationEvents);
        this.preProcessTranslationEventsV3(eventBuilder, rawTranslationEvents);
        eventBuilder.sortEvents();
        this.buildLightEvents(eventBuilder, difficulty);
        this.buildRotationEvents(eventBuilder, difficulty);
        this.buildTranslationEvents(eventBuilder, difficulty);
        int groupCount = this.getGroupCount();
        for (int group = 0; group < groupCount; ++group) {
            int lightCount = this.getLightCount(group);
            for (int lightID = 0; lightID < lightCount; ++lightID) {
                this.linkEvents(group, lightID, eventBuilder.getLightEvents(group, lightID), eventBuilder.getRotationEvents(group, lightID), eventBuilder.getTranslationEvents(group, lightID), new ArrayList<Integer>());
            }
        }
    }

    private void loadV4(Difficulty difficulty, JsonObject json) {
        JsonArray rawEventBoxGroups = json.getAsJsonArray("eventBoxGroups");
        JsonArray indexFilters = json.getAsJsonArray("indexFilters");
        JsonArray lightColorEventBoxes = json.getAsJsonArray("lightColorEventBoxes");
        JsonArray lightColorEventMetaData = json.getAsJsonArray("lightColorEvents");
        JsonArray lightRotationEventBoxes = json.getAsJsonArray("lightRotationEventBoxes");
        JsonArray lightRotationEventMetaData = json.getAsJsonArray("lightRotationEvents");
        JsonArray lightTranslationEventBoxes = json.getAsJsonArray("lightTranslationEventBoxes");
        JsonArray lightTranslationEventMetaData = json.getAsJsonArray("lightTranslationEvents");
        EventBuilder eventBuilder = new EventBuilder();
        rawEventBoxGroups.forEach(rawEventBox -> {
            JsonObject eventData = rawEventBox.getAsJsonObject();
            Float baseBeat = JsonUtil.getOrDefault(eventData, "b", JsonElement::getAsFloat, Float.valueOf(0.0f));
            Integer group = JsonUtil.getOrDefault(eventData, "g", JsonElement::getAsInt, Integer.valueOf(0));
            Integer eventType = JsonUtil.getOrDefault(eventData, "t", JsonElement::getAsInt, Integer.valueOf(0));
            JsonArray data = eventData.getAsJsonArray("e");
            if (eventType == 1) {
                this.preProcessLightEventsV4(eventBuilder, baseBeat.floatValue(), group, data, indexFilters, lightColorEventBoxes, lightColorEventMetaData);
            } else if (eventType == 2) {
                this.preProcessRotationEventsV4(eventBuilder, baseBeat.floatValue(), group, data, indexFilters, lightRotationEventBoxes, lightRotationEventMetaData);
            } else if (eventType == 3) {
                this.preProcessTranslationEventsV4(eventBuilder, baseBeat.floatValue(), group, data, indexFilters, lightTranslationEventBoxes, lightTranslationEventMetaData);
            }
        });
        eventBuilder.sortEvents();
        this.buildLightEvents(eventBuilder, difficulty);
        this.buildRotationEvents(eventBuilder, difficulty);
        this.buildTranslationEvents(eventBuilder, difficulty);
        int groupCount = this.getGroupCount();
        for (int group = 0; group < groupCount; ++group) {
            int lightCount = this.getLightCount(group);
            for (int lightID = 0; lightID < lightCount; ++lightID) {
                this.linkEvents(group, lightID, eventBuilder.getLightEvents(group, lightID), eventBuilder.getRotationEvents(group, lightID), eventBuilder.getTranslationEvents(group, lightID), new ArrayList<Integer>());
            }
        }
    }

    @Override
    public abstract void seek(float var1);

    @Override
    public Environment reset() {
        this.boostEventHandler = null;
        return this;
    }

    @Override
    public void update(float beat, double deltaTime) {
        super.update(beat, deltaTime);
        if (this.boostEventHandler != null) {
            this.boostEventHandler.update(beat);
        }
    }

    @Override
    public void render(PoseStack matrices, Camera camera, float alpha) {
        super.render(matrices, camera, alpha);
    }
}

