/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.lightshow.environment.nice;

import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.lightshow.lights.LightObject;
import com.beatcraft.client.lightshow.lights.LightState;
import com.beatcraft.client.render.effect.Bloomfog;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Camera;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class OuterRing
extends LightObject {
    private List<LightObject> lights;
    private static final float ringRadius = 27.0f;
    private static final float ringWidth = 1.0f;
    private static final float ringDepth = 0.5f;
    private static final int color = -16777216;
    private static final float lightSize = 0.2f;
    private static final float lightOffset = 0.001f;
    protected boolean lightsOnly = false;
    private static final Vector3f[] vertices = new Vector3f[]{new Vector3f(27.0f, 0.0f, 0.0f), new Vector3f(28.0f, 0.0f, 0.0f), new Vector3f(28.0f, 28.0f, 0.0f), new Vector3f(27.0f, 27.0f, 0.0f), new Vector3f(27.0f, 0.0f, 0.0f), new Vector3f(27.0f, 27.0f, 0.0f), new Vector3f(27.0f, 27.0f, 0.5f), new Vector3f(27.0f, 0.0f, 0.5f), new Vector3f(28.0f, 28.0f, 0.0f), new Vector3f(0.0f, 28.0f, 0.0f), new Vector3f(0.0f, 27.0f, 0.0f), new Vector3f(27.0f, 27.0f, 0.0f), new Vector3f(27.0f, 27.0f, 0.0f), new Vector3f(0.0f, 27.0f, 0.0f), new Vector3f(0.0f, 27.0f, 0.5f), new Vector3f(27.0f, 27.0f, 0.5f)};
    private static final Vector3f[] modifiers = new Vector3f[]{new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(1.0f, -1.0f, 1.0f)};

    public static OuterRing getLightsOnly(BeatmapController map, TriFunction<BeatmapController, Vector3f, Quaternionf, LightObject> lightFactory) {
        OuterRing a = new OuterRing(map, lightFactory);
        a.lightsOnly = true;
        return a;
    }

    public OuterRing(BeatmapController map, TriFunction<BeatmapController, Vector3f, Quaternionf, LightObject> lightFactory) {
        super(map);
        this.orientation = new Quaternionf().rotationZ(0.7853982f);
        this.lights = List.of((LightObject)lightFactory.apply((Object)map, (Object)new Vector3f(0.0f, 26.79f, 0.201f), (Object)new Quaternionf()), (LightObject)lightFactory.apply((Object)map, (Object)new Vector3f(26.79f, 0.0f, 0.201f), (Object)new Quaternionf().rotationZ(1.5707964f)), (LightObject)lightFactory.apply((Object)map, (Object)new Vector3f(0.0f, -26.79f, 0.201f), (Object)new Quaternionf().rotationZ((float)Math.PI)), (LightObject)lightFactory.apply((Object)map, (Object)new Vector3f(-26.79f, 0.0f, 0.201f), (Object)new Quaternionf().rotationZ(-1.5707964f)));
    }

    @Override
    public OuterRing cloneOffset(Vector3f offset) {
        return this;
    }

    @Override
    public void render(PoseStack matrices, Camera camera, float alpha, Bloomfog bloomfog) {
        Vector3f pos = new Vector3f((Vector3fc)this.position);
        Vector3f off = new Vector3f((Vector3fc)this.offset);
        Quaternionf ori = new Quaternionf((Quaternionfc)this.orientation);
        Quaternionf rot = new Quaternionf((Quaternionfc)this.rotation);
        if (!this.lightsOnly) {
            this.mapController.recordBloomfogPosColCall((TriConsumer<Matrix4f, BufferBuilder, Vector3f>)((TriConsumer)(t, b, c) -> this._render((Matrix4f)t, (BufferBuilder)b, (Vector3f)c, pos, off, ori, rot, bloomfog)));
        }
        for (LightObject light : this.lights) {
            light.setWorldRotation(new Quaternionf((Quaternionfc)this.orientation).mul((Quaternionfc)this.rotation));
            light.setOffset(new Vector3f((Vector3fc)this.position).rotate((Quaternionfc)this.rotation).add((Vector3fc)this.offset).rotate((Quaternionfc)this.worldRotation));
            light.render(matrices, camera, alpha, bloomfog);
        }
    }

    private Vector3f processVertex(Vector3f base, Vector3f pos, Vector3f off, Quaternionf ori, Quaternionf rot) {
        return new Vector3f((Vector3fc)base).rotate((Quaternionfc)ori).add((Vector3fc)pos).rotate((Quaternionfc)rot).add((Vector3fc)off);
    }

    private void _render(Matrix4f transform, BufferBuilder buffer, Vector3f cameraPos, Vector3f position, Vector3f offset, Quaternionf orientation, Quaternionf rotation, Bloomfog bloomfog) {
        for (Vector3f mod : modifiers) {
            for (Vector3f vertex : vertices) {
                buffer.addVertex(cameraPos.negate(new Vector3f()).add((Vector3fc)transform.transformPosition(this.processVertex(vertex.mul((Vector3fc)mod, new Vector3f()), position, offset, orientation, rotation)))).setColor(-16777216);
            }
        }
    }

    @Override
    public void setBrightness(float value) {
    }

    @Override
    public void setColor(int color) {
    }

    @Override
    public void setLightState(LightState state) {
    }
}

