/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.lightshow.environment.triangle;

import com.beatcraft.client.animation.Easing;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.Difficulty;
import com.beatcraft.client.lightshow.environment.EnvironmentV2;
import com.beatcraft.client.lightshow.environment.lightgroup.LightGroupV2;
import com.beatcraft.client.lightshow.environment.lightgroup.RingLightGroup;
import com.beatcraft.client.lightshow.environment.lightgroup.RotatingLightsGroup;
import com.beatcraft.client.lightshow.environment.lightgroup.StaticLightsGroup;
import com.beatcraft.client.lightshow.environment.triangle.InnerRing;
import com.beatcraft.client.lightshow.environment.triangle.OuterRing;
import com.beatcraft.client.lightshow.lights.LightObject;
import com.beatcraft.client.lightshow.spectrogram.SpectrogramTowers;
import com.beatcraft.client.logic.Hitbox;
import com.beatcraft.client.render.lights.GlowingCuboid;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.util.HashMap;
import net.minecraft.client.Camera;
import org.apache.commons.lang3.function.TriFunction;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class TriangleEnvironment
extends EnvironmentV2 {
    private RingLightGroup ringLights;
    private SpectrogramTowers leftSpectrogramTowers;
    private SpectrogramTowers rightSpectrogramTowers;
    private static final float ROTATING_LIGHT_X = 25.0f;
    private static final float ROTATING_LIGHT_Y = -6.0f;
    private static final float ROTATING_LIGHT_Z = 47.5f;
    private static final float MIDDLE_LIGHT_Z = 27.5f;
    private static final float ringRadius = 27.0f;
    private static final float lightLength = 6.0f;
    private static final float lightSize = 0.2f;

    public TriangleEnvironment(BeatmapController map) {
        super(map);
    }

    @Override
    public String getID() {
        return "TriangleEnvironment";
    }

    @Override
    public void loadLightshow(Difficulty difficulty, JsonObject json) {
        super.loadLightshow(difficulty, json);
        File f = new File(difficulty.getInfo().getSongFilename());
        this.leftSpectrogramTowers = new SpectrogramTowers(this.mapController, new Vector3f(13.5f, -5.0f, -80.5f), new Quaternionf(), new Vector3f(0.0f, 0.0f, 2.0f), 127, f, SpectrogramTowers.TowerStyle.Cuboid, true);
        this.rightSpectrogramTowers = this.leftSpectrogramTowers.copyTo(new Vector3f(-13.5f, -5.0f, -80.5f), new Quaternionf());
        this.leftSpectrogramTowers.levelModifier = 0.75f;
        this.rightSpectrogramTowers.levelModifier = 0.75f;
        this.leftSpectrogramTowers.levelEasing = Easing::easeOutExpo;
        this.rightSpectrogramTowers.levelEasing = Easing::easeOutExpo;
    }

    private static GlowingCuboid getRunway(BeatmapController map, boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid(map, new Hitbox(new Vector3f(-0.03f, -0.03f, 0.0f), new Vector3f(0.03f, 0.03f, 500.0f)), new Vector3f(2.0f * (float)sign, 0.0f, 8.0f), new Quaternionf());
    }

    private static GlowingCuboid getTowerLight1(BeatmapController map, boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid(map, new Hitbox(new Vector3f(-0.1f, -20.0f, -0.1f), new Vector3f(0.1f, 8.5f, 0.1f)), new Vector3f((float)(20 * sign), 0.0f, 16.0f), new Quaternionf());
    }

    private static GlowingCuboid getTowerLight2(BeatmapController map, boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid(map, new Hitbox(new Vector3f(-0.1f, -15.0f, -0.1f), new Vector3f(0.1f, 11.5f, 0.1f)), new Vector3f((float)(20 * sign), 0.0f, 19.0f), new Quaternionf());
    }

    private static GlowingCuboid getSkyLasers(BeatmapController map, boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid(map, new Hitbox(new Vector3f(-0.2f, 0.0f, -0.2f), new Vector3f(0.2f, 350.0f, 0.2f)), new Vector3f(22.5f * (float)sign, 30.0f, 19.5f), new Quaternionf());
    }

    private static GlowingCuboid getSlantedLaser(BeatmapController map, boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid(map, new Hitbox(new Vector3f(-0.2f, 0.0f, -0.2f), new Vector3f(0.2f, 102.0f, 0.2f)), new Vector3f(3.5f * (float)sign, -64.0f, -0.5f), new Quaternionf().rotationX(-0.34557518f));
    }

    @Override
    protected LightGroupV2 setupLeftLasers() {
        HashMap<Integer, LightObject> rotatingLights = new HashMap<Integer, LightObject>();
        HashMap<Integer, LightObject> staticLights = new HashMap<Integer, LightObject>();
        int lightID = 1;
        Vector3f offset = new Vector3f(0.0f, 0.0f, 0.5f);
        GlowingCuboid left1 = new GlowingCuboid(this.mapController, new Hitbox(new Vector3f(-0.03f, -10.0f, -0.03f), new Vector3f(0.03f, 800.0f, 0.03f)), new Vector3f(25.0f, -6.0f, 47.5f), new Quaternionf().rotationZ(0.9599311f));
        GlowingCuboid left2 = left1.cloneOffset(offset);
        GlowingCuboid left3 = left2.cloneOffset(offset);
        GlowingCuboid left4 = left3.cloneOffset(offset);
        GlowingCuboid left5 = left4.cloneOffset(offset);
        GlowingCuboid left6 = left5.cloneOffset(offset);
        GlowingCuboid left7 = left6.cloneOffset(offset);
        rotatingLights.put(lightID++, left1);
        rotatingLights.put(lightID++, left2);
        rotatingLights.put(lightID++, left3);
        rotatingLights.put(lightID++, left4);
        rotatingLights.put(lightID++, left5);
        rotatingLights.put(lightID++, left6);
        rotatingLights.put(lightID++, left7);
        GlowingCuboid leftRunway = TriangleEnvironment.getRunway(this.mapController, true);
        GlowingCuboid leftTowerLight1 = TriangleEnvironment.getTowerLight1(this.mapController, true);
        GlowingCuboid leftTowerLight2 = TriangleEnvironment.getTowerLight2(this.mapController, true);
        GlowingCuboid skyLaser = TriangleEnvironment.getSkyLasers(this.mapController, true);
        staticLights.put(lightID++, leftRunway);
        staticLights.put(lightID++, leftTowerLight1);
        staticLights.put(lightID++, leftTowerLight2);
        staticLights.put(lightID++, skyLaser);
        return new RotatingLightsGroup(this.mapController, rotatingLights, staticLights);
    }

    @Override
    protected LightGroupV2 setupRightLasers() {
        HashMap<Integer, LightObject> rotatingLights = new HashMap<Integer, LightObject>();
        HashMap<Integer, LightObject> staticLights = new HashMap<Integer, LightObject>();
        int lightID = 1;
        Vector3f offset = new Vector3f(0.0f, 0.0f, 0.5f);
        GlowingCuboid right1 = new GlowingCuboid(this.mapController, new Hitbox(new Vector3f(-0.03f, -10.0f, -0.03f), new Vector3f(0.03f, 800.0f, 0.03f)), new Vector3f(-25.0f, -6.0f, 47.5f), new Quaternionf().rotationZ(-0.9599311f));
        GlowingCuboid right2 = right1.cloneOffset(offset);
        GlowingCuboid right3 = right2.cloneOffset(offset);
        GlowingCuboid right4 = right3.cloneOffset(offset);
        GlowingCuboid right5 = right4.cloneOffset(offset);
        GlowingCuboid right6 = right5.cloneOffset(offset);
        GlowingCuboid right7 = right6.cloneOffset(offset);
        rotatingLights.put(lightID++, right1);
        rotatingLights.put(lightID++, right2);
        rotatingLights.put(lightID++, right3);
        rotatingLights.put(lightID++, right4);
        rotatingLights.put(lightID++, right5);
        rotatingLights.put(lightID++, right6);
        rotatingLights.put(lightID++, right7);
        GlowingCuboid rightRunway = TriangleEnvironment.getRunway(this.mapController, false);
        GlowingCuboid rightTowerLight1 = TriangleEnvironment.getTowerLight1(this.mapController, false);
        GlowingCuboid rightTowerLight2 = TriangleEnvironment.getTowerLight2(this.mapController, false);
        GlowingCuboid skyLaser = TriangleEnvironment.getSkyLasers(this.mapController, false);
        staticLights.put(lightID++, rightRunway);
        staticLights.put(lightID++, rightTowerLight1);
        staticLights.put(lightID++, rightTowerLight2);
        staticLights.put(lightID++, skyLaser);
        return new RotatingLightsGroup(this.mapController, rotatingLights, staticLights);
    }

    @Override
    protected LightGroupV2 setupBackLasers() {
        HashMap<Integer, LightObject> lights = new HashMap<Integer, LightObject>();
        int lightID = 1;
        for (int i = 0; i < 5; ++i) {
            float z = 27.5f + (float)(i * 10);
            GlowingCuboid bottomLeftLaser = new GlowingCuboid(this.mapController, new Hitbox(new Vector3f(-0.05f, -150.0f, -0.05f), new Vector3f(0.05f, 0.0f, 0.05f)), new Vector3f(2.0f, -2.0f, z), new Quaternionf().rotationYXZ(-0.34906584f, 0.5235988f, 0.0f));
            lights.put(lightID++, bottomLeftLaser);
            GlowingCuboid bottomRightLaser = new GlowingCuboid(this.mapController, new Hitbox(new Vector3f(-0.05f, -150.0f, -0.05f), new Vector3f(0.05f, 0.0f, 0.05f)), new Vector3f(-2.0f, -2.0f, z), new Quaternionf().rotationYXZ(0.34906584f, 0.5235988f, 0.0f));
            lights.put(lightID++, bottomRightLaser);
        }
        return new StaticLightsGroup(this.mapController, lights);
    }

    @Override
    protected LightGroupV2 setupCenterLasers() {
        HashMap<Integer, LightObject> lights = new HashMap<Integer, LightObject>();
        int lightID = 1;
        for (int i = 0; i < 5; ++i) {
            float z = 27.5f + (float)(i * 10);
            GlowingCuboid topLeftLaser = new GlowingCuboid(this.mapController, new Hitbox(new Vector3f(-0.05f, 0.0f, -0.05f), new Vector3f(0.05f, 200.0f, 0.05f)), new Vector3f(3.0f, -1.0f, z), new Quaternionf().rotationYXZ(-0.34906584f, 0.5235988f, 0.0f));
            lights.put(lightID++, topLeftLaser);
            GlowingCuboid topRightLaser = new GlowingCuboid(this.mapController, new Hitbox(new Vector3f(-0.05f, 0.0f, -0.05f), new Vector3f(0.05f, 200.0f, 0.05f)), new Vector3f(-3.0f, -1.0f, z), new Quaternionf().rotationYXZ(0.34906584f, 0.5235988f, 0.0f));
            lights.put(lightID++, topRightLaser);
        }
        GlowingCuboid leftSlanted = TriangleEnvironment.getSlantedLaser(this.mapController, true);
        GlowingCuboid rightSlanted = TriangleEnvironment.getSlantedLaser(this.mapController, false);
        lights.put(lightID++, leftSlanted);
        lights.put(lightID++, rightSlanted);
        return new StaticLightsGroup(this.mapController, lights);
    }

    @Override
    protected LightGroupV2 setupRingLights() {
        this.ringLights = new RingLightGroup(this.mapController, m -> new InnerRing(this.mapController), m -> new OuterRing(this.mapController, (TriFunction<BeatmapController, Vector3f, Quaternionf, LightObject>)m), () -> new GlowingCuboid(this.mapController, new Hitbox(new Vector3f(-3.0f, -0.2f, -0.2f), new Vector3f(3.0f, 0.2f, 0.2f)), new Vector3f(0.0f, 26.79f, 0.2f), new Quaternionf()));
        return this.ringLights;
    }

    @Override
    public void render(PoseStack matrices, Camera camera, float alpha) {
        super.render(matrices, camera, alpha);
        float t = this.mapController.currentSeconds;
        this.leftSpectrogramTowers.render(t);
        this.rightSpectrogramTowers.render(t);
    }

    @Override
    public TriangleEnvironment reset() {
        super.reset();
        this.ringLights.reset();
        return this;
    }
}

