/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.lightshow.event.handlers;

import com.beatcraft.client.lightshow.environment.lightgroup.LightGroupV2;
import com.beatcraft.client.lightshow.event.events.LightEventV2;
import com.beatcraft.client.lightshow.event.handlers.LightEventHandlerV2;
import com.beatcraft.client.lightshow.lights.LightState;
import java.util.HashMap;
import java.util.List;

public class LightGroupEventHandlerV2 {
    private final LightGroupV2 lightGroupV2;
    private final HashMap<Integer, LightEventHandlerV2> handlers = new HashMap();

    public LightGroupEventHandlerV2(LightGroupV2 group, List<LightEventV2> events) {
        this.lightGroupV2 = group;
        group.lights.forEach((lightID, light) -> {
            List<LightEventV2> relevantEvents = events.stream().filter(o -> o.containsLightID((int)lightID)).toList();
            this.handlers.put((Integer)lightID, new LightEventHandlerV2(relevantEvents));
        });
    }

    public void seek(float beat) {
        this.handlers.forEach((id, handler) -> handler.seek(beat));
    }

    public void update(float beat) {
        this.handlers.forEach((id, handler) -> {
            LightState state = (LightState)handler.update(beat);
            this.lightGroupV2.setLightState((int)id, state);
        });
    }

    public void reset() {
        this.handlers.forEach((k, v) -> v.reset());
    }
}

