/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.logic;

import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PhysicsTransform {
    private final Matrix4f currentTransform = new Matrix4f();
    private final Matrix4f previousTransform = new Matrix4f();
    private final Vector3f v0 = new Vector3f();
    private final Vector3f v1 = new Vector3f();
    private final Quaternionf q0 = new Quaternionf();
    private final Quaternionf q1 = new Quaternionf();
    private static final Vector3f ZERO = new Vector3f();

    public PhysicsTransform(float x, float y, float z) {
        this.v0.set(x, y, z);
        this.currentTransform.translate((Vector3fc)this.v0);
        this.previousTransform.translate((Vector3fc)this.v0);
    }

    public void update(Matrix4f newTransform) {
        this.previousTransform.set((Matrix4fc)this.currentTransform);
        this.currentTransform.set((Matrix4fc)newTransform);
    }

    public Vector3f getPositionalVelocity(float deltaTime, Vector3f offset, Vector3f dest) {
        this.previousTransform.transformPosition((Vector3fc)offset, this.v0);
        this.currentTransform.transformPosition((Vector3fc)offset, this.v1);
        return this.v1.sub((Vector3fc)this.v0, dest).div(deltaTime);
    }

    public Vector3f getPositionalVelocity(float deltaTime, Vector3f dest) {
        return this.getPositionalVelocity(deltaTime, ZERO, dest);
    }

    public Vector3f getAngularVelocity(float deltaTime, Vector3f dest) {
        this.previousTransform.getNormalizedRotation(this.q0);
        this.currentTransform.getNormalizedRotation(this.q1);
        this.q0.conjugate();
        this.q1.mul((Quaternionfc)this.q0, this.q1);
        float scale = 2.0f / deltaTime;
        dest.set(this.q1.x * scale, this.q1.y * scale, this.q1.z * scale);
        return dest;
    }

    public Vector3f getPosition(Vector3f offset, Vector3f dest) {
        return this.currentTransform.transformPosition((Vector3fc)offset, dest);
    }

    public Vector3f getPosition(Vector3f dest) {
        return this.getPosition(ZERO, dest);
    }

    public Quaternionf getRotation(Quaternionf dest) {
        return this.currentTransform.getUnnormalizedRotation(dest);
    }
}

