/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.dynamic_loader;

import com.beatcraft.Beatcraft;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;

public class DynamicTexture {
    private static final HashMap<ResourceLocation, DynamicTexture> loadedTextures = new HashMap();
    private final ResourceLocation textureID;
    private final int width;
    private final int height;
    private final String path;
    private NativeImage img;
    private net.minecraft.client.renderer.texture.DynamicTexture tex;

    private String filterString(String in) {
        return in.replaceAll("[^a-z0-9/._-]", "_").replaceAll("(?i)\\.jpe?g$", ".png");
    }

    public DynamicTexture(String path) throws IOException {
        this.path = path.replaceAll("(?i)\\.jpe?g$", ".png");
        this.img = NativeImage.read((InputStream)new FileInputStream(this.path.replace("\\", "/")));
        this.tex = new net.minecraft.client.renderer.texture.DynamicTexture(this.img);
        this.width = this.img.getWidth();
        this.height = this.img.getHeight();
        this.textureID = Beatcraft.id("dynamic/" + this.filterString(this.path.toLowerCase()));
        DynamicTexture.unloadTextureFromId(this.textureID);
        Minecraft.getInstance().getTextureManager().register(this.textureID, (AbstractTexture)this.tex);
        loadedTextures.put(this.textureID, this);
    }

    public void reload() {
        Minecraft.getInstance().getTextureManager().release(this.textureID);
        try {
            this.img = NativeImage.read((InputStream)new FileInputStream(this.path.replace("\\", "/")));
            this.tex = new net.minecraft.client.renderer.texture.DynamicTexture(this.img);
        }
        catch (IOException e) {
            Beatcraft.LOGGER.error("Failed to reload texture '{}'", (Object)this.path, (Object)e);
        }
        Minecraft.getInstance().getTextureManager().register(this.textureID, (AbstractTexture)this.tex);
        if (!loadedTextures.containsKey(this.textureID)) {
            loadedTextures.put(this.textureID, this);
        }
    }

    public boolean isLoaded() {
        return loadedTextures.containsKey(this.textureID);
    }

    public DynamicTexture getFromId(ResourceLocation id) {
        return loadedTextures.get(id);
    }

    public ResourceLocation id() {
        return this.textureID;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public static void unloadAllTextures() {
        loadedTextures.clear();
    }

    public void unloadTexture() {
        if (!this.isLoaded()) {
            return;
        }
        Minecraft.getInstance().getTextureManager().release(this.textureID);
        loadedTextures.remove(this.textureID);
    }

    public static void unloadTextureFromId(ResourceLocation id) {
        if (loadedTextures.containsKey(id)) {
            Minecraft.getInstance().getTextureManager().release(id);
            loadedTextures.remove(id);
        }
    }
}

