/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.effect;

import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.logic.Hitbox;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.beatcraft.common.memory.MemoryPool;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.logging.log4j.util.BiConsumer;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ObstacleGlowRenderer {
    public static ShaderInstance distortionShader;
    public static ShaderInstance blitShader;
    public static TextureTarget framebuffer;

    public static void init() {
        try {
            distortionShader = new ShaderInstance((ResourceProvider)Minecraft.getInstance().getResourceManager(), "col_distortion", DefaultVertexFormat.POSITION_TEX_COLOR);
            blitShader = new ShaderInstance((ResourceProvider)Minecraft.getInstance().getResourceManager(), "blit_screen", DefaultVertexFormat.POSITION_TEX);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void grabScreen() {
        RenderTarget scene = Minecraft.getInstance().getMainRenderTarget();
        scene.unbindWrite();
        scene.bindRead();
        framebuffer.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        framebuffer.clear(true);
        framebuffer.bindWrite(true);
        BeatcraftRenderer.bloomfog.overrideBuffer = true;
        BeatcraftRenderer.bloomfog.overrideFramebuffer = framebuffer;
        distortionShader.setSampler("DiffuseSampler", (Object)scene.getColorTextureId());
        RenderSystem.setShaderTexture((int)0, (int)scene.getColorTextureId());
        RenderSystem.setShader(() -> blitShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(-1.0f, -1.0f, 0.0f).setUv(0.0f, 0.0f);
        buffer.addVertex(-1.0f, 1.0f, 0.0f).setUv(0.0f, 1.0f);
        buffer.addVertex(1.0f, 1.0f, 0.0f).setUv(1.0f, 1.0f);
        buffer.addVertex(1.0f, -1.0f, 0.0f).setUv(1.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        scene.unbindRead();
        framebuffer.unbindWrite();
        BeatcraftRenderer.bloomfog.overrideBuffer = false;
        BeatcraftRenderer.bloomfog.overrideFramebuffer = null;
        Minecraft.getInstance().getMainRenderTarget().bindWrite(true);
    }

    private static Vector3f[] buildEdge(Vector3f pos1, Vector3f pos2, Vector3f cameraPos) {
        Vector3f lineNormal = MemoryPool.newVector3f(pos1).sub((Vector3fc)pos2).normalize();
        Vector3f p1normal = MemoryPool.newVector3f(pos1).sub((Vector3fc)cameraPos).normalize();
        Vector3f p2normal = MemoryPool.newVector3f(pos2).sub((Vector3fc)cameraPos).normalize();
        Vector3f p1offset = MemoryPool.newVector3f(lineNormal).cross((Vector3fc)p1normal).normalize().mul(0.05f);
        Vector3f p2offset = lineNormal.cross((Vector3fc)p2normal).normalize().mul(0.05f);
        Vector3f[] out = new Vector3f[]{MemoryPool.newVector3f(pos1).add((Vector3fc)p1offset), MemoryPool.newVector3f(pos1).sub((Vector3fc)p1offset), MemoryPool.newVector3f(pos2).sub((Vector3fc)p2offset), MemoryPool.newVector3f(pos2).add((Vector3fc)p2offset)};
        MemoryPool.release(p1normal, p2normal, p1offset, p2offset);
        return out;
    }

    public static void render(BeatmapController map, Vector3f position, Quaternionf orientation, Hitbox bounds, int color) {
        if (distortionShader == null) {
            ObstacleGlowRenderer.init();
        }
        map.recordLaserRenderCall((BiConsumer<BufferBuilder, Vector3f>)((BiConsumer)(buffer, camera) -> ObstacleGlowRenderer._render(position, orientation, bounds, color, buffer, camera, false)));
        Vector3f p = MemoryPool.newVector3f(position);
        Quaternionf o = MemoryPool.newQuaternionf(orientation);
        map.recordLaserPreRenderCall((BiConsumer<BufferBuilder, Vector3f>)((BiConsumer)(buffer, camera) -> ObstacleGlowRenderer._render(p, o, bounds, color, buffer, camera, false)));
    }

    public static void renderMirrored(BeatmapController map, Vector3f position, Quaternionf orientation, Hitbox bounds, int color) {
        Vector3f flippedPos = position.mul(1.0f, -1.0f, 1.0f);
        Quaternionf flippedOrientation = MemoryPool.newQuaternionf(-orientation.x, orientation.y, -orientation.z, orientation.w);
        MemoryPool.release(orientation);
    }

    public static void _render(Vector3f position, Quaternionf orientation, Hitbox bounds, int color, BufferBuilder buffer, Vector3f cameraPos, boolean mirrored) {
        List<Vector3f[]> edges = BeatcraftRenderer.getCubeEdges(bounds.min, bounds.max);
        Vector3f e0 = MemoryPool.newVector3f();
        Vector3f e1 = MemoryPool.newVector3f();
        for (Vector3f[] edge : edges) {
            e0.set((Vector3fc)edge[0]).mul(1.0f, mirrored ? -1.0f : 1.0f, 1.0f).rotate((Quaternionfc)orientation).add((Vector3fc)position);
            e1.set((Vector3fc)edge[1]).mul(1.0f, mirrored ? -1.0f : 1.0f, 1.0f).rotate((Quaternionfc)orientation).add((Vector3fc)position);
            Vector3f[] mesh = ObstacleGlowRenderer.buildEdge(e0, e1, cameraPos);
            int fadeColor = 0xFFFFFF & color | 0x1000000;
            buffer.addVertex(e0.x - cameraPos.x, e0.y - cameraPos.y, e0.z - cameraPos.z).setColor(-1);
            buffer.addVertex(e1.x - cameraPos.x, e1.y - cameraPos.y, e1.z - cameraPos.z).setColor(-1);
            buffer.addVertex(mesh[3].x - cameraPos.x, mesh[3].y - cameraPos.y, mesh[3].z - cameraPos.z).setColor(fadeColor);
            buffer.addVertex(mesh[0].x - cameraPos.x, mesh[0].y - cameraPos.y, mesh[0].z - cameraPos.z).setColor(fadeColor);
            buffer.addVertex(e0.x - cameraPos.x, e0.y - cameraPos.y, e0.z - cameraPos.z).setColor(-1);
            buffer.addVertex(e1.x - cameraPos.x, e1.y - cameraPos.y, e1.z - cameraPos.z).setColor(-1);
            buffer.addVertex(mesh[2].x - cameraPos.x, mesh[2].y - cameraPos.y, mesh[2].z - cameraPos.z).setColor(fadeColor);
            buffer.addVertex(mesh[1].x - cameraPos.x, mesh[1].y - cameraPos.y, mesh[1].z - cameraPos.z).setColor(fadeColor);
            MemoryPool.release(mesh);
        }
        MemoryPool.release(e0, e1);
        MemoryPool.release(position);
    }

    static {
        framebuffer = new TextureTarget(1920, 1080, true, true);
    }
}

