/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.instancing.lightshow.light_object;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.animation.Easing;
import com.beatcraft.client.lightshow.lights.LightState;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.beatcraft.client.render.effect.Bloomfog;
import com.beatcraft.client.render.effect.MirrorHandler;
import com.beatcraft.client.render.gl.GlUtil;
import com.beatcraft.client.render.instancing.lightshow.light_object.RectanglePacker;
import com.beatcraft.common.data.types.Color;
import com.beatcraft.common.memory.MemoryPool;
import com.beatcraft.common.utils.JsonUtil;
import com.beatcraft.common.utils.MathUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBInstancedArrays;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.system.MemoryUtil;

public class LightMesh {
    public static final HashMap<String, LightMesh> meshes = new HashMap();
    private static final ArrayList<ResourceLocation> unloadedTextures = new ArrayList();
    private static final HashMap<ResourceLocation, Vector2f> uvMap = new HashMap();
    public static boolean initialized = false;
    private static int atlasGlId;
    private final ArrayList<Triangle> triangles;
    private final HashMap<Integer, ResourceLocation> meshTextures;
    private boolean doBloom = true;
    private boolean doSolid = true;
    private boolean doMirroring = true;
    private int bloomfogStyle = 0;
    private boolean cullBackfaces = false;
    private int shaderProgram = 0;
    private int mirrorProgram = 0;
    private int bloomProgram = 0;
    private int bloomfogProgram = 0;
    private int vao;
    private int vertexVbo;
    private int uvVbo;
    private int normalVbo;
    private int materialVbo;
    private int indicesVbo;
    private int instanceVbo;
    private int indicesLength;
    private boolean loaded = false;
    private final ArrayList<Draw> draws = new ArrayList();
    private final ArrayList<Draw> mirrorDraws = new ArrayList();
    private final ArrayList<Draw> bloomfogDraws = new ArrayList();
    private final ArrayList<Draw> bloomDraws = new ArrayList();
    private static final ResourceLocation lightObjectVsh;
    private static final ResourceLocation lightObjectFsh;
    private static final int COLOR_COUNT = 8;
    private static final int FRAME_SIZE = 48;
    private static final int STRIDE = 192;

    public static void buildMeshes() {
        if (initialized) {
            return;
        }
        uvMap.clear();
        AtlasBuilder atlasBuilder = new AtlasBuilder(1024);
        try (NativeImage atlas = new NativeImage(1024, 1024, false);){
            ResourceManager manager = Minecraft.getInstance().getResourceManager();
            for (ResourceLocation ident : unloadedTextures) {
                Resource in = (Resource)manager.getResource(ident).orElseThrow(() -> new RuntimeException("File '" + String.valueOf(ident) + "' could not be loaded"));
                try {
                    InputStream input = in.open();
                    try {
                        NativeImage tex = NativeImage.read((NativeImage.Format)NativeImage.Format.RGBA, (InputStream)input);
                        int w = tex.getWidth();
                        int h = tex.getHeight();
                        Vector2i pos = new Vector2i();
                        if (atlasBuilder.add(new Vector2i(w, h), pos)) {
                            Vector2f uv = new Vector2f((float)pos.x / 1024.0f, (float)pos.y / 1024.0f);
                            Beatcraft.LOGGER.info("Texture {} starts at UV {}", (Object)ident, (Object)uv);
                            uvMap.put(ident, uv);
                            tex.copyRect(atlas, 0, 0, pos.x, pos.y, w, h, false, false);
                            continue;
                        }
                        throw new RuntimeException("Atlas size exceeded");
                    }
                    finally {
                        if (input == null) continue;
                        input.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            atlasGlId = GL31.glGenTextures();
            GL31.glBindTexture((int)3553, (int)atlasGlId);
            GL31.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL31.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL31.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL31.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)1024, (int)1024, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
            atlas.upload(0, 0, 0, 0, 0, 1024, 1024, false, true);
            initialized = true;
        }
        meshes.values().forEach(LightMesh::buildMesh);
    }

    protected LightMesh(HashMap<Integer, ResourceLocation> unloadedTextures) {
        this.triangles = new ArrayList();
        this.meshTextures = unloadedTextures;
        LightMesh.unloadedTextures.addAll(unloadedTextures.values());
    }

    protected void addTriangle(Triangle tri) {
        this.triangles.add(tri);
    }

    public void draw(Matrix4f transform, LightState[] colors) {
        if (this.doSolid) {
            this.draws.add(Draw.create(transform, colors));
        }
        if (this.doMirroring) {
            Vector3f c = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f();
            Vector3f renderPos = transform.getTranslation(MemoryPool.newVector3f());
            Quaternionf renderRotation = transform.getUnnormalizedRotation(MemoryPool.newQuaternionf());
            Vector3f renderScale = transform.getScale(MemoryPool.newVector3f());
            Matrix4f flipped = new Matrix4f().scale(1.0f, -1.0f, 1.0f);
            flipped.translate(0.0f, c.y * 2.0f, 0.0f);
            flipped.translate((Vector3fc)renderPos);
            flipped.rotate((Quaternionfc)renderRotation);
            flipped.scale((Vector3fc)renderScale);
            this.mirrorDraws.add(Draw.create(transform, colors));
        }
        if (this.bloomfogStyle < 2) {
            this.bloomfogDraws.add(Draw.create(transform, colors));
        }
        if (this.doBloom) {
            this.bloomDraws.add(Draw.create(transform, colors));
        }
    }

    private String processShaderSource(String source) {
        return GlUtil.reProcess(source);
    }

    private void putVec3f(FloatBuffer buf, Vector3f vec) {
        buf.put(vec.x).put(vec.y).put(vec.z);
    }

    private void putVec3i(IntBuffer buf, int a, int b, int c) {
        buf.put(a).put(b).put(c);
    }

    private void uploadFloatBuffer(int vbo, int location, int size, FloatBuffer buffer) {
        GL15.glBindBuffer((int)34962, (int)vbo);
        GL15.glBufferData((int)34962, (FloatBuffer)buffer, (int)35044);
        GL20.glVertexAttribPointer((int)location, (int)size, (int)5126, (boolean)false, (int)0, (long)0L);
        GL20.glEnableVertexAttribArray((int)location);
        MemoryUtil.memFree((Buffer)buffer);
    }

    private void uploadIntBuffer(int vbo, int location, int size, IntBuffer buffer) {
        GL15.glBindBuffer((int)34962, (int)vbo);
        GL15.glBufferData((int)34962, (IntBuffer)buffer, (int)35044);
        GL30.glVertexAttribIPointer((int)location, (int)size, (int)5124, (int)0, (long)0L);
        GL20.glEnableVertexAttribArray((int)location);
        MemoryUtil.memFree((Buffer)buffer);
    }

    private void buildMesh() {
        if (this.loaded) {
            return;
        }
        this.shaderProgram = GlUtil.createShaderProgram(lightObjectVsh, lightObjectFsh, this::processShaderSource);
        this.vao = GL45C.glCreateVertexArrays();
        GL30.glBindVertexArray((int)this.vao);
        this.vertexVbo = GL15.glGenBuffers();
        this.indicesVbo = GL15.glGenBuffers();
        this.uvVbo = GL15.glGenBuffers();
        this.normalVbo = GL15.glGenBuffers();
        this.materialVbo = GL15.glGenBuffers();
        FloatBuffer uvBuffer = MemoryUtil.memAllocFloat((int)(this.triangles.size() * 3 * 2));
        FloatBuffer normalBuffer = MemoryUtil.memAllocFloat((int)(this.triangles.size() * 3 * 3));
        IntBuffer materialBuffer = MemoryUtil.memAllocInt((int)(this.triangles.size() * 3 * 3));
        ArrayList<Vector3f> vertices = new ArrayList<Vector3f>();
        for (Triangle tri : this.triangles) {
            vertices.add(tri.a.vertex);
            vertices.add(tri.b.vertex);
            vertices.add(tri.c.vertex);
            Vector2f offset = uvMap.get(this.meshTextures.get(tri.data.textureId));
            uvBuffer.put(tri.a.uv.x + offset.x).put(tri.a.uv.y + offset.y);
            uvBuffer.put(tri.b.uv.x + offset.x).put(tri.b.uv.y + offset.y);
            uvBuffer.put(tri.c.uv.x + offset.x).put(tri.c.uv.y + offset.y);
            this.putVec3f(normalBuffer, tri.a.normal);
            this.putVec3f(normalBuffer, tri.b.normal);
            this.putVec3f(normalBuffer, tri.c.normal);
            this.putVec3i(materialBuffer, tri.data.colorId, tri.data.materialId, 0);
            this.putVec3i(materialBuffer, tri.data.colorId, tri.data.materialId, 0);
            this.putVec3i(materialBuffer, tri.data.colorId, tri.data.materialId, 0);
        }
        FloatBuffer vertexBuffer = MemoryUtil.memAllocFloat((int)(vertices.size() * 3));
        IntBuffer indexBuffer = MemoryUtil.memAllocInt((int)vertices.size());
        this.indicesLength = vertices.size();
        float[] verts = new float[vertices.size() * 3];
        int[] indices = new int[vertices.size()];
        int i = 0;
        for (Vector3f vert : vertices) {
            verts[i * 3] = vert.x;
            verts[i * 3 + 1] = vert.y;
            verts[i * 3 + 2] = vert.z;
            indices[i] = i++;
        }
        vertexBuffer.put(verts);
        indexBuffer.put(indices);
        vertexBuffer.flip();
        indexBuffer.flip();
        uvBuffer.flip();
        normalBuffer.flip();
        materialBuffer.flip();
        this.uploadFloatBuffer(this.vertexVbo, 0, 3, vertexBuffer);
        this.uploadFloatBuffer(this.uvVbo, 1, 2, uvBuffer);
        this.uploadFloatBuffer(this.normalVbo, 2, 3, normalBuffer);
        this.uploadIntBuffer(this.materialVbo, 3, 3, materialBuffer);
        GL15.glBindBuffer((int)34963, (int)this.indicesVbo);
        GL15.glBufferData((int)34963, (IntBuffer)indexBuffer, (int)35044);
        MemoryUtil.memFree((Buffer)indexBuffer);
        this.setupInstanceBuffer();
        GL30.glBindVertexArray((int)0);
        GL30.glBindBuffer((int)34962, (int)0);
        this.loaded = true;
    }

    private void setupInstanceBuffer() {
        int location;
        int i;
        this.instanceVbo = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)this.instanceVbo);
        for (i = 0; i < 4; ++i) {
            location = 4 + i;
            GL20.glVertexAttribPointer((int)location, (int)4, (int)5126, (boolean)false, (int)192, (long)(i * 16));
            GL20.glEnableVertexAttribArray((int)location);
            ARBInstancedArrays.glVertexAttribDivisorARB((int)location, (int)1);
        }
        for (i = 0; i < 8; ++i) {
            location = Location.color(i);
            GL20.glVertexAttribPointer((int)location, (int)4, (int)5126, (boolean)false, (int)192, (long)(64 + i * 16));
            GL20.glEnableVertexAttribArray((int)location);
            ARBInstancedArrays.glVertexAttribDivisorARB((int)location, (int)1);
        }
    }

    public static void renderAllSolid() {
        for (LightMesh mesh : meshes.values()) {
            mesh.renderSolid();
        }
    }

    public static void renderAllMirror() {
        for (LightMesh mesh : meshes.values()) {
            mesh.renderMirror();
        }
    }

    public static void renderAllBloom(int sceneDepthBuffer) {
        for (LightMesh mesh : meshes.values()) {
            mesh.renderBloom(sceneDepthBuffer);
        }
    }

    public static void renderAllBloomfog() {
        for (LightMesh mesh : meshes.values()) {
            mesh.renderBloomfog();
        }
    }

    public static void cancelMirrorDraws() {
        for (LightMesh mesh : meshes.values()) {
            mesh.cancelMirrorDraw();
        }
    }

    public static void cancelBloomDraws() {
        for (LightMesh mesh : meshes.values()) {
            mesh.cancelBloomDraw();
        }
    }

    public void renderSolid() {
        this.render(this.draws, false, false, -1);
    }

    public void renderMirror() {
        this.render(this.mirrorDraws, true, false, -1);
    }

    private void cancelMirrorDraw() {
        this.mirrorDraws.clear();
    }

    public void renderBloom(int sceneDepthBuffer) {
        this.render(this.bloomDraws, false, true, sceneDepthBuffer);
    }

    private void cancelBloomDraw() {
        this.bloomDraws.clear();
    }

    public void renderBloomfog() {
        this.render(this.bloomfogDraws, true, false, -1);
    }

    private void render(ArrayList<Draw> drawList, boolean preBloomfog, boolean isBloom, int sceneDepthBuffer) {
        if (drawList.isEmpty()) {
            return;
        }
        IntBuffer vaoBuf = BufferUtils.createIntBuffer((int)1);
        GL11.glGetIntegerv((int)34229, (IntBuffer)vaoBuf);
        int oldVAO = vaoBuf.get(0);
        IntBuffer vboBuf = BufferUtils.createIntBuffer((int)1);
        GL11.glGetIntegerv((int)34964, (IntBuffer)vboBuf);
        int oldVBO = vboBuf.get(0);
        GL30.glBindVertexArray((int)this.vao);
        ARBInstancedArrays.glVertexAttribDivisorARB((int)0, (int)0);
        ARBInstancedArrays.glVertexAttribDivisorARB((int)1, (int)0);
        ARBInstancedArrays.glVertexAttribDivisorARB((int)2, (int)0);
        for (int loc : Location.ALL_INSTANCED) {
            ARBInstancedArrays.glVertexAttribDivisorARB((int)loc, (int)1);
        }
        GlUtil.useProgram(this.shaderProgram);
        GlUtil.setTex(this.shaderProgram, "u_texture", 0, atlasGlId);
        Bloomfog fog = BeatcraftRenderer.bloomfog;
        int currentFbo = GL11.glGetInteger((int)36006);
        if (preBloomfog) {
            fog.extraBuffer.setClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            fog.extraBuffer.clear(false);
            fog.extraBuffer.bindRead();
            GlUtil.setTex(this.shaderProgram, "u_bloomfog", 1, fog.extraBuffer.getColorTextureId());
        } else {
            GlUtil.setTex(this.shaderProgram, "u_bloomfog", 1, fog.blurredBuffer.getColorTextureId());
        }
        int passType = isBloom ? 1 : (preBloomfog ? 2 : 0);
        GlUtil.uniform1i("passType", passType);
        if (sceneDepthBuffer != -1) {
            GlUtil.setTex(this.shaderProgram, "u_depth", 2, sceneDepthBuffer);
        }
        Vector3f camPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f();
        float[] fogHeights = Bloomfog.getFogHeights(camPos);
        GlUtil.uniform2f("u_fog", fogHeights[0], fogHeights[1]);
        Quaternionf q = MemoryPool.newQuaternionf();
        if (isBloom || preBloomfog) {
            q.set((Quaternionfc)MirrorHandler.invCameraRotation);
        }
        Vector3f p = MemoryPool.newVector3f();
        Vector3f cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f();
        p.set((Vector3fc)cameraPos).negate();
        Matrix4f projMat = RenderSystem.getProjectionMatrix();
        Matrix4f viewMat = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix()).rotate((Quaternionfc)q);
        MemoryPool.releaseSafe(q);
        MemoryPool.releaseSafe(p);
        GlUtil.uniformMat4f("u_projection", projMat);
        GlUtil.uniformMat4f("u_view", viewMat);
        Matrix4f worldTransform = new Matrix4f();
        worldTransform.translate((Vector3fc)cameraPos);
        worldTransform.rotate((Quaternionfc)MirrorHandler.invCameraRotation.conjugate(new Quaternionf()));
        GlUtil.setMat4f(this.shaderProgram, "world_transform", worldTransform);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        if (!this.cullBackfaces) {
            RenderSystem.disableCull();
        }
        FloatBuffer instanceBuffer = MemoryUtil.memAllocFloat((int)(drawList.size() * 48));
        int instanceCount = drawList.size();
        for (Draw draw : drawList) {
            draw.upload(instanceBuffer, isBloom);
        }
        instanceBuffer.flip();
        GL15.glBindBuffer((int)34962, (int)this.instanceVbo);
        GL15.glBufferData((int)34962, (FloatBuffer)instanceBuffer, (int)35048);
        MemoryUtil.memFree((Buffer)instanceBuffer);
        GL31.glBindFramebuffer((int)36160, (int)currentFbo);
        GL31.glDrawElementsInstanced((int)4, (int)this.indicesLength, (int)5125, (long)0L, (int)instanceCount);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        if (!this.cullBackfaces) {
            RenderSystem.enableCull();
        }
        if (preBloomfog) {
            fog.extraBuffer.unbindRead();
            fog.extraBuffer.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        }
        GL20.glUseProgram((int)0);
        for (Object loc : (Object)Location.ALL_INSTANCED) {
            ARBInstancedArrays.glVertexAttribDivisorARB((int)loc, (int)0);
        }
        GL15.glBindBuffer((int)34962, (int)oldVBO);
        GL30.glBindVertexArray((int)oldVAO);
        drawList.forEach(Draw::free);
        drawList.clear();
    }

    public void cleanup() {
        GL15.glDeleteBuffers((int)this.vertexVbo);
        GL15.glDeleteBuffers((int)this.uvVbo);
        GL15.glDeleteBuffers((int)this.normalVbo);
        GL15.glDeleteBuffers((int)this.materialVbo);
        GL15.glDeleteBuffers((int)this.indicesVbo);
        GL15.glDeleteBuffers((int)this.instanceVbo);
        GL30.glDeleteVertexArrays((int)this.vao);
        GlUtil.destroyShaderProgram(this.shaderProgram);
    }

    public static void cleanupAll() {
        for (LightMesh mesh : meshes.values()) {
            mesh.cleanup();
        }
        meshes.clear();
        unloadedTextures.clear();
    }

    public static LightMesh load(String name, ResourceLocation source) throws IOException {
        BufferedReader reader = ((Resource)Minecraft.getInstance().getResourceManager().getResource(source).orElseThrow()).openAsReader();
        String rawJson = String.join((CharSequence)"\n", reader.lines().toList());
        JsonObject json = JsonParser.parseString((String)rawJson).getAsJsonObject();
        Integer format = JsonUtil.getOrDefault(json, "mesh_format", JsonElement::getAsInt, Integer.valueOf(0));
        if (format != 1) {
            throw new IOException("Mesh is not in a known format");
        }
        HashMap<String, MeshConstructor> parts = new HashMap<String, MeshConstructor>();
        HashMap<Integer, ResourceLocation> textures = new HashMap<Integer, ResourceLocation>();
        HashMap<String, TriangleData> data = new HashMap<String, TriangleData>();
        JsonObject rawData = json.get("data").getAsJsonObject();
        TriangleData defaultData = new TriangleData(0, 0, 0).extend(rawData.get("default").getAsJsonObject());
        for (String key : rawData.keySet()) {
            JsonObject dat = rawData.get(key).getAsJsonObject();
            data.put(key, defaultData.extend(dat));
        }
        JsonObject rawTextures = json.get("textures").getAsJsonObject();
        for (int i = 0; i < 3; ++i) {
            if (!rawTextures.has(String.valueOf(i))) continue;
            textures.put(i, ResourceLocation.tryParse((String)rawTextures.get(String.valueOf(i)).getAsString()));
        }
        JsonObject rawPartsData = json.get("parts").getAsJsonObject();
        for (String partName : rawPartsData.keySet()) {
            JsonObject partData = rawPartsData.get(partName).getAsJsonObject();
            MeshConstructor builder = new MeshConstructor();
            parts.put(partName, builder);
            if (partData.has("vertices")) {
                builder.addVertices(partData.getAsJsonArray("vertices"));
            }
            if (partData.has("named_vertices")) {
                builder.addNamedVertices(partData.getAsJsonObject("named_vertices"));
            }
            if (partData.has("compute_vertices")) {
                builder.addComputeVertices(partData.getAsJsonObject("compute_vertices"));
            }
            if (partData.has("uvs")) {
                builder.addUvs(partData.getAsJsonArray("uvs"));
            }
            if (partData.has("named_uvs")) {
                builder.addNamedUvs(partData.getAsJsonObject("named_uvs"));
            }
            if (partData.has("normals")) {
                builder.addNormals(partData.getAsJsonArray("normals"));
            }
            if (partData.has("named_normals")) {
                builder.addNamedNormals(partData.getAsJsonObject("named_normals"));
            }
            if (partData.has("compute_normals")) {
                builder.addComputeNormals(partData.getAsJsonObject("compute_normals"));
            }
            JsonArray triangleDataList = partData.getAsJsonArray("triangles");
            Vector2f defaultUv = builder.getUv(0);
            Object defaultUvi = 0;
            Vector3f defaultNormal = builder.getNormal(0);
            Object defaultNormali = 0;
            for (JsonElement item : triangleDataList) {
                if (item.isJsonObject()) {
                    JsonObject obj = item.getAsJsonObject();
                    JsonElement uv = obj.get("uv");
                    defaultUvi = uv.isJsonPrimitive() && uv.getAsJsonPrimitive().isNumber() ? Integer.valueOf(uv.getAsInt()) : uv.getAsString();
                    defaultUv = builder.getUv(defaultUvi);
                    JsonElement n = obj.get("normal");
                    defaultNormali = n.isJsonPrimitive() && n.getAsJsonPrimitive().isNumber() ? Integer.valueOf(n.getAsInt()) : n.getAsString();
                    defaultNormal = builder.getNormal(defaultNormali);
                    continue;
                }
                if (!item.isJsonArray()) continue;
                JsonArray arr = item.getAsJsonArray();
                JsonElement ra = arr.get(0);
                JsonElement rb = arr.get(1);
                JsonElement rc = arr.get(2);
                VertexData a = LightMesh.parseData(builder, ra, defaultUv, defaultNormal);
                VertexData b = LightMesh.parseData(builder, rb, defaultUv, defaultNormal);
                VertexData c = LightMesh.parseData(builder, rc, defaultUv, defaultNormal);
                if (arr.size() == 4) {
                    JsonElement mat = arr.get(3);
                    if (mat.isJsonObject()) {
                        TriangleData dat = defaultData.extend(mat.getAsJsonObject());
                        builder.addTriangle(new Triangle(a, b, c, dat, null));
                        continue;
                    }
                    builder.addTriangle(new Triangle(a, b, c, data.get(mat.getAsString()), mat.getAsString()));
                    continue;
                }
                if (arr.size() == 5) {
                    JsonElement baseMat = arr.get(3);
                    JsonElement modifier = arr.get(4);
                    builder.addTriangle(new Triangle(a, b, c, data.get(baseMat.getAsString()).extend(modifier.getAsJsonObject()), baseMat.getAsString()));
                    continue;
                }
                builder.addTriangle(new Triangle(a, b, c, defaultData, "default"));
            }
        }
        JsonArray rawMesh = json.getAsJsonArray("mesh");
        LightMesh mesh = new LightMesh(textures);
        meshes.put(name, mesh);
        mesh.cullBackfaces = JsonUtil.getOrDefault(json, "cull", JsonElement::getAsBoolean, Boolean.valueOf(mesh.cullBackfaces));
        mesh.doBloom = JsonUtil.getOrDefault(json, "bloom_pass", JsonElement::getAsBoolean, Boolean.valueOf(mesh.doBloom));
        mesh.doMirroring = JsonUtil.getOrDefault(json, "mirror_pass", JsonElement::getAsBoolean, Boolean.valueOf(mesh.doMirroring));
        mesh.bloomfogStyle = JsonUtil.getOrDefault(json, "bloomfog_style", JsonElement::getAsInt, Integer.valueOf(mesh.bloomfogStyle));
        mesh.doSolid = JsonUtil.getOrDefault(json, "solid_pass", JsonElement::getAsBoolean, Boolean.valueOf(mesh.doSolid));
        for (JsonElement dat : rawMesh) {
            JsonObject transform = dat.getAsJsonObject();
            String partName = transform.get("part").getAsString();
            MeshConstructor part = (MeshConstructor)parts.get(partName);
            part.addToMesh(mesh, transform, data);
        }
        return mesh;
    }

    private static VertexData parseData(MeshConstructor builder, JsonElement vertex, Vector2f defaultUv, Vector3f defaultNormal) {
        if (vertex.isJsonArray()) {
            JsonArray data = vertex.getAsJsonArray();
            JsonPrimitive v = data.get(0).getAsJsonPrimitive();
            Vector3f vec = builder.getVertex(v.isString() ? v.getAsString() : Integer.valueOf(v.getAsInt()));
            if (data.size() == 2) {
                JsonPrimitive v0 = data.get(1).getAsJsonPrimitive();
                Vector2f uv = builder.getUv(v0.isString() ? v0.getAsString() : Integer.valueOf(v0.getAsInt()));
                return new VertexData(vec, uv, defaultNormal);
            }
            JsonPrimitive v0 = data.get(1).getAsJsonPrimitive();
            Vector2f uv = builder.getUv(v0.isString() ? v0.getAsString() : Integer.valueOf(v0.getAsInt()));
            JsonPrimitive v1 = data.get(2).getAsJsonPrimitive();
            Vector3f norm = builder.getNormal(v1.isString() ? v1.getAsString() : Integer.valueOf(v1.getAsInt()));
            return new VertexData(vec, uv, norm);
        }
        JsonPrimitive v = vertex.getAsJsonPrimitive();
        Vector3f vec = builder.getVertex(v.isString() ? v.getAsString() : Integer.valueOf(v.getAsInt()));
        return new VertexData(vec, defaultUv, defaultNormal);
    }

    static {
        lightObjectVsh = Beatcraft.id("shaders/instanced/light_object.vsh");
        lightObjectFsh = Beatcraft.id("shaders/instanced/light_object.fsh");
    }

    protected static class AtlasBuilder {
        public final int maxWidth;
        public final int maxHeight;
        private final RectanglePacker packer;

        protected AtlasBuilder(int size) {
            this.maxWidth = size;
            this.maxHeight = size;
            this.packer = new RectanglePacker(size, size);
        }

        protected boolean add(Vector2i size, Vector2i posOut) {
            Vector2i out = this.packer.pack(size.x, size.y);
            if (out != null) {
                posOut.set((Vector2ic)out);
                return true;
            }
            return false;
        }
    }

    private record Draw(Matrix4f transform, LightState[] colors) {
        private static final Stack<Draw> shared = new Stack();

        public static Draw create(Matrix4f transform, LightState[] colors) {
            if (shared.empty()) {
                LightState[] copyColors = new LightState[colors.length];
                for (int i = 0; i < colors.length; ++i) {
                    copyColors[i] = colors[i].copy();
                }
                return new Draw(new Matrix4f((Matrix4fc)transform), copyColors);
            }
            Draw inst = shared.pop();
            inst.transform.set((Matrix4fc)transform);
            for (int i = 0; i < colors.length; ++i) {
                inst.colors[i].set(colors[i]);
            }
            return inst;
        }

        public void free() {
            shared.push(this);
        }

        public void upload(FloatBuffer buffer, boolean isBloom) {
            buffer.put(this.transform.m00()).put(this.transform.m01()).put(this.transform.m02()).put(this.transform.m03());
            buffer.put(this.transform.m10()).put(this.transform.m11()).put(this.transform.m12()).put(this.transform.m13());
            buffer.put(this.transform.m20()).put(this.transform.m21()).put(this.transform.m22()).put(this.transform.m23());
            buffer.put(this.transform.m30()).put(this.transform.m31()).put(this.transform.m32()).put(this.transform.m33());
            for (LightState lightState : this.colors) {
                int c = isBloom ? lightState.getBloomColor() : lightState.getEffectiveColor();
                Color color = new Color(c);
                buffer.put(color.getRed()).put(color.getGreen()).put(color.getBlue()).put(color.getAlpha());
            }
        }
    }

    protected record Triangle(VertexData a, VertexData b, VertexData c, TriangleData data, String baseMaterial) {
        protected Triangle transform(JsonObject transformation, HashMap<String, TriangleData> materials) {
            if (transformation.has("scale") || transformation.has("remap_data") || transformation.has("position") || transformation.has("rotation")) {
                JsonObject remapping;
                JsonElement newMat;
                Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
                Vector3f pos = new Vector3f();
                Quaternionf rotation = new Quaternionf();
                TriangleData mat = this.data;
                String baseMat = null;
                if (transformation.has("remap_data") && (newMat = (remapping = transformation.getAsJsonObject("remap_data")).get(this.baseMaterial)) != null) {
                    mat = materials.get(newMat.getAsString());
                    baseMat = newMat.getAsString();
                }
                boolean reWind = false;
                if (transformation.has("scale")) {
                    scale = JsonUtil.getVector3(transformation.getAsJsonArray("scale"));
                    boolean bl = reWind = scale.x * scale.y * scale.z < 0.0f;
                }
                if (transformation.has("position")) {
                    pos = JsonUtil.getVector3(transformation.getAsJsonArray("position"));
                }
                if (transformation.has("rotation")) {
                    Vector4f rot = JsonUtil.getVector4(transformation.getAsJsonArray("rotation"));
                    rotation = new Quaternionf(rot.x, rot.y, rot.z, rot.w).normalize();
                }
                VertexData a = this.a.transform(scale, pos, rotation);
                VertexData b = this.b.transform(scale, pos, rotation);
                VertexData c = this.c.transform(scale, pos, rotation);
                if (reWind) {
                    return new Triangle(c, b, a, mat, baseMat);
                }
                return new Triangle(a, b, c, mat, baseMat);
            }
            return this;
        }
    }

    protected record VertexData(Vector3f vertex, Vector2f uv, Vector3f normal) {
        protected VertexData transform(Vector3f scale, Vector3f pos, Quaternionf rot) {
            Vector3f v = new Vector3f((Vector3fc)this.vertex).mul((Vector3fc)scale).rotate((Quaternionfc)rot).add((Vector3fc)pos);
            Vector3f n = new Vector3f((Vector3fc)this.normal).mul((Vector3fc)scale).rotate((Quaternionfc)rot).normalize();
            return new VertexData(v, this.uv, n);
        }
    }

    protected record TriangleData(int colorId, int materialId, int textureId) {
        protected TriangleData extend(JsonObject overrides) {
            Integer colId = JsonUtil.getOrDefault(overrides, "color", JsonElement::getAsInt, Integer.valueOf(this.colorId));
            Integer matId = JsonUtil.getOrDefault(overrides, "material", JsonElement::getAsInt, Integer.valueOf(this.materialId));
            Integer tex = JsonUtil.getOrDefault(overrides, "texture", JsonElement::getAsInt, Integer.valueOf(this.textureId));
            return new TriangleData(colId, matId, tex);
        }
    }

    private static final class Location {
        static final int POSITION = 0;
        static final int UV = 1;
        static final int NORMAL = 2;
        static final int LAYERS = 3;
        static final int TRANSFORM = 4;
        static final int[] ALL_INSTANCED = new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};

        private Location() {
        }

        static int color(int channel) {
            return 8 + Math.clamp((long)channel, 0, 7);
        }
    }

    private static class MeshConstructor {
        private final ArrayList<Vector3f> vertices = new ArrayList();
        private final ArrayList<Vector2f> uvs = new ArrayList();
        private final ArrayList<Vector3f> normals = new ArrayList();
        private final HashMap<String, Integer> namedVertices = new HashMap();
        private final HashMap<String, Integer> namedUvs = new HashMap();
        private final HashMap<String, Integer> namedNormals = new HashMap();
        private final ArrayList<Triangle> triangles = new ArrayList();

        private MeshConstructor() {
        }

        protected void addTriangle(Triangle tri) {
            this.triangles.add(tri);
        }

        protected void addToMesh(LightMesh mesh, JsonObject transform, HashMap<String, TriangleData> materials) {
            for (Triangle tri : this.triangles) {
                mesh.addTriangle(tri.transform(transform, materials));
            }
        }

        protected Vector3f getVertex(Object idxOrName) {
            if (idxOrName instanceof Integer) {
                Integer i = (Integer)idxOrName;
                return this.vertices.get(i);
            }
            if (idxOrName instanceof String) {
                String s = (String)idxOrName;
                Integer idx = this.namedVertices.get(s);
                if (idx == null) {
                    throw new IllegalArgumentException("vertex name is not valid");
                }
                return this.vertices.get(idx);
            }
            throw new IllegalArgumentException("idxOrName must be a String or and Integer");
        }

        protected Vector3f getNormal(Object idxOrName) {
            if (idxOrName instanceof Integer) {
                Integer i = (Integer)idxOrName;
                return this.normals.get(i);
            }
            if (idxOrName instanceof String) {
                String s = (String)idxOrName;
                Integer idx = this.namedNormals.get(s);
                if (idx == null) {
                    throw new IllegalArgumentException("vec name '" + s + "' is not valid");
                }
                return this.normals.get(idx);
            }
            throw new IllegalArgumentException("idxOrName must be a String or and Integer");
        }

        protected Vector2f getUv(Object idxOrName) {
            if (idxOrName instanceof Integer) {
                Integer i = (Integer)idxOrName;
                return this.uvs.get(i);
            }
            if (idxOrName instanceof String) {
                String s = (String)idxOrName;
                Integer idx = this.namedUvs.get(s);
                if (idx == null) {
                    throw new IllegalArgumentException("uv name is not valid");
                }
                return this.uvs.get(idx);
            }
            throw new IllegalArgumentException("idxOrName must be a String or and Integer");
        }

        protected void addVertices(JsonArray vertices) {
            vertices.forEach(v -> this.vertices.add(JsonUtil.getVector3(v.getAsJsonArray())));
        }

        protected void addNamedVertices(JsonObject vertices) {
            for (String key : vertices.keySet()) {
                JsonElement val = vertices.get(key);
                int i = this.vertices.size();
                this.vertices.add(JsonUtil.getVector3(val.getAsJsonArray()));
                this.namedVertices.put(key, i);
            }
        }

        protected void addUvs(JsonArray uvs) {
            uvs.forEach(uv -> this.uvs.add(JsonUtil.getVector2(uv.getAsJsonArray()).div(1024.0f)));
        }

        protected void addNamedUvs(JsonObject uvs) {
            for (String key : uvs.keySet()) {
                JsonElement val = uvs.get(key);
                int i = this.uvs.size();
                this.uvs.add(JsonUtil.getVector2(val.getAsJsonArray()).div(1024.0f));
                this.namedUvs.put(key, i);
            }
        }

        protected void addNormals(JsonArray normals) {
            normals.forEach(normal -> this.normals.add(JsonUtil.getVector3(normal.getAsJsonArray())));
        }

        protected void addNamedNormals(JsonObject normals) {
            for (String key : normals.keySet()) {
                JsonElement val = normals.get(key);
                int i = this.normals.size();
                this.normals.add(JsonUtil.getVector3(val.getAsJsonArray()));
                this.namedNormals.put(key, i);
            }
        }

        private Vector3f computeVertex(JsonObject json) {
            int vy;
            int vx;
            JsonArray points = json.getAsJsonArray("points");
            JsonPrimitive ra = points.get(0).getAsJsonPrimitive();
            JsonPrimitive rb = points.get(1).getAsJsonPrimitive();
            Vector3f a = this.getVertex(ra.isString() ? ra.getAsString() : Integer.valueOf(ra.getAsInt()));
            Vector3f b = this.getVertex(rb.isString() ? rb.getAsString() : Integer.valueOf(rb.getAsInt()));
            Vector3f delta = b.sub((Vector3fc)a, new Vector3f());
            int n = delta.x == 0.0f ? 0 : (vx = delta.x > 0.0f ? 1 : -1);
            int n2 = delta.y == 0.0f ? 0 : (vy = delta.y > 0.0f ? 1 : -1);
            int vz = delta.z == 0.0f ? 0 : (delta.z > 0.0f ? 1 : -1);
            Float dt = JsonUtil.getOrDefault(json, "delta", JsonElement::getAsFloat, Float.valueOf(0.0f));
            Function<Float, Float> f = Easing.getEasing(JsonUtil.getOrDefault(json, "function", JsonElement::getAsString, "easeLinear"));
            Vector3f point = MathUtil.lerpVector3(a, b, f.apply(dt).floatValue());
            if (json.has("x")) {
                float x = json.get("x").getAsFloat();
                point.x = a.x + (float)vx * x;
                float dx = MathUtil.inverseLerp(0.0f, b.x - a.x, (float)vx * x);
                if (!json.has("y")) {
                    point.y = Mth.lerp((float)dx, (float)a.y, (float)b.y);
                }
                if (!json.has("z")) {
                    point.z = Mth.lerp((float)dx, (float)a.z, (float)b.z);
                }
            }
            if (json.has("y")) {
                float y = json.get("y").getAsFloat();
                point.y = a.y + (float)vy * y;
                float dy = MathUtil.inverseLerp(0.0f, b.y - a.y, (float)vy * y);
                if (!json.has("x")) {
                    point.x = Mth.lerp((float)dy, (float)a.x, (float)b.x);
                }
                if (!json.has("z")) {
                    point.z = Mth.lerp((float)dy, (float)a.z, (float)b.z);
                }
            }
            if (json.has("z")) {
                float z = json.get("z").getAsFloat();
                point.z = a.z + (float)vz * z;
                float dz = MathUtil.inverseLerp(0.0f, b.z - a.z, (float)vz * z);
                if (!json.has("x")) {
                    point.x = Mth.lerp((float)dz, (float)a.x, (float)b.x);
                }
                if (!json.has("y")) {
                    point.y = Mth.lerp((float)dz, (float)a.y, (float)b.y);
                }
            }
            return point;
        }

        protected void addComputeVertices(JsonObject json) {
            for (String key : json.keySet()) {
                JsonObject rawValue = json.get(key).getAsJsonObject();
                Vector3f vec = this.computeVertex(rawValue);
                int i = this.vertices.size();
                this.vertices.add(vec);
                this.namedVertices.put(key, i);
            }
        }

        private Vector3f computeNormal(JsonArray json) {
            JsonPrimitive ra = json.get(0).getAsJsonPrimitive();
            JsonPrimitive rb = json.get(1).getAsJsonPrimitive();
            JsonPrimitive rc = json.get(2).getAsJsonPrimitive();
            Vector3f a = this.getVertex(ra.isString() ? ra.getAsString() : Integer.valueOf(ra.getAsInt()));
            Vector3f b = this.getVertex(rb.isString() ? rb.getAsString() : Integer.valueOf(rb.getAsInt()));
            Vector3f c = this.getVertex(rc.isString() ? rc.getAsString() : Integer.valueOf(rc.getAsInt()));
            Vector3f ab = b.sub((Vector3fc)a, new Vector3f());
            Vector3f ac = c.sub((Vector3fc)a, new Vector3f());
            return ab.cross((Vector3fc)ac).normalize();
        }

        protected void addComputeNormals(JsonObject json) {
            for (String key : json.keySet()) {
                JsonArray rawValue = json.get(key).getAsJsonArray();
                Vector3f vec = this.computeNormal(rawValue);
                int i = this.normals.size();
                this.normals.add(vec);
                this.namedNormals.put(key, i);
            }
        }
    }
}

