/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.lights;

import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.lightshow.lights.LightObject;
import com.beatcraft.client.lightshow.lights.LightState;
import com.beatcraft.client.logic.Hitbox;
import com.beatcraft.client.render.effect.Bloomfog;
import com.beatcraft.client.render.particle.BeatcraftParticleRenderer;
import com.beatcraft.client.render.particle.Particle;
import com.beatcraft.common.data.types.Color;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Camera;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ParticleCloudLight
extends LightObject {
    private final RandomSource random = RandomSource.create();
    private Hitbox spawnRegion;
    private float density;
    private float minParticleLifetime;
    private float maxParticleLifetime;
    private Vector3f particleDelta;
    private final ArrayList<CloudParticleSpawner> particleSpawners = new ArrayList();
    private float regionVolume;
    private float averageLifetime;
    float pt = 0.0f;
    float t = 0.0f;

    public ParticleCloudLight(BeatmapController map, Vector3f position, Quaternionf orientation, Hitbox spawnRegion, float density, float minParticleLifetime, float maxParticleLifetime, Vector3f particleDelta) {
        super(map);
        this.position = position;
        this.orientation = orientation;
        this.spawnRegion = spawnRegion;
        this.density = density;
        this.minParticleLifetime = minParticleLifetime;
        this.maxParticleLifetime = maxParticleLifetime;
        this.particleDelta = particleDelta;
        this.regionVolume = spawnRegion.getVolume();
        this.averageLifetime = (minParticleLifetime + maxParticleLifetime) / 2.0f;
        this.t = this.pt = (float)System.nanoTime() / 1.0E9f;
    }

    public void addParticleSpawners(CloudParticleSpawner ... spawners) {
        this.particleSpawners.addAll(Arrays.asList(spawners));
    }

    @Override
    public LightObject cloneOffset(Vector3f offset) {
        ParticleCloudLight cloud = new ParticleCloudLight(this.mapController, this.position, this.orientation, this.spawnRegion, this.density, this.minParticleLifetime, this.maxParticleLifetime, this.particleDelta);
        cloud.particleSpawners.addAll(this.particleSpawners);
        cloud.position.add((Vector3fc)offset);
        return cloud;
    }

    @Override
    public void render(PoseStack matrices, Camera camera, float alpha, Bloomfog bloomfog) {
        this.pt = this.t;
        this.t = (float)System.nanoTime() / 1.0E9f;
        float dt = this.t - this.pt;
        if (dt > 0.35f) {
            return;
        }
        float expectedParticles = this.density * this.regionVolume / this.averageLifetime * dt;
        int count = (int)expectedParticles;
        if (this.random.nextFloat() < expectedParticles - (float)count) {
            ++count;
        }
        for (int i = 0; i < count; ++i) {
            int index = this.random.nextInt(0, this.particleSpawners.size());
            CloudParticleSpawner spawner = this.particleSpawners.get(index);
            float px = Mth.lerp((float)this.random.nextFloat(), (float)this.spawnRegion.min.x, (float)this.spawnRegion.max.x);
            float py = Mth.lerp((float)this.random.nextFloat(), (float)this.spawnRegion.min.y, (float)this.spawnRegion.max.y);
            float pz = Mth.lerp((float)this.random.nextFloat(), (float)this.spawnRegion.min.z, (float)this.spawnRegion.max.z);
            Particle p = spawner.spawn(new Vector3f(px, py, pz).rotate((Quaternionfc)this.orientation).add((Vector3fc)this.position), new Quaternionf((Quaternionfc)this.orientation), this.particleDelta.rotate((Quaternionfc)this.orientation, new Vector3f()), Mth.lerp((float)this.random.nextFloat(), (float)this.minParticleLifetime, (float)this.maxParticleLifetime), this.lightState);
            BeatcraftParticleRenderer.addParticle(p);
        }
    }

    @Override
    public void setBrightness(float value) {
        this.lightState.setBrightness(value);
    }

    @Override
    public void setColor(int color) {
        this.lightState.setColor(new Color(color));
    }

    public static interface CloudParticleSpawner {
        public Particle spawn(Vector3f var1, Quaternionf var2, Vector3f var3, float var4, LightState var5);
    }
}

