/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.menu;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.BeatcraftClient;
import com.beatcraft.client.audio.AudioController;
import com.beatcraft.client.logic.InputSystem;
import com.beatcraft.client.menu.ModifierMenu;
import com.beatcraft.client.render.HUDRenderer;
import com.beatcraft.client.render.menu.ConfirmSongDeleteMenuPanel;
import com.beatcraft.client.render.menu.MenuPanel;
import com.beatcraft.client.render.menu.SettingsMenuPanel;
import com.beatcraft.client.replay.ReplayHandler;
import com.beatcraft.client.replay.ReplayInfo;
import com.beatcraft.common.data.map.SongDownloader;
import com.beatcraft.common.data.types.CycleStack;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.vivecraft.client_vr.ClientDataHolderVR;

public class ModifierMenuPanel
extends MenuPanel<ModifierMenu> {
    private SongSelectPage currentPage = SongSelectPage.Modifiers;
    private final MenuPanel.ContainerWidget modifierPage = new MenuPanel.ContainerWidget(new Vector3f(0.0f, 0.0f, -0.01f), new Vector2f(), new MenuPanel.Widget[0]);
    private final MenuPanel.ContainerWidget playerOptionsPage = new MenuPanel.ContainerWidget(new Vector3f(0.0f, 0.0f, -0.01f), new Vector2f(), new MenuPanel.Widget[0]);
    private final MenuPanel.ContainerWidget settingsPage = new MenuPanel.ContainerWidget(new Vector3f(0.0f, 0.0f, -0.01f), new Vector2f(), new MenuPanel.Widget[0]);
    private final MenuPanel.ContainerWidget downloaderPage = new MenuPanel.ContainerWidget(new Vector3f(0.0f, 0.0f, -0.01f), new Vector2f(), new MenuPanel.Widget[0]);
    private final MenuPanel.ContainerWidget replayPage = new MenuPanel.ContainerWidget(new Vector3f(0.0f, 0.0f, -0.01f), new Vector2f(), new MenuPanel.Widget[0]);
    private final MenuPanel.ContainerWidget replayPageStatic = new MenuPanel.ContainerWidget(new Vector3f(0.0f, 0.0f, -0.01f), new Vector2f(), new MenuPanel.Widget[0]);
    private final MenuPanel.ContainerWidget customSaberPage = new MenuPanel.ContainerWidget(new Vector3f(0.0f, 0.0f, -0.01f), new Vector2f(), new MenuPanel.Widget[0]);
    private final HashMap<String, MenuPanel.ToggleWidget> toggles = new HashMap();
    private static final Component PLAY = Component.translatable((String)"menu.beatcraft.song_select.play");
    private static final Component DELETE = Component.translatable((String)"menu.beatcraft.song_select.delete");
    public boolean refreshReplays = false;
    protected MenuPanel.ToggleWidget replayToggle;
    private int currentReplayPage = 0;
    private int replaysPerPage = 4;
    private static final Vector3f basePos = new Vector3f(20.0f, -150.0f, 0.0f);
    private static final int height = 360;
    private static final Component RECORD_NEXT = Component.translatable((String)"menu.beatcraft.replay.record_next");

    public ModifierMenuPanel(ModifierMenu data) {
        super(data);
        float angle = 1.0471976f;
        this.position.set(0.0f, 2.0f, 6.4f);
        this.position.rotateY(angle);
        this.orientation.set((Quaternionfc)new Quaternionf().rotateY(angle));
        this.size.set(800.0f, 600.0f);
        this.backgroundColor = 0;
        this.initLayout();
        this.toggleModifiers(((ModifierMenu)this.data).hudRenderer.controller.activeModifiers);
    }

    private void initLayout() {
        this.widgets.clear();
        this.modifierPage.children.clear();
        this.playerOptionsPage.children.clear();
        this.settingsPage.children.clear();
        this.downloaderPage.children.clear();
        this.customSaberPage.children.clear();
        int BUTTON_COUNT = 3;
        this.widgets.addAll(List.of(this.getOptionButton("Modifiers", 0, 0, BUTTON_COUNT, this::setModifierPage, SongSelectPage.Modifiers), this.getOptionButton("Player Options", 1, 0, BUTTON_COUNT, this::setPlayerOptionsPage, SongSelectPage.PlayerOptions), this.getOptionButton("Settings", 2, 0, BUTTON_COUNT, this::setSettingsPage, SongSelectPage.Settings), this.getOptionButton("BeatSaver", 0, 1, BUTTON_COUNT, this::setDownloaderPage, SongSelectPage.Downloader), this.getOptionButton("Replay", 1, 1, BUTTON_COUNT, this::setReplayPage, SongSelectPage.Replay), this.getOptionButton("Custom Sabers", 2, 1, BUTTON_COUNT, this::setSabersPage, SongSelectPage.Sabers)));
        this.modifierPage.children.addAll(List.of(this.getModifierToggle("No Fail", 0, 0, this::toggleNoFail, "1 Life", "4 Lives", "Zen Mode"), this.getModifierToggle("1 Life", 0, 1, this::toggle1Life, "No Fail", "4 Lives", "Zen Mode"), this.getModifierToggle("4 Lives", 0, 2, this::toggle4Lives, "No Fail", "1 Life", "Zen Mode"), this.getModifierToggle("No Bombs", 1, 0, this::toggleNoBombs, "Zen Mode"), this.getModifierToggle("No Walls", 1, 1, this::toggleNoObstacles, "Zen Mode"), this.getModifierToggle("Ghost Notes", 2, 0, this::toggleGhostNotes, "Disappearing Arrows", "Zen Mode"), this.getModifierToggle("Disappearing Arrows", 2, 1, this::toggleDisappearingArrows, "Ghost Notes", "Zen Mode")));
        this.modifierPage.children.addAll(List.of(this.getModifierToggle("Zen Mode", 3, 2, this::toggleZenMode, "No Fail", "1 Life", "4 Lives", "No Bombs", "No Walls", "No Arrows", "Ghost Notes", "Disappearing Arrows", "Small Notes", "Pro Mode", "Strict Angles"), this.getModifierToggle("Slower Song", 4, 0, this::toggleSlowerSong, "Faster Song", "Super Fast Song"), this.getModifierToggle("Faster Song", 4, 1, this::toggleFasterSong, "Slower Song", "Super Fast Song"), this.getModifierToggle("Super Fast Song", 4, 2, this::toggleSuperFastSong, "Slower Song", "Faster Song")));
        this.playerOptionsPage.children.addAll(List.of(SettingsMenuPanel.getOptionModifier("Reduced Debris", () -> BeatcraftClient.playerConfig.preferences.reducedDebris(false), () -> BeatcraftClient.playerConfig.preferences.reducedDebris(true), () -> BeatcraftClient.playerConfig.preferences.reducedDebris() ? "ON" : "OFF", new Vector3f(-100.0f, -175.0f, 0.0f)), SettingsMenuPanel.getOptionModifier("Particles", () -> BeatcraftClient.playerConfig.quality.sparkParticles(false), () -> BeatcraftClient.playerConfig.quality.sparkParticles(true), () -> BeatcraftClient.playerConfig.quality.sparkParticles() ? "ON" : "OFF", new Vector3f(-100.0f, -123.0f, 0.0f)), SettingsMenuPanel.getOptionModifier("Trail Intensity", () -> BeatcraftClient.playerConfig.preferences.trailIntensity(Math.max(3, CycleStack.getTrailSize() - 1)), () -> BeatcraftClient.playerConfig.preferences.trailIntensity(Math.min(200, CycleStack.getTrailSize() + 1)), () -> {
            int x = BeatcraftClient.playerConfig.preferences.trailIntensity();
            return x <= 3 ? "OFF" : String.valueOf(x);
        }, new Vector3f(-100.0f, -71.0f, 0.0f)), SettingsMenuPanel.getOptionModifier("Show Arms", () -> {
            ClientDataHolderVR.getInstance().vrSettings.showPlayerHands = false;
        }, () -> {
            ClientDataHolderVR.getInstance().vrSettings.showPlayerHands = true;
        }, () -> ClientDataHolderVR.getInstance().vrSettings.showPlayerHands ? "SHOW" : "HIDE", new Vector3f(-100.0f, -19.0f, 0.0f)), SettingsMenuPanel.getOptionModifier("Show Hotbar", () -> {
            Minecraft.getInstance().options.hideGui = true;
        }, () -> {
            Minecraft.getInstance().options.hideGui = false;
        }, () -> Minecraft.getInstance().options.hideGui ? "HIDE" : "SHOW", new Vector3f(-100.0f, 32.0f, 0.0f)), SettingsMenuPanel.getOptionModifier("Movement Lock", InputSystem::unlockMovement, InputSystem::lockMovement, () -> InputSystem.isMovementLocked() ? "ON" : "OFF", new Vector3f(-100.0f, 84.0f, 0.0f)), SettingsMenuPanel.getOptionModifier("Show HUD", () -> {
            ((ModifierMenu)this.data).hudRenderer.showHUD = false;
        }, () -> {
            ((ModifierMenu)this.data).hudRenderer.showHUD = true;
        }, () -> ((ModifierMenu)this.data).hudRenderer.showHUD ? "SHOW" : "HIDE", new Vector3f(230.0f, -175.0f, 0.0f)), SettingsMenuPanel.getOptionModifier("Health Style", () -> BeatcraftClient.playerConfig.preferences.healthStyle(BeatcraftClient.playerConfig.preferences.healthStyle().ordinal() - 1), () -> BeatcraftClient.playerConfig.preferences.healthStyle(BeatcraftClient.playerConfig.preferences.healthStyle().ordinal() + 1), () -> BeatcraftClient.playerConfig.preferences.healthStyle().name(), new Vector3f(230.0f, -123.0f, 0.0f))));
        this.settingsPage.children.addAll(List.of(SettingsMenuPanel.getOptionModifier("Volume", () -> this.updateVolume((int)(BeatcraftClient.playerConfig.audio.volume() * 100.0f) - 5), () -> this.updateVolume((int)(BeatcraftClient.playerConfig.audio.volume() * 100.0f) + 5), this::getVolume, new Vector3f(-100.0f, -175.0f, 0.0f)), SettingsMenuPanel.getOptionModifier("Bloomfog", () -> BeatcraftClient.playerConfig.quality.doBloomfog(false), () -> BeatcraftClient.playerConfig.quality.doBloomfog(true), () -> BeatcraftClient.playerConfig.quality.doBloomfog() ? "ON" : "OFF", new Vector3f(230.0f, -175.0f, 0.0f)), SettingsMenuPanel.getOptionModifier("Bloom", () -> BeatcraftClient.playerConfig.quality.doBloom(false), () -> BeatcraftClient.playerConfig.quality.doBloom(true), () -> BeatcraftClient.playerConfig.quality.doBloom() ? "ON" : "OFF", new Vector3f(230.0f, -123.0f, 0.0f)), SettingsMenuPanel.getOptionModifier("Mirror", () -> BeatcraftClient.playerConfig.quality.doMirror(false), () -> BeatcraftClient.playerConfig.quality.doMirror(true), () -> BeatcraftClient.playerConfig.quality.doMirror() ? "ON" : "OFF", new Vector3f(230.0f, -71.0f, 0.0f)), SettingsMenuPanel.getOptionModifier("Sky Fog", () -> BeatcraftClient.playerConfig.quality.skyFog(false), () -> BeatcraftClient.playerConfig.quality.skyFog(true), () -> BeatcraftClient.playerConfig.quality.skyFog() ? "ON" : "OFF", new Vector3f(230.0f, -19.0f, 0.0f))));
        SongDownloader.SearchQueryBuilder q = SongDownloader.queryBuilder;
        this.downloaderPage.children.addAll(List.of(new MenuPanel.TextWidget("Filters (WIP)", new Vector3f(0.0f, -200.0f, 0.01f), 2.5f), this.get3StateBool("Ascending Order", () -> q.ascending, v -> {
            q.ascending = v;
        }, new Vector3f(-200.0f, -150.0f, 0.0f), new Vector2f(250.0f, 45.0f)), this.get3StateBool("Mod: Chroma", () -> q.chroma, v -> {
            q.chroma = v;
        }, new Vector3f(-200.0f, -100.0f, 0.0f), new Vector2f(250.0f, 45.0f)), this.get3StateBool("Mod: Noodle", () -> q.noodle, v -> {
            q.noodle = v;
        }, new Vector3f(-200.0f, -50.0f, 0.0f), new Vector2f(250.0f, 45.0f)), this.get3StateBool("Mod: Vivify*", () -> q.vivify, v -> {
            q.vivify = v;
        }, new Vector3f(-200.0f, 0.0f, 0.0f), new Vector2f(250.0f, 45.0f)), this.get3StateBool("Curated", () -> q.curated, v -> {
            q.curated = v;
        }, new Vector3f(-200.0f, 50.0f, 0.0f), new Vector2f(250.0f, 45.0f)), this.get3StateBool("Verified", () -> q.verified, v -> {
            q.verified = v;
        }, new Vector3f(-200.0f, 100.0f, 0.0f), new Vector2f(250.0f, 45.0f)), new MenuPanel.TextWidget("*Vivify maps are not fully supported", new Vector3f(0.0f, 140.0f, 0.01f), 1.5f)));
        this.customSaberPage.children.add(new MenuPanel.TextWidget("WIP. for now use /custom_sabers", new Vector3f(0.0f, -11.0f, 0.01f), 4.0f));
        this.setupReplayPageStatic();
    }

    private MenuPanel.Widget get3StateBool(String label, Callable<Boolean> getter, Consumer<Boolean> setter, Vector3f position, Vector2f size) {
        return SettingsMenuPanel.getButton(new MenuPanel.TextWidget(() -> {
            Boolean v = (Boolean)getter.call();
            return label + " : " + (v == null ? "--" : (v != false ? "True" : "False"));
        }, new Vector3f(-(size.x / 2.0f) + 5.0f, -11.0f, 0.01f), 2.0f).alignedLeft().withDynamicScaling((int)(size.x / 2.0f)), () -> {
            try {
                Boolean v = (Boolean)getter.call();
                setter.accept(v == null ? Boolean.TRUE : (v != false ? Boolean.FALSE : null));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, position, size);
    }

    private MenuPanel.Widget getOptionButton(String label, int column, int row, int count, Runnable onClick, SongSelectPage page) {
        int AVAILABLE_WIDTH = 750;
        int widgetWidth = AVAILABLE_WIDTH / count;
        int widgetX = -(count * widgetWidth) / 2 + column * widgetWidth + widgetWidth / 2;
        return new MenuPanel.ButtonWidget(new Vector3f((float)widgetX, (float)(-275 + 40 * row), 0.01f), new Vector2f((float)widgetWidth, 40.0f), onClick, new MenuPanel.HoverWidget(new Vector3f(), new Vector2f((float)widgetWidth, 40.0f), List.of(new MenuPanel.DynamicGradientWidget(new Vector3f(), new Vector2f((float)widgetWidth, 40.0f), () -> page == this.currentPage ? 0x5F444444 : 0x5F222222, () -> page == this.currentPage ? 0x5F444444 : 0x5F222222, 0.0f)), List.of(new MenuPanel.DynamicGradientWidget(new Vector3f(), new Vector2f((float)widgetWidth, 40.0f), () -> page == this.currentPage ? 0x5F888888 : 0x5F666666, () -> page == this.currentPage ? 0x5F888888 : 0x5F666666, 0.0f))), new MenuPanel.TextWidget(label, new Vector3f(0.0f, -10.0f, 0.05f)).withScale(2.0f));
    }

    private Consumer<Boolean> getExclusionHandler(String label, Consumer<Boolean> toggleHandler, String ... exclusive) {
        return b -> {
            if (b.booleanValue()) {
                for (String exclude : exclusive) {
                    if (this.toggles.containsKey(exclude)) {
                        this.toggles.get(exclude).setState(false);
                        continue;
                    }
                    Beatcraft.LOGGER.error("Missing exclusive modifier: '{}'", (Object)exclude);
                }
            }
            ((ModifierMenu)this.data).hudRenderer.controller.setModifier(label, (boolean)b);
            toggleHandler.accept((Boolean)b);
        };
    }

    private MenuPanel.Widget getModifierToggle(String label, int row, int column, Consumer<Boolean> toggleHandler, String ... exclusive) {
        boolean CENTER_X = false;
        int CENTER_Y = 120;
        int MAX_WIDTH = 750;
        int MAX_HEIGHT = 400;
        int COLUMNS = 3;
        int widget_height = 64;
        int widget_width = MAX_WIDTH / COLUMNS;
        float x = (float)CENTER_X + ((float)column - (float)(COLUMNS - 1) / 2.0f) * (float)widget_width;
        float y = (float)CENTER_Y - ((float)MAX_HEIGHT / 2.0f - (float)(row * widget_height));
        MenuPanel.ToggleWidget toggle = this.getToggleWidget(widget_width, widget_height, this.getExclusionHandler(label, toggleHandler, exclusive));
        this.toggles.put(label, toggle);
        return new MenuPanel.ContainerWidget(new Vector3f(x, y, 0.0f), new Vector2f((float)widget_width, (float)widget_height), toggle, new MenuPanel.TextWidget(label, new Vector3f(0.0f, -9.0f, 0.05f)).withScale(1.5f));
    }

    private void setModifierPage() {
        this.currentPage = SongSelectPage.Modifiers;
        ((ModifierMenu)this.data).hudRenderer.controller.scene = HUDRenderer.MenuScene.SongSelect;
    }

    private void setPlayerOptionsPage() {
        this.currentPage = SongSelectPage.PlayerOptions;
        ((ModifierMenu)this.data).hudRenderer.controller.scene = HUDRenderer.MenuScene.SongSelect;
    }

    private void setSettingsPage() {
        this.currentPage = SongSelectPage.Settings;
        ((ModifierMenu)this.data).hudRenderer.controller.scene = HUDRenderer.MenuScene.Settings;
    }

    private void setDownloaderPage() {
        this.currentPage = SongSelectPage.Downloader;
        ((ModifierMenu)this.data).hudRenderer.controller.scene = HUDRenderer.MenuScene.Downloader;
    }

    private void setReplayPage() {
        this.currentPage = SongSelectPage.Replay;
        ((ModifierMenu)this.data).hudRenderer.controller.scene = HUDRenderer.MenuScene.SongSelect;
    }

    private void setSabersPage() {
        this.currentPage = SongSelectPage.Sabers;
        ((ModifierMenu)this.data).hudRenderer.controller.scene = HUDRenderer.MenuScene.SaberPreview;
    }

    public void toggleModifiers(List<String> modifiers) {
        this.disableAll();
        modifiers.forEach(this::_toggleModifier);
    }

    private void _toggleModifier(String mod) {
        Consumer<Boolean> a = switch (mod) {
            case "No Fail" -> this::toggleNoFail;
            case "1 Life" -> this::toggle1Life;
            case "4 Lives" -> this::toggle4Lives;
            case "No Bombs" -> this::toggleNoBombs;
            case "No Walls" -> this::toggleNoObstacles;
            case "Ghost Notes" -> this::toggleGhostNotes;
            case "Disappearing Arrows" -> this::toggleDisappearingArrows;
            case "Zen Mode" -> this::toggleZenMode;
            case "Slower Song" -> this::toggleSlowerSong;
            case "Faster Song" -> this::toggleFasterSong;
            case "Super Fast Song" -> this::toggleSuperFastSong;
            default -> b -> {};
        };
        this.toggles.get(mod).setState(true);
        a.accept(true);
    }

    public void disableAll() {
        for (MenuPanel.ToggleWidget toggle : this.toggles.values()) {
            toggle.setState(false);
        }
    }

    private void toggleNoFail(boolean state) {
        ((ModifierMenu)this.data).hudRenderer.controller.logic.noFail = state;
    }

    private void toggle1Life(boolean state) {
        ((ModifierMenu)this.data).hudRenderer.controller.logic.maxHealth = state ? 1 : 100;
        ((ModifierMenu)this.data).hudRenderer.controller.logic.health = state ? 1.0f : 50.0f;
    }

    private void toggle4Lives(boolean state) {
        ((ModifierMenu)this.data).hudRenderer.controller.logic.maxHealth = state ? 4 : 100;
        ((ModifierMenu)this.data).hudRenderer.controller.logic.health = state ? 4.0f : 50.0f;
    }

    private void toggleNoBombs(boolean state) {
    }

    private void toggleNoObstacles(boolean state) {
    }

    private void toggleNoArrows(boolean state) {
    }

    private void toggleGhostNotes(boolean state) {
    }

    private void toggleDisappearingArrows(boolean state) {
    }

    private void toggleSmallNotes(boolean state) {
    }

    private void toggleProMode(boolean state) {
    }

    private void toggleStrictAngles(boolean state) {
    }

    private void toggleZenMode(boolean state) {
    }

    private void toggleSlowerSong(boolean state) {
        ((ModifierMenu)this.data).hudRenderer.controller.setSpeed(state ? 0.85f : 1.0f);
        ((ModifierMenu)this.data).hudRenderer.controller.logic.mapSpeed = state ? 0.85f : 1.0f;
    }

    private void toggleFasterSong(boolean state) {
        ((ModifierMenu)this.data).hudRenderer.controller.setSpeed(state ? 1.2f : 1.0f);
        ((ModifierMenu)this.data).hudRenderer.controller.logic.mapSpeed = state ? 1.2f : 1.0f;
    }

    private void toggleSuperFastSong(boolean state) {
        ((ModifierMenu)this.data).hudRenderer.controller.setSpeed(state ? 1.5f : 1.0f);
        ((ModifierMenu)this.data).hudRenderer.controller.logic.mapSpeed = state ? 1.5f : 1.0f;
    }

    private void updateVolume(int percent) {
        percent = Math.clamp((long)percent, 0, 100);
        AudioController.setVolume((float)percent / 100.0f);
        BeatcraftClient.playerConfig.audio.volume((float)percent / 100.0f);
    }

    private String getVolume() {
        return String.format("%.0f", Float.valueOf(BeatcraftClient.playerConfig.audio.volume() * 100.0f));
    }

    private MenuPanel.Widget getReplayTile(ReplayInfo info, Vector3f position) {
        Vector2f SIZE = new Vector2f(660.0f, 80.0f);
        MenuPanel.Widget[] widgetArray = new MenuPanel.Widget[7];
        widgetArray[0] = new MenuPanel.GradientWidget(new Vector3f(), SIZE, 0x7F000000, 0x7F000000, 0.0f);
        widgetArray[1] = new MenuPanel.TextWidget(info.name(), new Vector3f(-SIZE.x / 2.0f + 5.0f, -35.0f, -0.01f), 3.0f).alignedLeft().withDynamicScaling((int)(SIZE.x - 300.0f) / 3);
        widgetArray[2] = new MenuPanel.TextWidget(info.mapID(), new Vector3f(-SIZE.x / 2.0f + 5.0f, -6.0f, -0.01f), 1.5f).alignedLeft().withDynamicScaling(66);
        widgetArray[3] = new MenuPanel.TextWidget(info.set(), new Vector3f(-SIZE.x / 2.0f + 95.0f, 2.0f, -0.01f), 2.5f).alignedLeft().withDynamicScaling(100);
        widgetArray[4] = new MenuPanel.TextWidget(info.diff(), new Vector3f(-50.0f, 2.0f, -0.01f), 2.5f).alignedLeft().withDynamicScaling(100);
        widgetArray[5] = SettingsMenuPanel.getButton(new MenuPanel.TextWidget(PLAY, new Vector3f(0.0f, -11.0f, -0.01f), 3.0f), info::play, new Vector3f(SIZE.x / 2.0f - 190.0f, 0.0f, 0.0f), new Vector2f(100.0f, 50.0f));
        widgetArray[6] = SettingsMenuPanel.getButton(new MenuPanel.TextWidget(DELETE, new Vector3f(0.0f, -11.0f, -0.01f), 3.0f), () -> {
            ((ModifierMenu)this.data).hudRenderer.confirmSongDeleteMenuPanel = new ConfirmSongDeleteMenuPanel(info);
            ((ModifierMenu)this.data).hudRenderer.controller.scene = HUDRenderer.MenuScene.ConfirmSongDelete;
        }, new Vector3f(SIZE.x / 2.0f - 65.0f, 0.0f, 0.0f), new Vector2f(120.0f, 50.0f));
        return new MenuPanel.ContainerWidget(position, SIZE, widgetArray);
    }

    public void setReplayToggleState(boolean state) {
        this.replayToggle.setState(state);
    }

    public void setupReplayPageStatic() {
        this.replayPageStatic.children.clear();
        this.replayToggle = this.getToggleWidget(230, 50, b -> {
            if (b.booleanValue()) {
                ((ModifierMenu)this.data).hudRenderer.controller.replayHandler.recordNextMap();
            } else {
                ((ModifierMenu)this.data).hudRenderer.controller.replayHandler.cancelRecording();
            }
        });
        this.replayPageStatic.children.addAll(List.of(SettingsMenuPanel.getButton(new MenuPanel.TextureWidget(Beatcraft.id("textures/gui/song_selector/up_arrow.png"), new Vector3f(), new Vector2f(50.0f, 50.0f)).withScale(0.75f), () -> {
            this.currentReplayPage = Math.max(0, this.currentReplayPage - 1);
            this.setupReplayPage();
        }, new Vector3f(-335.0f, -160.0f, 0.0f), new Vector2f(50.0f, 50.0f), 0, 0), SettingsMenuPanel.getButton(new MenuPanel.TextureWidget(Beatcraft.id("textures/gui/song_selector/down_arrow.png"), new Vector3f(), new Vector2f(50.0f, 50.0f)).withScale(0.75f), () -> {
            this.currentReplayPage = Math.min(this.currentReplayPage + 1, ReplayHandler.getReplayCount() / this.replaysPerPage);
            this.setupReplayPage();
        }, new Vector3f(-335.0f, 160.0f, 0.0f), new Vector2f(50.0f, 50.0f), 0, 0), new MenuPanel.ContainerWidget(new Vector3f(0.0f, 220.0f, 0.0f), new Vector2f(230.0f, 50.0f), this.replayToggle, new MenuPanel.TextWidget(RECORD_NEXT, new Vector3f(0.0f, -11.0f, -0.01f), 3.0f))));
        this.setupReplayPage();
    }

    public void setupReplayPage() {
        this.replayPage.children.clear();
        int si = this.currentReplayPage * this.replaysPerPage;
        List<ReplayInfo> replays = ReplayHandler.getReplays(si, this.replaysPerPage);
        int i = 0;
        for (ReplayInfo replay : replays) {
            Vector3f pos = basePos.add(0.0f, (float)i * (360.0f / (float)this.replaysPerPage), 0.0f, new Vector3f());
            this.replayPage.children.add(this.getReplayTile(replay, pos));
            ++i;
        }
    }

    protected MenuPanel.ToggleWidget getToggleWidget(int widget_width, int widget_height, Consumer<Boolean> handler) {
        return new MenuPanel.ToggleWidget(new Vector3f(0.0f, 0.0f, 0.0f), new Vector2f((float)(widget_width - 4), (float)(widget_height - 4)), List.of(new MenuPanel.HoverWidget(new Vector3f(), new Vector2f((float)(widget_width - 4), (float)(widget_height - 4)), List.of(new MenuPanel.GradientWidget(new Vector3f(), new Vector2f((float)(widget_width - 4), (float)(widget_height - 4)), 1594962841, 1594962841, 0.0f)), List.of(new MenuPanel.GradientWidget(new Vector3f(), new Vector2f((float)(widget_width - 4), (float)(widget_height - 4)), 1594966988, 1594966988, 0.0f)))), List.of(new MenuPanel.HoverWidget(new Vector3f(), new Vector2f((float)(widget_width - 4), (float)(widget_height - 4)), List.of(new MenuPanel.GradientWidget(new Vector3f(), new Vector2f((float)(widget_width - 4), (float)(widget_height - 4)), 0x5F222222, 0x5F222222, 0.0f)), List.of(new MenuPanel.GradientWidget(new Vector3f(), new Vector2f((float)(widget_width - 4), (float)(widget_height - 4)), 0x5F666666, 0x5F666666, 0.0f)))), handler);
    }

    @Override
    public void render(MultiBufferSource.BufferSource immediate, Vector2f pointerPosition, boolean triggerPressed) {
        GuiGraphics context = new GuiGraphics(Minecraft.getInstance(), immediate);
        Vector3f camPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f();
        context.pose().translate(-camPos.x, -camPos.y, -camPos.z);
        Vector3f wp = ((ModifierMenu)this.data).hudRenderer.controller.worldPosition;
        context.pose().translate(wp.x, wp.y, wp.z);
        context.pose().mulPose(new Quaternionf().rotationY(((ModifierMenu)this.data).hudRenderer.controller.worldAngle));
        context.pose().translate(this.position.x, this.position.y, this.position.z);
        context.pose().mulPose(this.orientation);
        context.pose().scale(0.0078125f, 0.0078125f, 0.0078125f);
        context.pose().pushPose();
        context.fill((int)(-this.size.x / 2.0f), (int)(-this.size.y / 2.0f), (int)(this.size.x / 2.0f), (int)(this.size.y / 2.0f), this.backgroundColor);
        this.widgets.forEach(w -> w.draw(context, pointerPosition == null ? null : pointerPosition.mul(-128.0f, new Vector2f()), triggerPressed));
        if (this.refreshReplays) {
            this.refreshReplays = false;
            this.setupReplayPage();
        }
        switch (this.currentPage.ordinal()) {
            case 0: {
                this.modifierPage.draw(context, pointerPosition == null ? null : pointerPosition.mul(-128.0f, new Vector2f()), triggerPressed);
                break;
            }
            case 1: {
                this.playerOptionsPage.draw(context, pointerPosition == null ? null : pointerPosition.mul(-128.0f, new Vector2f()), triggerPressed);
                break;
            }
            case 2: {
                this.settingsPage.draw(context, pointerPosition == null ? null : pointerPosition.mul(-128.0f, new Vector2f()), triggerPressed);
                break;
            }
            case 3: {
                this.downloaderPage.draw(context, pointerPosition == null ? null : pointerPosition.mul(-128.0f, new Vector2f()), triggerPressed);
                break;
            }
            case 4: {
                this.replayPage.draw(context, pointerPosition == null ? null : pointerPosition.mul(-128.0f, new Vector2f()), triggerPressed);
                this.replayPageStatic.draw(context, pointerPosition == null ? null : pointerPosition.mul(-128.0f, new Vector2f()), triggerPressed);
                break;
            }
            case 5: {
                this.customSaberPage.draw(context, pointerPosition == null ? null : pointerPosition.mul(-128.0f, new Vector2f()), triggerPressed);
            }
        }
        context.flush();
        context.pose().popPose();
    }

    private static enum SongSelectPage {
        Modifiers,
        PlayerOptions,
        Settings,
        Downloader,
        Replay,
        Sabers;

    }
}

