/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.particle;

import com.beatcraft.client.render.particle.Particle;
import com.beatcraft.client.render.particle.SparkParticle;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BeatcraftParticleRenderer {
    private static final ArrayList<Particle> particles = new ArrayList();
    private static double lastUpdateTime = 0.0;
    private static final Random random = new Random();

    public static Vector3f applyVariance(Vector3f velocity, float variance, float magnitudeVariance) {
        float var;
        float f = var = (magnitudeVariance = Math.abs(magnitudeVariance)) == 0.0f ? 0.0f : random.nextFloat(-magnitudeVariance, magnitudeVariance);
        if (velocity.equals(0.0f, 0.0f, 0.0f)) {
            velocity = new Vector3f(0.0f, var, 0.0f);
            variance = 1.0f;
        }
        if (variance <= 0.0f) {
            return new Vector3f((Vector3fc)velocity).normalize().mul(velocity.length() * (1.0f + var));
        }
        if (variance >= 1.0f) {
            return BeatcraftParticleRenderer.randomDirection(velocity.length());
        }
        Vector3f normalized = new Vector3f((Vector3fc)velocity).normalize();
        Vector3f randomAxis = new Vector3f(random.nextFloat(), random.nextFloat(), random.nextFloat()).normalize();
        float maxAngle = variance * (float)Math.PI;
        float randomAngle = (random.nextFloat() - 0.5f) * 2.0f * maxAngle;
        Vector3f result = new Vector3f((Vector3fc)normalized).rotateAxis(randomAngle, randomAxis.x, randomAxis.y, randomAxis.z);
        result.mul(velocity.length() * (1.0f + var));
        return result;
    }

    public static Vector3f randomDirection(float magnitude) {
        float theta = (float)(Math.PI * 2 * (double)random.nextFloat());
        float phi = (float)Math.acos(2.0f * random.nextFloat() - 1.0f);
        float x = (float)(Math.sin(phi) * Math.cos(theta));
        float y = (float)(Math.sin(phi) * Math.sin(theta));
        float z = (float)Math.cos(phi);
        return new Vector3f(x, y, z).mul(magnitude);
    }

    public static void spawnSparkParticles(Vector3f position, Vector3f velocity, float velocityVariance, float magnitudeVariance, int particleCount, int color, float size) {
        for (int i = 0; i < particleCount; ++i) {
            SparkParticle particle = new SparkParticle(new Vector3f((Vector3fc)position), BeatcraftParticleRenderer.applyVariance(velocity.mul(0.075f), velocityVariance, magnitudeVariance), color, size, random.nextFloat(0.15f, 0.45f), 0.92f);
            particles.add(particle);
        }
    }

    public static void addParticle(Particle particle) {
        particles.add(particle);
    }

    public static void renderParticles() {
        if (particles.isEmpty()) {
            return;
        }
        double t = (double)System.nanoTime() / 1.0E9;
        float dt = (float)(t - lastUpdateTime);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        Vector3f cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        particles.forEach(p -> p.update(dt, buffer, cameraPos));
        lastUpdateTime = t;
        particles.removeIf(Particle::shouldRemove);
        MeshData buff = buffer.build();
        if (buff == null) {
            return;
        }
        BufferUploader.drawWithShader((MeshData)buff);
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }
}

