/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.particle;

import com.beatcraft.client.render.instancing.SmokeInstanceData;
import com.beatcraft.client.render.mesh.MeshLoader;
import com.beatcraft.client.render.particle.Particle;
import com.beatcraft.common.utils.MathUtil;
import com.mojang.blaze3d.vertex.BufferBuilder;
import net.minecraft.util.RandomSource;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SmokeParticle
implements Particle {
    private final Quaternionf spin;
    private static final float LIFETIME = 16.0f;
    public static final float SPAWN_INTERVAL = 5.0f;
    private static final float SPIN_SPEED = 8.726646E-4f;
    private final double spawnTime;
    private final Quaternionf orientation = new Quaternionf();

    public SmokeParticle(RandomSource random) {
        Vector3f axis = new Vector3f((float)random.nextInt(-100, 100) / 100.0f, (float)random.nextInt(-100, 100) / 100.0f, (float)random.nextInt(-100, 100) / 100.0f).normalize();
        this.orientation.rotationAxis((float)random.nextInt(-100, 100) / 100.0f, (Vector3fc)new Vector3f((float)random.nextInt(-100, 100) / 100.0f, (float)random.nextInt(-100, 100) / 100.0f, (float)random.nextInt(-100, 100) / 100.0f).normalize());
        this.spawnTime = (double)System.nanoTime() / 1.0E9;
        this.spin = new Quaternionf().rotationAxis(8.726646E-4f, (Vector3fc)axis);
    }

    @Override
    public void update(float deltaTime, BufferBuilder buffer, Vector3f cameraPos) {
        this.orientation.mul((Quaternionfc)this.spin.scale(deltaTime, new Quaternionf()).normalize());
        double t = (double)System.nanoTime() / 1.0E9;
        float delta = (float)MathUtil.inverseLerp(this.spawnTime, this.spawnTime + 16.0, t);
        MeshLoader.SMOKE_INSTANCED_MESH.draw(SmokeInstanceData.create(this.orientation, cameraPos, delta));
    }

    @Override
    public boolean shouldRemove() {
        double t = (double)System.nanoTime() / 1.0E9;
        return t - this.spawnTime > 16.0;
    }
}

