/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.replay;

import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.replay.ReplayHandler;
import com.beatcraft.common.replay.PlayFrame;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PlayRecorder {
    public final BeatmapController controller;
    public String outputFile;
    public String songID;
    public String difficultySet;
    public String difficulty;
    private final ArrayList<PlayFrame> frames = new ArrayList();

    public PlayRecorder(BeatmapController controller) {
        this.controller = controller;
    }

    public void update(float beat) {
        if (this.outputFile != null && this.controller.isPlaying()) {
            this.frames.add(new PlayFrame(beat, new Vector3f((Vector3fc)this.controller.logic.leftSaberPos), new Quaternionf((Quaternionfc)this.controller.logic.leftSaberRotation), new Vector3f((Vector3fc)this.controller.logic.rightSaberPos), new Quaternionf((Quaternionfc)this.controller.logic.rightSaberRotation), new Vector3f((Vector3fc)this.controller.logic.headPos), new Quaternionf((Quaternionfc)this.controller.logic.headRot)));
        }
    }

    public void seek(float beat) {
        this.frames.removeIf(frame -> frame.beat() >= beat);
    }

    public void save() throws IOException {
        String path = Minecraft.getInstance().gameDirectory.getAbsolutePath() + "/beatcraft/replay/" + this.outputFile;
        byte[] idBytes = this.songID.getBytes(StandardCharsets.UTF_8);
        byte[] setBytes = this.difficultySet.getBytes(StandardCharsets.UTF_8);
        byte[] diffBytes = this.difficulty.getBytes(StandardCharsets.UTF_8);
        int sizeID = idBytes.length;
        int sizeSet = setBytes.length;
        int sizeDiff = diffBytes.length;
        ByteBuffer outputFrames = ByteBuffer.allocate(sizeID + sizeSet + sizeDiff + 88 * this.frames.size() + 20);
        outputFrames.putInt(1);
        outputFrames.putInt(sizeID);
        outputFrames.put(idBytes);
        outputFrames.putInt(sizeSet);
        outputFrames.put(setBytes);
        outputFrames.putInt(sizeDiff);
        outputFrames.put(diffBytes);
        outputFrames.putInt(this.frames.size());
        this.frames.forEach(frame -> frame.write(outputFrames));
        Files.write(Path.of(path, new String[0]), outputFrames.array(), new OpenOption[0]);
        ReplayHandler.loadReplays();
    }

    public void reset() {
        this.frames.clear();
        this.outputFile = null;
        this.songID = null;
        this.difficultySet = null;
        this.difficulty = null;
    }
}

