/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.replay;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.BeatcraftClient;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.render.effect.SaberRenderer;
import com.beatcraft.common.data.components.ModComponents;
import com.beatcraft.common.data.map.SongData;
import com.beatcraft.common.items.ModItems;
import com.beatcraft.common.replay.PlayFrame;
import com.beatcraft.common.utils.MathUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.ArrayListDeque;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class Replayer {
    private final BeatmapController controller;
    private final ArrayList<PlayFrame> frames = new ArrayList();
    private final ArrayListDeque<PlayFrame> upcoming = new ArrayListDeque();
    private PlayFrame current = new PlayFrame(0.0f, new Vector3f(), new Quaternionf(), new Vector3f(), new Quaternionf(), new Vector3f(), new Quaternionf());
    public boolean runReplay = false;
    private final ItemStack leftSaber = new ItemStack((ItemLike)ModItems.SABER_ITEM, 1);
    private final ItemStack rightSaber = new ItemStack((ItemLike)ModItems.SABER_ITEM, 1);

    public Replayer(BeatmapController controller) {
        this.controller = controller;
    }

    public void loadReplay(String replayFile) throws IOException {
        this.frames.clear();
        this.leftSaber.set((DataComponentType)ModComponents.AUTO_SYNC_COLOR.get(), (Object)0);
        this.leftSaber.set((DataComponentType)ModComponents.SABER_COLOR_COMPONENT.get(), (Object)0xC03030);
        this.rightSaber.set((DataComponentType)ModComponents.AUTO_SYNC_COLOR.get(), (Object)1);
        this.rightSaber.set((DataComponentType)ModComponents.SABER_COLOR_COMPONENT.get(), (Object)2122920);
        byte[] rawData = Files.readAllBytes(Path.of(replayFile, new String[0]));
        ByteBuffer buf = ByteBuffer.wrap(rawData);
        int replayVersion = buf.getInt();
        if (replayVersion == 1) {
            this.loadV1(buf);
        }
    }

    private void loadV1(ByteBuffer buf) {
        int idSize = buf.getInt();
        byte[] idBytes = new byte[idSize];
        buf.get(idBytes, 0, idSize);
        String id = new String(idBytes, StandardCharsets.UTF_8);
        int setSize = buf.getInt();
        byte[] setBytes = new byte[setSize];
        buf.get(setBytes, 0, setSize);
        String set = new String(setBytes, StandardCharsets.UTF_8);
        int diffSize = buf.getInt();
        byte[] diffBytes = new byte[diffSize];
        buf.get(diffBytes, 0, diffSize);
        String diff = new String(diffBytes, StandardCharsets.UTF_8);
        int frameCount = buf.getInt();
        this.frames.add(new PlayFrame(0.0f, new Vector3f(), new Quaternionf(), new Vector3f(), new Quaternionf(), new Vector3f(), new Quaternionf()));
        for (int i = 0; i < frameCount; ++i) {
            this.frames.add(PlayFrame.load(buf));
        }
        this.upcoming.addAll(this.frames);
        this.current = (PlayFrame)this.upcoming.pollFirst();
        SongData data = BeatcraftClient.songs.getById(id);
        this.runReplay = true;
        SongData.BeatmapInfo info = data.getBeatMapInfo(set, diff);
        if (info == null) {
            Beatcraft.LOGGER.info("Failed to load {}:{} from song: {}", new Object[]{set, diff, data});
            return;
        }
        this.controller.replayHandler.cancelRecording();
        this.controller.hudRenderer.songSelectMenuPanel.tryPlayMap(info);
    }

    public void reset() {
        this.frames.clear();
        this.upcoming.clear();
        this.runReplay = false;
    }

    public void update(float beat) {
        PlayFrame next;
        block4: {
            if (!this.runReplay || beat < 0.0f) {
                return;
            }
            if (this.frames.isEmpty() || this.upcoming.isEmpty()) {
                return;
            }
            do {
                if ((next = (PlayFrame)this.upcoming.peekFirst()) == null) {
                    return;
                }
                if (!(next.beat() < beat)) break block4;
                this.current = (PlayFrame)this.upcoming.pollFirst();
            } while (this.current != null);
            return;
        }
        float sb = this.current.beat();
        float eb = next.beat();
        float f = MathUtil.inverseLerp(sb, eb, beat);
        Vector3f leftSaberPos = MathUtil.lerpVector3(this.current.leftSaberPosition(), next.leftSaberPosition(), f);
        Vector3f rightSaberPos = MathUtil.lerpVector3(this.current.rightSaberPosition(), next.rightSaberPosition(), f);
        Vector3f headPos = MathUtil.lerpVector3(this.current.headPos(), next.headPos(), f);
        Quaternionf leftSaberRot = MathUtil.lerpQuaternion(this.current.leftSaberRotation(), next.leftSaberRotation(), f);
        Quaternionf rightSaberRot = MathUtil.lerpQuaternion(this.current.rightSaberRotation(), next.rightSaberRotation(), f);
        Quaternionf headRot = MathUtil.lerpQuaternion(this.current.headRotation(), next.headRotation(), f);
        this.controller.logic.rightSaberPos = rightSaberPos;
        this.controller.logic.rightSaberRotation = rightSaberRot;
        this.controller.logic.leftSaberPos = leftSaberPos;
        this.controller.logic.leftSaberRotation = leftSaberRot;
        this.controller.logic.headPos = headPos;
        this.controller.logic.headRot = headRot;
        SaberRenderer.renderReplaySaber(this.leftSaber, leftSaberPos, leftSaberRot);
        SaberRenderer.renderReplaySaber(this.rightSaber, rightSaberPos, rightSaberRot);
    }

    public void seek(float beat) {
        this.upcoming.clear();
        this.upcoming.addAll(this.frames);
    }
}

