/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.resources;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.BeatcraftClient;
import com.beatcraft.client.beatmap.BeatmapManager;
import com.beatcraft.client.lightshow.environment.kaleidoscope.RingSpike;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.beatcraft.client.render.effect.Bloomfog;
import com.beatcraft.client.render.gl.GlUtil;
import com.beatcraft.client.render.instancing.InstancedMesh;
import com.beatcraft.client.render.instancing.lightshow.light_object.LightMesh;
import com.beatcraft.client.render.mesh.MeshLoader;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ResourceReloadListener
implements ResourceManagerReloadListener {
    public void onResourceManagerReload(ResourceManager resourceManager) {
        Beatcraft.LOGGER.info("Reloading client resources");
        InstancedMesh.cleanupAll();
        LightMesh.cleanupAll();
        GlUtil.clear();
        Bloomfog.initShaders();
        Window window = Minecraft.getInstance().getWindow();
        int w = Math.max(1, window.getWidth());
        int h = Math.max(1, window.getHeight());
        if (BeatcraftRenderer.bloomfog == null) {
            BeatcraftRenderer.init();
        }
        BeatcraftRenderer.bloomfog.resize(w, h, true);
        BeatcraftClient.songs.loadSongs();
        BeatmapManager.loadBeatmaps();
        MeshLoader.loadMeshes();
        LightMesh.initialized = false;
        RenderSystem.recordRenderCall(() -> {
            LightMesh.buildMeshes();
            RingSpike.reload();
        });
    }
}

