/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft;

import com.beatcraft.BeatCraft;
import com.beatcraft.BeatmapPlayer;
import com.beatcraft.audio.BeatmapAudioPlayer;
import com.beatcraft.beatmap.data.NoteType;
import com.beatcraft.data.PlayerConfig;
import com.beatcraft.data.menu.SongData;
import com.beatcraft.items.ModItems;
import com.beatcraft.logic.GameLogicHandler;
import com.beatcraft.logic.InputSystem;
import com.beatcraft.menu.SongList;
import com.beatcraft.networking.BeatCraftClientNetworking;
import com.beatcraft.networking.c2s.MapSyncC2SPayload;
import com.beatcraft.render.BeatCraftRenderer;
import com.beatcraft.render.HUDRenderer;
import com.beatcraft.render.block.BlockRenderSettings;
import com.beatcraft.render.dynamic_loader.DynamicTexture;
import com.beatcraft.render.effect.Bloomfog;
import com.beatcraft.render.item.GeckolibRenderInit;
import com.beatcraft.replay.PlayRecorder;
import com.beatcraft.replay.Replayer;
import com.beatcraft.screen.SettingsScreen;
import com.beatcraft.screen.SongDownloaderScreen;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.event.WindowResizeCallback;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.client.player.ClientPreAttackCallback;
import net.minecraft.class_1041;
import net.minecraft.class_1792;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5819;
import net.minecraft.class_8710;
import org.apache.commons.compress.archivers.dump.UnrecognizedFormatException;
import org.joml.Quaternionf;

@Environment(value=EnvType.CLIENT)
public class BeatCraftClient
implements ClientModInitializer {
    public static class_5819 random = class_5819.method_43047();
    public static PlayerConfig playerConfig = null;
    public static final SongList songs = new SongList();
    public static final class_304 settingsKeyBind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.beatcraft.settings", class_3675.class_307.field_1668, 66, "category.beatcraft.keybindings"));
    public static final class_304 songSearchKeybind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.beatcraft.song_search", class_3675.class_307.field_1668, 77, "category.beatcraft.keybindings"));
    public static final class_304 pauseLevelKeybind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.beatcraft.pause_song", class_3675.class_307.field_1668, 67, "category.beatcraft.keybindings"));
    public static final class_304 toggleFPFCKeybind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.beatcraft.toggle_fpfc", class_3675.class_307.field_1668, 86, "category.beatcraft.keybindings"));
    public static final class_304 toggleMovementLock = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.beatcraft.lock_movement", class_3675.class_307.field_1668, 88, "category.beatcraft.keybindings"));
    public static final class_243 playerCameraPosition = new class_243(0.0, 0.0, 0.0);
    public static final Quaternionf playerCameraRotation = new Quaternionf();
    public static final class_243 playerGlobalPosition = new class_243(0.0, 0.0, 0.0);
    public static final Quaternionf playerGlobalRotation = new Quaternionf();
    public static final class_243 playerSaberPosition = new class_243(0.0, 0.0, 0.0);
    public static final Quaternionf playerSaberRotation = new Quaternionf();

    public void onInitializeClient() {
        this.setupFiles();
        this.registerCommands();
        BlockRenderSettings.init();
        GeckolibRenderInit.init();
        BeatCraftClientNetworking.init();
        playerConfig = PlayerConfig.loadFromFile();
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            HUDRenderer.triggerPressed = false;
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            BaseOwoScreen screen;
            if (settingsKeyBind.method_1436()) {
                screen = new SettingsScreen(null);
                client.method_1507((class_437)screen);
                while (settingsKeyBind.method_1436()) {
                }
            }
            if (songSearchKeybind.method_1436()) {
                screen = new SongDownloaderScreen(null);
                client.method_1507((class_437)screen);
                while (songSearchKeybind.method_1436()) {
                }
            }
            if (pauseLevelKeybind.method_1436()) {
                if (GameLogicHandler.isPaused()) {
                    GameLogicHandler.unpauseMap();
                } else {
                    GameLogicHandler.pauseMap();
                }
                while (pauseLevelKeybind.method_1436()) {
                }
            }
            if (toggleFPFCKeybind.method_1436() && client.field_1724 != null) {
                BeatCraftClient.toggleFPFC();
                client.field_1724.method_43496(class_2561.method_30163((String)(GameLogicHandler.FPFC ? "Enabled FPFC" : "Disabled FPFC")));
                while (toggleFPFCKeybind.method_1436()) {
                }
            }
            if (toggleMovementLock.method_1436() && client.field_1724 != null) {
                if (InputSystem.isMovementLocked()) {
                    InputSystem.unlockMovement();
                    client.field_1724.method_43496(class_2561.method_30163((String)"Player movement UNLOCKED!"));
                } else {
                    InputSystem.lockMovement();
                    client.field_1724.method_43496(class_2561.method_30163((String)String.format("Player movement LOCKED! (press \"%s\" to unlock)", toggleMovementLock.method_16007().getString())));
                }
                while (toggleMovementLock.method_1436()) {
                }
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            Bloomfog.initShaders();
            BeatmapAudioPlayer.init();
            class_1041 window = class_310.method_1551().method_22683();
            int w = window.method_4480();
            int h = window.method_4507();
            if (BeatCraftRenderer.bloomfog == null) {
                BeatCraftRenderer.init();
            }
            BeatCraftRenderer.bloomfog.resize(w, h, true);
            songs.loadSongs();
            HUDRenderer.initSongSelectMenuPanel();
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> {
            DynamicTexture.unloadAllTextures();
            BeatCraftRenderer.bloomfog.unload();
            BeatmapAudioPlayer.unmuteVanillaMusic();
            playerConfig.writeToFile();
        });
        ClientPreAttackCallback.EVENT.register((client, player, c) -> {
            if (GameLogicHandler.isTrackingClient() && player.method_6047().method_31574((class_1792)ModItems.SABER_ITEM)) {
                HUDRenderer.triggerPressed = true;
                HUDRenderer.pointerSaber = NoteType.BLUE;
                return true;
            }
            return false;
        });
        WindowResizeCallback.EVENT.register((client, window) -> BeatCraftRenderer.updateBloomfogSize(window.method_4480(), window.method_4507()));
    }

    private void setupFiles() {
        String runDirectory = class_310.method_1551().field_1697.getAbsolutePath();
        List<CallSite> makeFolders = List.of(runDirectory + "/beatmaps/", runDirectory + "/beatcraft/", runDirectory + "/beatcraft/replay/", runDirectory + "/beatcraft/temp/");
        for (String string : makeFolders) {
            File folder = new File(string);
            if (folder.exists()) continue;
            boolean bl = folder.mkdirs();
        }
    }

    private int songPlay(CommandContext<FabricClientCommandSource> context) {
        BeatmapPlayer.play();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Song played"));
        return 1;
    }

    private int songPlayBeat(CommandContext<FabricClientCommandSource> context) {
        float beat = FloatArgumentType.getFloat(context, (String)"beat");
        BeatmapPlayer.play(beat);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Song played at beat " + beat)));
        return 1;
    }

    private int songPause(CommandContext<FabricClientCommandSource> context) {
        BeatmapPlayer.pause();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Song paused"));
        return 1;
    }

    private int songRestart(CommandContext<FabricClientCommandSource> context) {
        BeatmapPlayer.restart();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Song restarted"));
        return 1;
    }

    private int songSpeedReset(CommandContext<FabricClientCommandSource> context) {
        BeatmapPlayer.setPlaybackSpeed(1.0f);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Song speed reset! (1.0)"));
        return 1;
    }

    private int songSpeedScalar(CommandContext<FabricClientCommandSource> context) {
        float speed = FloatArgumentType.getFloat(context, (String)"scalar");
        BeatmapPlayer.setPlaybackSpeed(speed);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Song speed set to " + speed + "!")));
        return 1;
    }

    private int songUnload(CommandContext<FabricClientCommandSource> context) {
        BeatmapPlayer.currentBeatmap = null;
        BeatmapPlayer.currentInfo = null;
        BeatmapAudioPlayer.unload();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Song unloaded!"));
        return 1;
    }

    private int songLoadFile(CommandContext<FabricClientCommandSource> context) {
        String path = StringArgumentType.getString(context, (String)"path");
        path = this.trimPathQuotes(path);
        Replayer.reset();
        if (BeatCraftClient.handleDifficultySetup(context, path) == 1) {
            BeatmapAudioPlayer.playAudioFromFile(BeatmapPlayer.currentInfo.getSongFilename());
            BeatmapPlayer.restart();
            GameLogicHandler.reset();
            return 1;
        }
        return -1;
    }

    private int songList(CommandContext<FabricClientCommandSource> context) {
        return 1;
    }

    private int songRecord(CommandContext<FabricClientCommandSource> context) {
        PlayRecorder.outputFile = StringArgumentType.getString(context, (String)"output_file");
        Replayer.runReplay = false;
        return 1;
    }

    private int songReplay(CommandContext<FabricClientCommandSource> context) {
        String file = StringArgumentType.getString(context, (String)"replay_file");
        try {
            Replayer.loadReplay(file);
            return 1;
        }
        catch (IOException e) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Failed to load replay"));
            BeatCraft.LOGGER.error("Failed to load replay", (Throwable)e);
            return -1;
        }
    }

    private String trimPathQuotes(String path) {
        if (path.startsWith("\"") && path.endsWith("\"")) {
            return path.substring(1, path.length() - 1);
        }
        return path;
    }

    public static int handleDifficultySetup(CommandContext<FabricClientCommandSource> context, String path) {
        try {
            BeatmapPlayer.setupDifficultyFromFile(path);
        }
        catch (UnrecognizedFormatException e) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"That jawn is an unsupported version!"));
            BeatCraft.LOGGER.error("That map is an unsupported version! ", (Throwable)e);
            return -1;
        }
        catch (IOException e) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"That path didn't exist or something!"));
            BeatCraft.LOGGER.error("File could not be found! ", (Throwable)e);
            return -1;
        }
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Beatmap loaded!"));
        return 1;
    }

    private int songScrub(CommandContext<FabricClientCommandSource> context) {
        float beats = FloatArgumentType.getFloat(context, (String)"beats");
        float newBeat = Math.max(0.0f, BeatmapPlayer.getCurrentBeat() + beats);
        BeatmapPlayer.setCurrentBeat(newBeat);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Scrubbed to beat " + newBeat + "!")));
        return 1;
    }

    private int colorFromFloats(CommandContext<FabricClientCommandSource> context) {
        float fr = FloatArgumentType.getFloat(context, (String)"R");
        float fg = FloatArgumentType.getFloat(context, (String)"G");
        float fb = FloatArgumentType.getFloat(context, (String)"B");
        int r = (int)(fr * 255.0f);
        int g = (int)(fg * 255.0f);
        int b = (int)(fb * 255.0f);
        int hex = r;
        hex <<= 8;
        hex += g;
        hex <<= 8;
        String hexStr = Integer.toHexString(hex += b);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("int RGB  : %s, %s, %s\nfloat RGB: %s, %s, %s\npacked color: %s\nhex code: %s", r, g, b, Float.valueOf(fr), Float.valueOf(fg), Float.valueOf(fb), hex, hexStr)));
        return 1;
    }

    private int colorFromIntegers(CommandContext<FabricClientCommandSource> context) {
        int r = IntegerArgumentType.getInteger(context, (String)"R");
        int g = IntegerArgumentType.getInteger(context, (String)"G");
        int b = IntegerArgumentType.getInteger(context, (String)"B");
        float fr = (float)r / 255.0f;
        float fg = (float)g / 255.0f;
        float fb = (float)b / 255.0f;
        int hex = r;
        hex <<= 8;
        hex += g;
        hex <<= 8;
        String hexStr = Integer.toHexString(hex += b);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("int RGB  : %s, %s, %s\nfloat RGB: %s, %s, %s\npacked color: %s\nhex code: %s", r, g, b, Float.valueOf(fr), Float.valueOf(fg), Float.valueOf(fb), hex, hexStr)));
        return 1;
    }

    private int colorFromHex(CommandContext<FabricClientCommandSource> context) {
        String hexStr = StringArgumentType.getString(context, (String)"hex_code");
        try {
            int hex = Integer.parseInt(hexStr, 16);
            int r = hex >> 16 & 0xFF;
            int g = hex >> 8 & 0xFF;
            int b = hex & 0xFF;
            float fr = (float)r / 255.0f;
            float fg = (float)g / 255.0f;
            float fb = (float)b / 255.0f;
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("int RGB  : %s, %s, %s\nfloat RGB: %s, %s, %s\npacked color: %s\nhex code: %s", r, g, b, Float.valueOf(fr), Float.valueOf(fg), Float.valueOf(fb), hex, hexStr)));
        }
        catch (NumberFormatException e) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("Invalid hex: " + e.getMessage())));
        }
        return 1;
    }

    private int songLoad(CommandContext<FabricClientCommandSource> context) {
        String songName = StringArgumentType.getString(context, (String)"song");
        String diffSet = StringArgumentType.getString(context, (String)"difficulty_set");
        String diff = StringArgumentType.getString(context, (String)"difficulty");
        Replayer.reset();
        List<SongData> filtered = songs.getFiltered(songName);
        if (filtered.isEmpty()) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43471((String)"command.beatcraft.error.song_not_found"));
            return -1;
        }
        SongData song = filtered.getFirst();
        if (!song.getDifficultySets().contains(diffSet)) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43471((String)"command.beatcraft.error.difficulty_set_not_found"));
            return -1;
        }
        if (!song.getDifficulties(diffSet).contains(diff)) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43471((String)"command.beatcraft.error.difficulty_not_found"));
            return -1;
        }
        SongData.BeatmapInfo beatmapInfo = song.getBeatMapInfo(diffSet, diff);
        if (PlayRecorder.outputFile != null) {
            PlayRecorder.songName = songName;
            PlayRecorder.difficultySet = diffSet;
            PlayRecorder.difficulty = diff;
        }
        if (BeatCraftClient.handleDifficultySetup(context, beatmapInfo.getBeatmapLocation().toString()) == 1) {
            BeatmapAudioPlayer.playAudioFromFile(BeatmapPlayer.currentInfo.getSongFilename());
            BeatmapPlayer.restart();
            GameLogicHandler.reset();
            if (song.getId() != null) {
                ClientPlayNetworking.send((class_8710)new MapSyncC2SPayload(song.getId(), diffSet, diff));
            }
            HUDRenderer.scene = HUDRenderer.MenuScene.InGame;
            return 1;
        }
        return -1;
    }

    private int enableFPFC(CommandContext<FabricClientCommandSource> context) {
        GameLogicHandler.FPFC = true;
        ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)"Enabled FPFC"));
        return 1;
    }

    private int disableFPFC(CommandContext<FabricClientCommandSource> context) {
        GameLogicHandler.FPFC = false;
        ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)"Disabled FPFC"));
        return 1;
    }

    private int toggleFPFC(CommandContext<FabricClientCommandSource> context) {
        BeatCraftClient.toggleFPFC();
        ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)(GameLogicHandler.FPFC ? "Enabled FPFC" : "Disabled FPFC")));
        return 1;
    }

    private static void toggleFPFC() {
        GameLogicHandler.FPFC = !GameLogicHandler.FPFC;
    }

    private CompletableFuture<Suggestions> songDifficultySuggester(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder suggestionsBuilder) {
        String songName = StringArgumentType.getString(context, (String)"song");
        String diffSet = StringArgumentType.getString(context, (String)"difficulty_set");
        String diffName = suggestionsBuilder.getRemaining();
        List<SongData> filtered = songs.getFiltered(songName);
        if (filtered.isEmpty()) {
            return suggestionsBuilder.buildFuture();
        }
        SongData data = filtered.getFirst();
        List<String> sets = data.getDifficultySets();
        ArrayList<String> filteredSets = new ArrayList<String>();
        for (String set : sets) {
            if (!set.contains(diffSet)) continue;
            filteredSets.add(set);
        }
        if (filteredSets.isEmpty()) {
            return suggestionsBuilder.buildFuture();
        }
        String set = (String)filteredSets.getFirst();
        List<String> diffs = data.getDifficulties(set);
        ArrayList<Object> suggests = new ArrayList<Object>();
        for (String diff : diffs) {
            if (!diff.contains(diffName)) continue;
            suggests.add(diff.contains(" ") ? "\"" + diff + "\"" : diff);
        }
        if (suggests.isEmpty()) {
            return suggestionsBuilder.buildFuture();
        }
        suggests.forEach((Consumer<Object>)((Consumer<String>)arg_0 -> ((SuggestionsBuilder)suggestionsBuilder).suggest(arg_0)));
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> songDifficultySetSuggester(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder suggestionsBuilder) {
        String songName = StringArgumentType.getString(context, (String)"song");
        String diffSet = suggestionsBuilder.getRemaining();
        List<SongData> filtered = songs.getFiltered(songName);
        if (filtered.isEmpty()) {
            return suggestionsBuilder.buildFuture();
        }
        SongData data = filtered.getFirst();
        List<String> sets = data.getDifficultySets();
        ArrayList<Object> suggest = new ArrayList<Object>();
        for (String set : sets) {
            if (!set.contains(diffSet)) continue;
            suggest.add(set.contains(" ") ? "\"" + set + "\"" : set);
        }
        if (suggest.isEmpty()) {
            return suggestionsBuilder.buildFuture();
        }
        suggest.forEach((Consumer<Object>)((Consumer<String>)arg_0 -> ((SuggestionsBuilder)suggestionsBuilder).suggest(arg_0)));
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> songSuggester(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder suggestionsBuilder) {
        String songName = suggestionsBuilder.getRemaining();
        List<SongData> filtered = songs.getFiltered(songName);
        for (SongData song : filtered) {
            suggestionsBuilder.suggest((String)(song.getTitle().contains(" ") ? "\"" + song.getTitle() + "\"" : song.getTitle()));
        }
        return suggestionsBuilder.buildFuture();
    }

    private void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"song").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"play").executes(this::songPlay)).then(ClientCommandManager.argument((String)"beat", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(this::songPlayBeat)))).then(ClientCommandManager.literal((String)"pause").executes(this::songPause))).then(ClientCommandManager.literal((String)"restart").executes(this::songRestart))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"speed").then(ClientCommandManager.literal((String)"reset").executes(this::songSpeedReset))).then(ClientCommandManager.argument((String)"scalar", (ArgumentType)FloatArgumentType.floatArg((float)1.0E-4f, (float)5.0f)).executes(this::songSpeedScalar)))).then(ClientCommandManager.literal((String)"unload").executes(this::songUnload))).then(ClientCommandManager.literal((String)"loadFile").then(ClientCommandManager.argument((String)"path", (ArgumentType)StringArgumentType.greedyString()).executes(this::songLoadFile)))).then(ClientCommandManager.literal((String)"scrub").then(ClientCommandManager.argument((String)"beats", (ArgumentType)FloatArgumentType.floatArg()).executes(this::songScrub)))).then(ClientCommandManager.literal((String)"load").then(ClientCommandManager.argument((String)"song", (ArgumentType)StringArgumentType.string()).suggests(this::songSuggester).then(ClientCommandManager.argument((String)"difficulty_set", (ArgumentType)StringArgumentType.string()).suggests(this::songDifficultySetSuggester).then(ClientCommandManager.argument((String)"difficulty", (ArgumentType)StringArgumentType.string()).suggests(this::songDifficultySuggester).executes(this::songLoad)))))).then(ClientCommandManager.literal((String)"record").then(ClientCommandManager.argument((String)"output_file", (ArgumentType)StringArgumentType.string()).executes(this::songRecord)))).then(ClientCommandManager.literal((String)"replay").then(ClientCommandManager.argument((String)"replay_file", (ArgumentType)StringArgumentType.string()).executes(this::songReplay))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"color_helper").then(ClientCommandManager.literal((String)"hex").then(ClientCommandManager.argument((String)"hex_code", (ArgumentType)StringArgumentType.word()).executes(this::colorFromHex)))).then(ClientCommandManager.literal((String)"intRGB").then(ClientCommandManager.argument((String)"R", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).then(ClientCommandManager.argument((String)"G", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).then(ClientCommandManager.argument((String)"B", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(this::colorFromIntegers)))))).then(ClientCommandManager.literal((String)"floatRGB").then(ClientCommandManager.argument((String)"R", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).then(ClientCommandManager.argument((String)"G", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).then(ClientCommandManager.argument((String)"B", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(this::colorFromFloats))))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"fpfc").then(ClientCommandManager.literal((String)"enable").executes(this::enableFPFC))).then(ClientCommandManager.literal((String)"disable").executes(this::disableFPFC))).executes(this::toggleFPFC));
        });
    }
}

