/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.animation;

import com.beatcraft.BeatCraft;
import com.beatcraft.animation.AnimationPropertyContainer;
import com.beatcraft.animation.AnimationState;
import com.beatcraft.animation.event.AnimatedPathEventContainer;
import com.beatcraft.animation.event.AnimatedPropertyEventContainer;
import com.beatcraft.animation.pointdefinition.FloatPointDefinition;
import com.beatcraft.animation.pointdefinition.QuaternionPointDefinition;
import com.beatcraft.animation.pointdefinition.Vector3PointDefinition;
import com.beatcraft.animation.pointdefinition.Vector4PointDefinition;
import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.beatmap.data.IBeatmapData;
import com.beatcraft.beatmap.data.event.AnimateTrack;
import com.beatcraft.beatmap.data.event.AssignPathAnimation;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3518;

@Environment(value=EnvType.CLIENT)
public class Animation
extends AnimationPropertyContainer<FloatPointDefinition, Vector3PointDefinition, Vector4PointDefinition, QuaternionPointDefinition>
implements IBeatmapData<Animation> {
    @Override
    public Animation loadV2(JsonObject json, Difficulty difficulty) {
        this.offsetPosition = this.getPointDefinition(json, "_position", difficulty, Vector3PointDefinition::new);
        this.offsetWorldRotation = this.getPointDefinition(json, "_rotation", difficulty, QuaternionPointDefinition::new);
        this.localRotation = this.getPointDefinition(json, "_localRotation", difficulty, QuaternionPointDefinition::new);
        this.localPosition = this.getPointDefinition(json, "_localPosition", difficulty, Vector3PointDefinition::new);
        this.definitePosition = this.getPointDefinition(json, "_definitePosition", difficulty, Vector3PointDefinition::new);
        this.position = this.getPointDefinition(json, "_position", difficulty, Vector3PointDefinition::new);
        this.rotation = this.getPointDefinition(json, "_rotation", difficulty, QuaternionPointDefinition::new);
        this.scale = this.getPointDefinition(json, "_scale", difficulty, Vector3PointDefinition::new);
        this.dissolve = this.getPointDefinition(json, "_dissolve", difficulty, FloatPointDefinition::new);
        this.dissolveArrow = this.getPointDefinition(json, "_dissolveArrow", difficulty, FloatPointDefinition::new);
        this.interactable = this.getPointDefinition(json, "_interactable", difficulty, FloatPointDefinition::new);
        this.time = this.getPointDefinition(json, "_time", difficulty, FloatPointDefinition::new);
        this.color = this.getPointDefinition(json, "_color", difficulty, Vector4PointDefinition::new);
        return this;
    }

    @Override
    public Animation loadV3(JsonObject json, Difficulty difficulty) {
        this.offsetPosition = this.getPointDefinition(json, "offsetPosition", difficulty, Vector3PointDefinition::new);
        this.offsetWorldRotation = this.getPointDefinition(json, "offsetWorldRotation", difficulty, QuaternionPointDefinition::new);
        this.localRotation = this.getPointDefinition(json, "localRotation", difficulty, QuaternionPointDefinition::new);
        this.localPosition = this.getPointDefinition(json, "localPosition", difficulty, Vector3PointDefinition::new);
        this.definitePosition = this.getPointDefinition(json, "definitePosition", difficulty, Vector3PointDefinition::new);
        this.position = this.getPointDefinition(json, "position", difficulty, Vector3PointDefinition::new);
        this.rotation = this.getPointDefinition(json, "rotation", difficulty, QuaternionPointDefinition::new);
        this.scale = this.getPointDefinition(json, "scale", difficulty, Vector3PointDefinition::new);
        this.dissolve = this.getPointDefinition(json, "dissolve", difficulty, FloatPointDefinition::new);
        this.dissolveArrow = this.getPointDefinition(json, "dissolveArrow", difficulty, FloatPointDefinition::new);
        this.interactable = this.getPointDefinition(json, "interactable", difficulty, FloatPointDefinition::new);
        this.time = this.getPointDefinition(json, "time", difficulty, FloatPointDefinition::new);
        this.color = this.getPointDefinition(json, "color", difficulty, Vector4PointDefinition::new);
        return this;
    }

    private <T> T getPointDefinition(JsonObject json, String property, Difficulty difficulty, Function<JsonArray, T> factory) {
        if (!json.has(property)) {
            return null;
        }
        JsonElement element = json.get(property);
        if (class_3518.method_15286((JsonElement)element)) {
            String name = element.getAsString();
            if (difficulty.pointDefinitions.containsKey(name)) {
                return factory.apply(difficulty.pointDefinitions.get(name));
            }
            BeatCraft.LOGGER.warn("Point Definition [" + name + "] does not exist! Skipping...");
            return null;
        }
        return factory.apply(element.getAsJsonArray());
    }

    public AnimatedPropertyEventContainer toAnimatedPropertyEvents(AnimateTrack animateTrack) {
        return new AnimatedPropertyEventContainer(this, animateTrack);
    }

    public AnimatedPathEventContainer toAnimatedPathEvents(AssignPathAnimation assignPathAnimation) {
        return new AnimatedPathEventContainer(this, assignPathAnimation);
    }

    public AnimationState toState(float time) {
        return AnimationState.fromAnimation(this, time);
    }
}

