/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.animation;

import com.beatcraft.animation.Animation;
import com.beatcraft.animation.AnimationPropertyContainer;
import com.beatcraft.animation.event.AnimatedPropertyEventHandler;
import com.beatcraft.animation.pointdefinition.PointDefinition;
import com.beatcraft.animation.track.AnimatedProperties;
import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

@Environment(value=EnvType.CLIENT)
public class AnimationState
extends AnimationPropertyContainer<Float, Vector3f, Vector4f, Quaternionf> {
    public void seekFromProperties(float beat, AnimatedProperties properties) {
        this.offsetPosition = ((AnimatedPropertyEventHandler)properties.offsetPosition).seek(beat);
        this.offsetWorldRotation = ((AnimatedPropertyEventHandler)properties.offsetWorldRotation).seek(beat);
        this.localRotation = ((AnimatedPropertyEventHandler)properties.localRotation).seek(beat);
        this.localPosition = ((AnimatedPropertyEventHandler)properties.localPosition).seek(beat);
        this.definitePosition = ((AnimatedPropertyEventHandler)properties.definitePosition).seek(beat);
        this.position = ((AnimatedPropertyEventHandler)properties.position).seek(beat);
        this.rotation = ((AnimatedPropertyEventHandler)properties.rotation).seek(beat);
        this.scale = ((AnimatedPropertyEventHandler)properties.scale).seek(beat);
        this.dissolve = ((AnimatedPropertyEventHandler)properties.dissolve).seek(beat);
        this.dissolveArrow = ((AnimatedPropertyEventHandler)properties.dissolveArrow).seek(beat);
        this.interactable = ((AnimatedPropertyEventHandler)properties.interactable).seek(beat);
        this.time = ((AnimatedPropertyEventHandler)properties.time).seek(beat);
        this.color = ((AnimatedPropertyEventHandler)properties.color).seek(beat);
    }

    public void updateFromProperties(float beat, AnimatedProperties properties) {
        this.offsetPosition = ((AnimatedPropertyEventHandler)properties.offsetPosition).update(beat);
        this.offsetWorldRotation = ((AnimatedPropertyEventHandler)properties.offsetWorldRotation).update(beat);
        this.localRotation = ((AnimatedPropertyEventHandler)properties.localRotation).update(beat);
        this.localPosition = ((AnimatedPropertyEventHandler)properties.localPosition).update(beat);
        this.definitePosition = ((AnimatedPropertyEventHandler)properties.definitePosition).update(beat);
        this.position = ((AnimatedPropertyEventHandler)properties.position).update(beat);
        this.rotation = ((AnimatedPropertyEventHandler)properties.rotation).update(beat);
        this.scale = ((AnimatedPropertyEventHandler)properties.scale).update(beat);
        this.dissolve = ((AnimatedPropertyEventHandler)properties.dissolve).update(beat);
        this.dissolveArrow = ((AnimatedPropertyEventHandler)properties.dissolveArrow).update(beat);
        this.interactable = ((AnimatedPropertyEventHandler)properties.interactable).update(beat);
        this.time = ((AnimatedPropertyEventHandler)properties.time).update(beat);
        this.color = ((AnimatedPropertyEventHandler)properties.color).update(beat);
    }

    private static <T> T interpolateProperty(PointDefinition<T> pointDefinition, float time) {
        if (pointDefinition == null) {
            return null;
        }
        return pointDefinition.interpolate(time);
    }

    public static AnimationState fromAnimation(Animation animation, float normalTime) {
        AnimationState state = new AnimationState();
        state.offsetPosition = AnimationState.interpolateProperty((PointDefinition)animation.offsetPosition, normalTime);
        state.offsetWorldRotation = AnimationState.interpolateProperty((PointDefinition)animation.offsetWorldRotation, normalTime);
        state.localRotation = AnimationState.interpolateProperty((PointDefinition)animation.localRotation, normalTime);
        state.localPosition = AnimationState.interpolateProperty((PointDefinition)animation.localPosition, normalTime);
        state.definitePosition = AnimationState.interpolateProperty((PointDefinition)animation.definitePosition, normalTime);
        state.position = AnimationState.interpolateProperty((PointDefinition)animation.position, normalTime);
        state.rotation = AnimationState.interpolateProperty((PointDefinition)animation.rotation, normalTime);
        state.scale = AnimationState.interpolateProperty((PointDefinition)animation.scale, normalTime);
        state.dissolve = AnimationState.interpolateProperty((PointDefinition)animation.dissolve, normalTime);
        state.dissolveArrow = AnimationState.interpolateProperty((PointDefinition)animation.dissolveArrow, normalTime);
        state.interactable = AnimationState.interpolateProperty((PointDefinition)animation.interactable, normalTime);
        state.time = AnimationState.interpolateProperty((PointDefinition)animation.time, normalTime);
        state.color = AnimationState.interpolateProperty((PointDefinition)animation.color, normalTime);
        return state;
    }

    public static AnimationState combine(AnimationState a, AnimationState b) {
        AnimationState state = new AnimationState();
        state.offsetPosition = AnimationState.combineProperties((Vector3f)a.getOffsetPosition(), (Vector3f)b.getOffsetPosition(), AnimationState::add);
        state.offsetWorldRotation = AnimationState.combineProperties((Quaternionf)a.getOffsetWorldRotation(), (Quaternionf)b.getOffsetWorldRotation(), AnimationState::combineRotations);
        state.localRotation = AnimationState.combineProperties((Quaternionf)a.getLocalRotation(), (Quaternionf)b.getLocalRotation(), AnimationState::combineRotations);
        state.localPosition = AnimationState.combineProperties((Vector3f)a.getLocalPosition(), (Vector3f)b.getLocalPosition(), AnimationState::add);
        state.definitePosition = AnimationState.combineProperties((Vector3f)a.getDefinitePosition(), (Vector3f)b.getDefinitePosition(), AnimationState::add);
        state.position = AnimationState.combineProperties((Vector3f)a.getPosition(), (Vector3f)b.getPosition(), AnimationState::add);
        state.rotation = AnimationState.combineProperties((Quaternionf)a.getRotation(), (Quaternionf)b.getRotation(), AnimationState::combineRotations);
        state.scale = AnimationState.combineProperties((Vector3f)a.getScale(), (Vector3f)b.getScale(), AnimationState::multiply);
        state.dissolve = AnimationState.combineProperties((Float)a.getDissolve(), (Float)b.getDissolve(), AnimationState::multiply);
        state.dissolveArrow = AnimationState.combineProperties((Float)a.getDissolveArrow(), (Float)b.getDissolveArrow(), AnimationState::multiply);
        state.interactable = AnimationState.combineProperties((Float)a.getInteractable(), (Float)b.getInteractable(), AnimationState::multiply);
        state.time = AnimationState.combineProperties((Float)a.getTime(), (Float)b.getTime(), AnimationState::multiply);
        state.color = AnimationState.combineProperties((Vector4f)a.getColor(), (Vector4f)b.getColor(), AnimationState::multiply);
        return state;
    }

    private static float multiply(float a, float b) {
        return a * b;
    }

    private static Vector4f multiply(Vector4f a, Vector4f b) {
        return new Vector4f((Vector4fc)a).mul((Vector4fc)b);
    }

    private static Vector3f multiply(Vector3f a, Vector3f b) {
        return new Vector3f((Vector3fc)a).mul((Vector3fc)b);
    }

    private static Vector3f add(Vector3f a, Vector3f b) {
        return new Vector3f((Vector3fc)a).add((Vector3fc)b);
    }

    private static Quaternionf combineRotations(Quaternionf a, Quaternionf b) {
        return new Quaternionf((Quaternionfc)a).mul((Quaternionfc)b);
    }

    private static <T> T combineProperties(T a, T b, BiFunction<T, T, T> operation) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return operation.apply(a, b);
    }
}

