/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.animation;

import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class Easing {
    public static Function<Float, Float> getEasing(String easing) {
        return switch (easing) {
            case "easeStep" -> Easing::easeStep;
            case "easeOutQuad" -> Easing::easeOutQuad;
            case "easeInQuad" -> Easing::easeInQuad;
            case "easeInOutQuad" -> Easing::easeInOutQuad;
            case "easeInCubic" -> Easing::easeInCubic;
            case "easeOutCubic" -> Easing::easeOutCubic;
            case "easeInOutCubic" -> Easing::easeInOutCubic;
            case "easeInQuart" -> Easing::easeInQuart;
            case "easeOutQuart" -> Easing::easeOutQuart;
            case "easeInOutQuart" -> Easing::easeInOutQuart;
            case "easeInQuint" -> Easing::easeInQuint;
            case "easeOutQuint" -> Easing::easeOutQuint;
            case "easeInOutQuint" -> Easing::easeInOutQuint;
            case "easeInSine" -> Easing::easeInSine;
            case "easeOutSine" -> Easing::easeOutSine;
            case "easeInOutSine" -> Easing::easeInOutSine;
            case "easeInCirc" -> Easing::easeInCirc;
            case "easeOutCirc" -> Easing::easeOutCirc;
            case "easeInOutCirc" -> Easing::easeInOutCirc;
            case "easeInExpo" -> Easing::easeInExpo;
            case "easeOutExpo" -> Easing::easeOutExpo;
            case "easeInOutExpo" -> Easing::easeInOutExpo;
            case "easeInElastic" -> Easing::easeInElastic;
            case "easeOutElastic" -> Easing::easeOutElastic;
            case "easeInOutElastic" -> Easing::easeInOutElastic;
            case "easeInBack" -> Easing::easeInBack;
            case "easeOutBack" -> Easing::easeOutBack;
            case "easeInOutBack" -> Easing::easeInOutBack;
            case "easeInBounce" -> Easing::easeInBounce;
            case "easeOutBounce" -> Easing::easeOutBounce;
            case "easeInOutBounce" -> Easing::easeInOutBounce;
            default -> Easing::easeLinear;
        };
    }

    public static float easeStep(float x) {
        return x >= 1.0f ? 1.0f : 0.0f;
    }

    public static float easeLinear(float x) {
        return x;
    }

    public static float easeInSine(float x) {
        return 1.0f - (float)Math.cos(x * (float)Math.PI / 2.0f);
    }

    public static float easeOutSine(float x) {
        return (float)Math.sin(x * (float)Math.PI / 2.0f);
    }

    public static float easeInOutSine(float x) {
        return -((float)Math.cos((float)Math.PI * x) - 1.0f) / 2.0f;
    }

    public static float easeInQuad(float x) {
        return x * x;
    }

    public static float easeOutQuad(float x) {
        return 1.0f - (1.0f - x) * (1.0f - x);
    }

    public static float easeInOutQuad(float x) {
        return (double)x < 0.5 ? 2.0f * x * x : 1.0f - (float)Math.pow(-2.0f * x + 2.0f, 2.0) / 2.0f;
    }

    public static float easeInCubic(float x) {
        return x * x * x;
    }

    public static float easeOutCubic(float x) {
        return 1.0f - (float)Math.pow(1.0f - x, 3.0);
    }

    public static float easeInOutCubic(float x) {
        return (double)x < 0.5 ? 4.0f * x * x * x : 1.0f - (float)Math.pow(-2.0f * x + 2.0f, 3.0) / 2.0f;
    }

    public static float easeInQuart(float x) {
        return x * x * x * x;
    }

    public static float easeOutQuart(float x) {
        return 1.0f - (float)Math.pow(1.0f - x, 4.0);
    }

    public static float easeInOutQuart(float x) {
        return (double)x < 0.5 ? 8.0f * x * x * x * x : 1.0f - (float)Math.pow(-2.0f * x + 2.0f, 4.0) / 2.0f;
    }

    public static float easeInQuint(float x) {
        return x * x * x * x * x;
    }

    public static float easeOutQuint(float x) {
        return 1.0f - (float)Math.pow(1.0f - x, 5.0);
    }

    public static float easeInOutQuint(float x) {
        return (double)x < 0.5 ? 16.0f * x * x * x * x * x : 1.0f - (float)Math.pow(-2.0f * x + 2.0f, 5.0) / 2.0f;
    }

    public static float easeInExpo(float x) {
        return x == 0.0f ? 0.0f : (float)Math.pow(2.0, 10.0f * x - 10.0f);
    }

    public static float easeOutExpo(float x) {
        return x == 1.0f ? 1.0f : 1.0f - (float)Math.pow(2.0, -10.0f * x);
    }

    public static float easeInOutExpo(float x) {
        return x == 0.0f ? 0.0f : (x == 1.0f ? 1.0f : ((double)x < 0.5 ? (float)Math.pow(2.0, 20.0f * x - 10.0f) / 2.0f : (2.0f - (float)Math.pow(2.0, -20.0f * x + 10.0f)) / 2.0f));
    }

    public static float easeInCirc(float x) {
        return 1.0f - (float)Math.sqrt(1.0f - (float)Math.pow(x, 2.0));
    }

    public static float easeOutCirc(float x) {
        return (float)Math.sqrt(1.0f - (float)Math.pow(x - 1.0f, 2.0));
    }

    public static float easeInOutCirc(float x) {
        return (double)x < 0.5 ? (1.0f - (float)Math.sqrt(1.0f - (float)Math.pow(2.0f * x, 2.0))) / 2.0f : ((float)Math.sqrt(1.0f - (float)Math.pow(-2.0f * x + 2.0f, 2.0)) + 1.0f) / 2.0f;
    }

    public static float easeInBack(float x) {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return c3 * x * x * x - c1 * x * x;
    }

    public static float easeOutBack(float x) {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return 1.0f + c3 * (float)Math.pow(x - 1.0f, 3.0) + c1 * (float)Math.pow(x - 1.0f, 2.0);
    }

    public static float easeInOutBack(float x) {
        float c1 = 1.70158f;
        float c2 = c1 * 1.525f;
        return (double)x < 0.5 ? (float)Math.pow(2.0f * x, 2.0) * ((c2 + 1.0f) * 2.0f * x - c2) / 2.0f : ((float)Math.pow(2.0f * x - 2.0f, 2.0) * ((c2 + 1.0f) * (x * 2.0f - 2.0f) + c2) + 2.0f) / 2.0f;
    }

    public static float easeInElastic(float x) {
        float c4 = 2.0943952f;
        return x == 0.0f ? 0.0f : (x == 1.0f ? 1.0f : -((float)Math.pow(2.0, 10.0f * x - 10.0f)) * (float)Math.sin(((double)(x * 10.0f) - 10.75) * (double)c4));
    }

    public static float easeOutElastic(float x) {
        float c4 = 2.0943952f;
        return x == 0.0f ? 0.0f : (x == 1.0f ? 1.0f : (float)Math.pow(2.0, -10.0f * x) * (float)Math.sin(((double)(x * 10.0f) - 0.75) * (double)c4) + 1.0f);
    }

    public static float easeInOutElastic(float x) {
        float c5 = 1.3962635f;
        float s = (float)Math.sin(((double)(20.0f * x) - 11.125) * (double)c5);
        return x == 0.0f ? 0.0f : (x == 1.0f ? 1.0f : ((double)x < 0.5 ? -((float)Math.pow(2.0, 20.0f * x - 10.0f) * s) / 2.0f : (float)Math.pow(2.0, -20.0f * x + 10.0f) * s / 2.0f + 1.0f));
    }

    public static float easeInBounce(float x) {
        return 1.0f - Easing.easeOutBounce(1.0f - x);
    }

    public static float easeOutBounce(float x) {
        float n1 = 7.5625f;
        float d1 = 2.75f;
        if (x < 1.0f / d1) {
            return n1 * x * x;
        }
        if (x < 2.0f / d1) {
            x = (float)((double)x - 1.5 / (double)d1);
            return n1 * x * x + 0.75f;
        }
        if ((double)x < 2.5 / (double)d1) {
            x = (float)((double)x - 2.25 / (double)d1);
            return n1 * x * x + 0.9375f;
        }
        x = (float)((double)x - 2.625 / (double)d1);
        return n1 * x * x + 0.984375f;
    }

    public static float easeInOutBounce(float x) {
        return (double)x < 0.5 ? (1.0f - Easing.easeOutBounce(1.0f - 2.0f * x)) / 2.0f : (1.0f + Easing.easeOutBounce(2.0f * x - 1.0f)) / 2.0f;
    }
}

