/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.animation.event;

import com.beatcraft.animation.pointdefinition.PointDefinition;
import com.beatcraft.beatmap.data.event.AssignPathAnimation;
import com.beatcraft.event.IEvent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class AnimatedPathEvent<T>
implements IEvent {
    private final PointDefinition<T> property;
    private final AssignPathAnimation origin;

    public AnimatedPathEvent(PointDefinition<T> property, AssignPathAnimation origin) {
        this.property = property;
        this.origin = origin;
    }

    private boolean hasEasing() {
        return this.origin.getEasing() != null;
    }

    @Override
    public float getEventBeat() {
        return this.origin.getBeat();
    }

    @Override
    public float getEventDuration() {
        return this.origin.getDuration();
    }

    public float applyEasing(float normalTime) {
        if (this.hasEasing()) {
            return this.origin.getEasing().apply(Float.valueOf(normalTime)).floatValue();
        }
        return normalTime;
    }

    public PointDefinition<T> getProperty() {
        return this.property;
    }
}

