/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.animation.track;

import com.beatcraft.animation.AnimationState;
import com.beatcraft.animation.event.AnimatedPathEventContainer;
import com.beatcraft.animation.event.AnimatedPropertyEventContainer;
import com.beatcraft.animation.track.AnimatedPath;
import com.beatcraft.animation.track.AnimatedProperties;
import com.beatcraft.animation.track.TrackLibrary;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class Track {
    private final AnimatedProperties animatedProperties = new AnimatedProperties();
    private final AnimatedPath animatedPath = new AnimatedPath();
    private Track parent;

    public AnimatedProperties getAnimatedProperties() {
        return this.animatedProperties;
    }

    public AnimatedPath getAnimatedPath() {
        return this.animatedPath;
    }

    public static ArrayList<Track> getTracksAsList(JsonElement trackElement, TrackLibrary trackLibrary) {
        ArrayList<Track> tracks = new ArrayList<Track>();
        if (trackElement.isJsonArray()) {
            trackElement.getAsJsonArray().forEach(x -> Track.addTrackToList(x, trackLibrary, tracks));
        } else {
            Track.addTrackToList(trackElement, trackLibrary, tracks);
        }
        return tracks;
    }

    private static void addTrackToList(JsonElement nameElement, TrackLibrary trackLibrary, ArrayList<Track> tracks) {
        String name = nameElement.getAsString();
        Track track = trackLibrary.getOrCreateTrack(name);
        tracks.add(track);
    }

    public void loadAnimatedPropertyEvents(AnimatedPropertyEventContainer eventContainer) {
        this.animatedProperties.loadAnimatedPropertyEvents(eventContainer);
    }

    public void loadAnimatedPathEvents(AnimatedPathEventContainer eventContainer) {
        this.animatedPath.loadAnimatedPropertyEvents(eventContainer);
    }

    public void setParent(Track parent) {
        this.parent = parent;
    }

    public Track getParent() {
        return this.parent;
    }

    public boolean isParented() {
        return this.parent != null;
    }

    public void unparent() {
        this.parent = null;
    }

    public Matrix4f tryGetParentMatrix() {
        if (this.isParented()) {
            Vector3f scale;
            Quaternionf localRotation;
            Quaternionf rotation;
            Vector3f position;
            Matrix4f parentParentMatrix;
            AnimationState animationState = this.parent.getAnimatedProperties().getCurrentState();
            Matrix4f parentMatrix = new Matrix4f();
            if (this.parent.isParented() && (parentParentMatrix = this.parent.tryGetParentMatrix()) != null) {
                parentMatrix.mul((Matrix4fc)parentParentMatrix);
            }
            if ((position = (Vector3f)animationState.getPosition()) != null) {
                parentMatrix.translate((Vector3fc)position);
            }
            if ((rotation = (Quaternionf)animationState.getRotation()) != null) {
                parentMatrix.rotate((Quaternionfc)rotation);
            }
            if ((localRotation = (Quaternionf)animationState.getLocalRotation()) != null) {
                parentMatrix.rotate((Quaternionfc)localRotation);
            }
            if ((scale = (Vector3f)animationState.getScale()) != null) {
                parentMatrix.scale((Vector3fc)scale);
            }
            return parentMatrix;
        }
        return null;
    }
}

