/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.audio;

import com.beatcraft.BeatmapPlayer;
import com.beatcraft.audio.BeatmapAudio;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_3419;

@Environment(value=EnvType.CLIENT)
public class BeatmapAudioPlayer {
    private static class_310 mc;
    private static double currentMusicVolume;
    public static BeatmapAudio beatmapAudio;
    public static CompletableFuture<Void> loadRequest;

    public static void init() {
        mc = class_310.method_1551();
        beatmapAudio = new BeatmapAudio();
    }

    public static void muteVanillaMusic() {
        currentMusicVolume = BeatmapAudioPlayer.mc.field_1690.method_1630(class_3419.field_15253);
        BeatmapAudioPlayer.mc.field_1690.method_45578(class_3419.field_15253).method_41748((Object)0.0);
    }

    public static void unmuteVanillaMusic() {
        BeatmapAudioPlayer.mc.field_1690.method_45578(class_3419.field_15253).method_41748((Object)currentMusicVolume);
    }

    public static void playAudioFromFile(String path) {
        BeatmapAudioPlayer.unload();
        loadRequest = CompletableFuture.runAsync(() -> {
            try {
                beatmapAudio.loadAudioFromFile(path);
                beatmapAudio.seek(0.0f);
                beatmapAudio.play();
            }
            catch (IOException e) {
                throw new RuntimeException("Something FUCKED happened.", e);
            }
        });
    }

    private static void cancelLoad() {
        if (loadRequest != null) {
            loadRequest.cancel(true);
        }
    }

    public static void onFrame() {
        if (!beatmapAudio.isLoaded()) {
            return;
        }
        if (mc.method_1493() || !BeatmapPlayer.isPlaying()) {
            beatmapAudio.pause();
        } else if (!beatmapAudio.isPlaying()) {
            BeatmapAudioPlayer.syncTimeWithBeatmap();
            beatmapAudio.play();
        }
    }

    public static void goToBeat(float beat) {
        float time = BeatmapPlayer.currentInfo.getTime(beat, 1.0f);
        beatmapAudio.seek(time);
    }

    public static void goToSecond(float second) {
        beatmapAudio.seek(second);
    }

    public static void syncTimeWithBeatmap() {
        BeatmapAudioPlayer.goToSecond(BeatmapPlayer.getCurrentSeconds());
    }

    public static boolean isReady() {
        if (loadRequest == null) {
            return false;
        }
        return loadRequest.isDone() && !loadRequest.isCompletedExceptionally();
    }

    public static void unload() {
        BeatmapAudioPlayer.cancelLoad();
        beatmapAudio.closeBuffer();
    }

    static {
        currentMusicVolume = 1.0;
        beatmapAudio = null;
        loadRequest = null;
    }
}

