/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.beatmap.data.event;

import com.beatcraft.animation.Animation;
import com.beatcraft.animation.Easing;
import com.beatcraft.animation.event.AnimatedPropertyEventContainer;
import com.beatcraft.animation.track.Track;
import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.beatmap.data.object.BeatmapObject;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3518;

@Environment(value=EnvType.CLIENT)
public class AnimateTrack
extends BeatmapObject {
    private ArrayList<Track> tracks;
    private float duration;
    private Function<Float, Float> easing;
    private Integer repeat;
    private final Animation animation = new Animation();

    @Override
    public AnimateTrack loadV2(JsonObject json, Difficulty difficulty) {
        super.loadV2(json, difficulty);
        JsonObject data = json.getAsJsonObject("_data");
        this.duration = class_3518.method_15277((JsonObject)data, (String)"_duration", (float)0.0f);
        if (data.has("_easing")) {
            this.easing = Easing.getEasing(data.get("_easing").getAsString());
        }
        JsonElement trackElement = data.get("_track");
        this.tracks = Track.getTracksAsList(trackElement, difficulty.getTrackLibrary());
        this.animation.loadV2(data, difficulty);
        return this;
    }

    @Override
    public AnimateTrack loadV3(JsonObject json, Difficulty difficulty) {
        super.loadV3(json, difficulty);
        JsonObject data = json.getAsJsonObject("d");
        this.duration = class_3518.method_15277((JsonObject)data, (String)"duration", (float)0.0f);
        if (data.has("repeat")) {
            this.repeat = data.get("repeat").getAsInt();
        }
        if (data.has("easing")) {
            this.easing = Easing.getEasing(data.get("easing").getAsString());
        }
        JsonElement trackElement = data.get("track");
        this.tracks = Track.getTracksAsList(trackElement, difficulty.getTrackLibrary());
        this.animation.loadV3(data, difficulty);
        return this;
    }

    public float getDuration() {
        return this.duration;
    }

    public float getRepeatedDuration() {
        return this.repeat != null ? this.duration * (float)this.repeat.intValue() : this.duration;
    }

    public Function<Float, Float> getEasing() {
        return this.easing;
    }

    public Integer getRepeat() {
        return this.repeat;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public ArrayList<Track> getTracks() {
        return this.tracks;
    }

    public AnimatedPropertyEventContainer toAnimatedPropertyEvents() {
        return this.animation.toAnimatedPropertyEvents(this);
    }
}

