/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.beatmap.data.event;

import com.beatcraft.animation.track.Track;
import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.beatmap.data.object.BeatmapObject;
import com.beatcraft.event.IEvent;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3518;

@Environment(value=EnvType.CLIENT)
public class AssignTrackParent
extends BeatmapObject
implements IEvent {
    protected ArrayList<Track> childrenTracks;
    protected Track parentTrack;
    protected boolean worldPositionStays;

    @Override
    public AssignTrackParent loadV2(JsonObject json, Difficulty difficulty) {
        super.loadV2(json, difficulty);
        JsonObject data = json.getAsJsonObject("_data");
        JsonElement childrenTracksElement = data.get("_childrenTracks");
        this.childrenTracks = Track.getTracksAsList(childrenTracksElement, difficulty.getTrackLibrary());
        this.parentTrack = difficulty.getTrackLibrary().getOrCreateTrack(data.get("_parentTrack").getAsString());
        this.worldPositionStays = class_3518.method_15258((JsonObject)data, (String)"_worldPositionStays", (boolean)false);
        return this;
    }

    @Override
    public AssignTrackParent loadV3(JsonObject json, Difficulty difficulty) {
        super.loadV3(json, difficulty);
        JsonObject data = json.getAsJsonObject("d");
        JsonElement childrenTracksElement = data.get("childrenTracks");
        this.childrenTracks = Track.getTracksAsList(childrenTracksElement, difficulty.getTrackLibrary());
        this.parentTrack = difficulty.getTrackLibrary().getOrCreateTrack(data.get("parentTrack").getAsString());
        this.worldPositionStays = class_3518.method_15258((JsonObject)data, (String)"worldPositionStays", (boolean)false);
        return this;
    }

    public ArrayList<Track> getChildrenTracks() {
        return this.childrenTracks;
    }

    public Track getParentTrack() {
        return this.parentTrack;
    }

    public boolean doesWorldPositionStay() {
        return this.worldPositionStays;
    }

    @Override
    public float getEventBeat() {
        return this.beat;
    }

    @Override
    public float getEventDuration() {
        return 0.0f;
    }
}

