/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.beatmap.data.event;

import com.beatcraft.animation.track.Track;
import com.beatcraft.animation.track.TrackLibrary;
import com.beatcraft.beatmap.data.event.AssignTrackParent;
import com.beatcraft.event.VoidEventHandler;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class AssignTrackParentHandler
extends VoidEventHandler<AssignTrackParent> {
    private final TrackLibrary trackLibrary;

    @Override
    public void reset() {
        super.reset();
        if (this.trackLibrary != null) {
            this.trackLibrary.getTracks().forEach(Track::unparent);
        }
    }

    public AssignTrackParentHandler(ArrayList<AssignTrackParent> events, TrackLibrary trackLibrary) {
        super(events);
        this.trackLibrary = trackLibrary;
    }

    @Override
    public void onEventInterrupted(AssignTrackParent event, float normalTime) {
    }

    @Override
    public void onInsideEvent(AssignTrackParent event, float normalTime) {
    }

    @Override
    public void onEventPassed(AssignTrackParent event) {
        Track parent = event.getParentTrack();
        event.childrenTracks.forEach(child -> child.setParent(parent));
    }
}

