/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.beatmap.data.object;

import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.beatmap.Info;
import com.beatcraft.beatmap.data.CutDirection;
import com.beatcraft.beatmap.data.NoteType;
import com.beatcraft.beatmap.data.object.ChainNoteLink;
import com.beatcraft.beatmap.data.object.GameplayObject;
import com.beatcraft.beatmap.data.object.ScorableObject;
import com.beatcraft.data.types.BezierCurve;
import com.beatcraft.data.types.Color;
import com.beatcraft.utils.JsonUtil;
import com.beatcraft.utils.MathUtil;
import com.beatcraft.utils.NoteMath;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3545;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class ChainNoteHead
extends GameplayObject
implements ScorableObject {
    private float angleOffset = 0.0f;
    private CutDirection cutDirection;
    private NoteType noteType;
    private Color color;
    private boolean disableNoteLook = false;
    private boolean disableNoteGravity = false;

    private void applyColorScheme(Info.SetDifficulty setDifficulty) {
        this.color = this.noteType == NoteType.RED ? setDifficulty.getColorScheme().getNoteLeftColor() : setDifficulty.getColorScheme().getNoteRightColor();
    }

    public static class_3545<ChainNoteHead, List<ChainNoteLink>> buildV3(JsonObject json, Difficulty difficulty) {
        ChainNoteHead headNote = new ChainNoteHead();
        headNote.loadV3(json, difficulty);
        headNote.cutDirection = CutDirection.values()[json.get("d").getAsInt()];
        headNote.noteType = NoteType.values()[JsonUtil.getOrDefault(json, "c", JsonElement::getAsInt, Integer.valueOf(0))];
        headNote.applyColorScheme(difficulty.getSetDifficulty());
        float tailBeat = json.get("tb").getAsFloat();
        float tailX = JsonUtil.getOrDefault(json, "tx", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        float tailY = JsonUtil.getOrDefault(json, "ty", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        int sliceCount = json.get("sc").getAsInt();
        float squishFactor = JsonUtil.getOrDefault(json, "s", JsonElement::getAsFloat, Float.valueOf(1.0f)).floatValue();
        List<class_3545<Vector3f, Float>> linkPositions = ChainNoteHead.evaluateSpline(new Vector2f(headNote.getX(), headNote.getY()), headNote.getBeat(), headNote.cutDirection, new Vector2f(tailX, tailY), tailBeat, sliceCount, squishFactor);
        return new class_3545((Object)headNote, ChainNoteHead.generateChainLinks(linkPositions, chainNoteLink -> {
            chainNoteLink.loadV3(json, difficulty);
            return null;
        }));
    }

    public static class_3545<ChainNoteHead, List<ChainNoteLink>> buildV4(JsonObject json, JsonArray colorNotesData, JsonArray chainsData, Difficulty difficulty) {
        ChainNoteHead headNote = new ChainNoteHead();
        headNote.loadV4(json, colorNotesData, difficulty);
        headNote.beat = JsonUtil.getOrDefault(json, "hb", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        int headMetaIndex = JsonUtil.getOrDefault(json, "i", JsonElement::getAsInt, Integer.valueOf(0));
        int chainMetaIndex = JsonUtil.getOrDefault(json, "ci", JsonElement::getAsInt, Integer.valueOf(0));
        JsonObject headMetaData = colorNotesData.get(headMetaIndex).getAsJsonObject();
        JsonObject chainMetaData = chainsData.get(chainMetaIndex).getAsJsonObject();
        headNote.cutDirection = CutDirection.values()[JsonUtil.getOrDefault(headMetaData, "d", JsonElement::getAsInt, Integer.valueOf(0))];
        headNote.noteType = NoteType.values()[JsonUtil.getOrDefault(headMetaData, "c", JsonElement::getAsInt, Integer.valueOf(0))];
        headNote.applyColorScheme(difficulty.getSetDifficulty());
        float tailX = JsonUtil.getOrDefault(chainMetaData, "tx", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        float tailY = JsonUtil.getOrDefault(chainMetaData, "ty", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        float tailBeat = json.get("tb").getAsFloat();
        int sliceCount = chainMetaData.get("c").getAsInt();
        float squishFactor = JsonUtil.getOrDefault(chainMetaData, "s", JsonElement::getAsFloat, Float.valueOf(1.0f)).floatValue();
        List<class_3545<Vector3f, Float>> linkPositions = ChainNoteHead.evaluateSpline(new Vector2f(headNote.getX(), headNote.getY()), headNote.getBeat(), headNote.cutDirection, new Vector2f(tailX, tailY), tailBeat, sliceCount, squishFactor);
        return new class_3545((Object)headNote, ChainNoteHead.generateChainLinks(linkPositions, chainNoteLink -> {
            chainNoteLink.loadV4(json, chainsData, headNote.noteType, difficulty);
            return null;
        }));
    }

    private static List<class_3545<Vector3f, Float>> evaluateSpline(Vector2f headPosition, float headBeat, CutDirection headDirection, Vector2f tailPosition, float tailBeat, int sliceCount, float squishFactor) {
        if (sliceCount == 0) {
            return List.of();
        }
        Vector3f headPos = new Vector3f(headPosition.x, headPosition.y, 0.0f);
        Vector3f tailOffset = new Vector3f(tailPosition.x, tailPosition.y, 0.0f).sub((Vector3fc)headPos);
        float magnitude = tailOffset.length();
        float f = (NoteMath.degreesFromCut(headDirection) - 90.0f) * ((float)Math.PI / 180);
        Vector3f control = new Vector3f((float)Math.cos(f) * 0.5f * magnitude, (float)Math.sin(f) * 0.5f * magnitude, 0.0f);
        BezierCurve spline = new BezierCurve(new Vector3f(0.0f, 0.0f, 0.0f), control, tailOffset);
        float gap = squishFactor / (float)sliceCount;
        ArrayList<class_3545<Vector3f, Float>> placements = new ArrayList<class_3545<Vector3f, Float>>();
        float beatSpan = tailBeat - headBeat;
        for (int i = 1; i <= sliceCount; ++i) {
            Vector3f pos = spline.evaluate(gap * (float)i).add((Vector3fc)headPos);
            Vector3f tangent = spline.getTangent(gap * (float)i);
            float angleDegrees = MathUtil.getVectorAngleDegrees(new Vector2f(tangent.x, tangent.y)) - 90.0f;
            placements.add((class_3545<Vector3f, Float>)new class_3545((Object)new Vector3f(pos.x, pos.y, headBeat + beatSpan * (gap * (float)i)), (Object)Float.valueOf(angleDegrees)));
        }
        return placements;
    }

    private static List<ChainNoteLink> generateChainLinks(List<class_3545<Vector3f, Float>> positions, Function<ChainNoteLink, Void> loader) {
        ArrayList<ChainNoteLink> chainLinks = new ArrayList<ChainNoteLink>();
        for (class_3545<Vector3f, Float> pair : positions) {
            Vector3f pos = (Vector3f)pair.method_15442();
            float angle = ((Float)pair.method_15441()).floatValue();
            ChainNoteLink chainLink = new ChainNoteLink();
            loader.apply(chainLink);
            chainLink.setAngleOffset(angle);
            chainLink.setPos(pos);
            chainLinks.add(chainLink);
        }
        return chainLinks;
    }

    public float getAngleOffset() {
        return this.angleOffset;
    }

    public CutDirection getCutDirection() {
        return this.cutDirection;
    }

    public NoteType getNoteType() {
        return this.noteType;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isNoteLookDisabled() {
        return this.disableNoteLook;
    }

    public boolean isNoteGravityDisabled() {
        return this.disableNoteGravity;
    }

    @Override
    public NoteType score$getNoteType() {
        return this.getNoteType();
    }

    @Override
    public CutDirection score$getCutDirection() {
        return this.getCutDirection();
    }
}

