/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.beatmap.data.object;

import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.beatmap.data.object.GameplayObject;
import com.beatcraft.utils.JsonUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class Obstacle
extends GameplayObject {
    private float duration;
    private float width;
    private float height;
    private boolean noodleSizing = false;

    public void loadCustomObstacleDataV2(JsonObject json, Difficulty difficulty) {
        if (json.has("_customData")) {
            JsonArray size;
            JsonArray coordinates;
            JsonObject customData = json.getAsJsonObject("_customData");
            if (customData.has("_coordinates")) {
                coordinates = customData.getAsJsonArray("_coordinates");
                this.x = (float)coordinates.get(0).getAsInt() + 1.9f;
                this.y = coordinates.get(1).getAsInt();
            }
            if (customData.has("_position")) {
                coordinates = customData.getAsJsonArray("_position");
                this.x = coordinates.get(0).getAsFloat() + 1.9f;
                this.y = coordinates.get(1).getAsFloat();
            }
            if (customData.has("_scale") && !(size = customData.getAsJsonArray("_scale")).isEmpty()) {
                this.width = size.get(0).getAsFloat();
                if (size.size() >= 2) {
                    this.height = size.get(1).getAsFloat();
                    if (size.size() == 3) {
                        this.duration = size.get(2).getAsFloat();
                        this.noodleSizing = true;
                    }
                }
            }
        }
    }

    public void loadCustomObstacleDataV3(JsonObject json, Difficulty difficulty) {
        if (json.has("customData")) {
            JsonArray size;
            JsonArray coordinates;
            JsonObject customData = json.getAsJsonObject("customData");
            if (customData.has("coordinates")) {
                coordinates = customData.getAsJsonArray("coordinates");
                this.x = (float)coordinates.get(0).getAsInt() + 1.9f;
                this.y = coordinates.get(1).getAsInt();
            }
            if (customData.has("position")) {
                coordinates = customData.getAsJsonArray("position");
                this.x = coordinates.get(0).getAsFloat() + 1.9f;
                this.y = coordinates.get(1).getAsFloat();
            }
            if (customData.has("size") && !(size = customData.getAsJsonArray("size")).isEmpty()) {
                this.width = size.get(0).getAsFloat();
                if (size.size() >= 2) {
                    this.height = size.get(1).getAsFloat();
                    if (size.size() == 3) {
                        this.duration = size.get(2).getAsFloat();
                        this.noodleSizing = true;
                    }
                }
            }
        }
    }

    @Override
    public Obstacle loadV2(JsonObject json, Difficulty difficulty) {
        this.beat = json.get("_time").getAsFloat();
        this.offset = difficulty.getSetDifficulty().getOffset();
        this.njs = difficulty.getSetDifficulty().getNjs();
        this.duration = json.get("_duration").getAsFloat();
        this.x = json.get("_lineIndex").getAsInt();
        this.width = json.get("_width").getAsInt();
        int _type = json.get("_type").getAsInt();
        switch (_type) {
            case 0: {
                this.y = 0.0f;
                this.height = 5.0f;
                break;
            }
            case 1: {
                this.y = 2.0f;
                this.height = 3.0f;
                break;
            }
            case 2: {
                this.y = JsonUtil.getOrDefault(json, "_lineLayer", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
                this.height = JsonUtil.getOrDefault(json, "_height", JsonElement::getAsInt, Integer.valueOf(5)).intValue();
            }
        }
        this.loadCustomDataV2(json, difficulty);
        this.loadCustomObstacleDataV2(json, difficulty);
        this.loadJumps(difficulty.getInfo());
        return this;
    }

    @Override
    public Obstacle loadV3(JsonObject json, Difficulty difficulty) {
        this.beat = JsonUtil.getOrDefault(json, "b", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.offset = difficulty.getSetDifficulty().getOffset();
        this.njs = difficulty.getSetDifficulty().getNjs();
        this.duration = JsonUtil.getOrDefault(json, "d", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.x = JsonUtil.getOrDefault(json, "x", JsonElement::getAsInt, Integer.valueOf(0)).intValue();
        this.y = JsonUtil.getOrDefault(json, "y", JsonElement::getAsInt, Integer.valueOf(0)).intValue();
        this.width = JsonUtil.getOrDefault(json, "w", JsonElement::getAsInt, Integer.valueOf(0)).intValue();
        this.height = JsonUtil.getOrDefault(json, "h", JsonElement::getAsInt, Integer.valueOf(0)).intValue();
        this.loadCustomDataV3(json, difficulty);
        this.loadCustomObstacleDataV3(json, difficulty);
        this.loadJumps(difficulty.getInfo());
        return this;
    }

    @Override
    public Obstacle loadV4(JsonObject json, JsonArray obstaclesData, Difficulty difficulty) {
        this.beat = JsonUtil.getOrDefault(json, "b", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.offset = difficulty.getSetDifficulty().getOffset();
        this.njs = difficulty.getSetDifficulty().getNjs();
        int i = JsonUtil.getOrDefault(json, "i", JsonElement::getAsInt, Integer.valueOf(0));
        JsonObject data = obstaclesData.get(i).getAsJsonObject();
        this.duration = JsonUtil.getOrDefault(data, "d", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.x = JsonUtil.getOrDefault(data, "x", JsonElement::getAsInt, Integer.valueOf(0)).intValue();
        this.y = JsonUtil.getOrDefault(data, "y", JsonElement::getAsInt, Integer.valueOf(0)).intValue();
        this.width = JsonUtil.getOrDefault(data, "w", JsonElement::getAsInt, Integer.valueOf(0)).intValue();
        this.height = JsonUtil.getOrDefault(data, "h", JsonElement::getAsInt, Integer.valueOf(0)).intValue();
        this.loadJumps(difficulty.getInfo());
        return this;
    }

    public float getDuration() {
        return this.duration;
    }

    public float getLength(float njsDistance) {
        if (this.noodleSizing) {
            return this.duration;
        }
        return this.duration * njsDistance;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }
}

