/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ControllerProfile {
    private Vector3f rightTranslation = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f rightRotation = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f leftTranslation = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f leftRotation = new Vector3f(0.0f, 0.0f, 0.0f);

    private Vector3f parseVec3f(JsonObject json) {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (json.has("x")) {
            x = json.get("x").getAsFloat();
        }
        if (json.has("y")) {
            y = json.get("y").getAsFloat();
        }
        if (json.has("z")) {
            z = json.get("z").getAsFloat();
        }
        return new Vector3f(x, y, z);
    }

    public ControllerProfile() {
    }

    public ControllerProfile(JsonObject json) {
        this();
        if (json.has("leftController")) {
            JsonObject leftData = json.getAsJsonObject("leftController");
            if (leftData.has("position")) {
                this.leftTranslation = this.parseVec3f(leftData.getAsJsonObject("position"));
            }
            if (leftData.has("rotation")) {
                this.leftRotation = this.parseVec3f(leftData.getAsJsonObject("rotation"));
            }
        }
        if (json.has("rightController")) {
            JsonObject rightData = json.getAsJsonObject("rightController");
            if (rightData.has("position")) {
                this.rightTranslation = this.parseVec3f(rightData.getAsJsonObject("position"));
            }
            if (rightData.has("rotation")) {
                this.rightRotation = this.parseVec3f(rightData.getAsJsonObject("rotation"));
            }
        }
    }

    public void writeJson(JsonArray array) {
        JsonObject json = new JsonObject();
        JsonObject lc = new JsonObject();
        lc.add("position", (JsonElement)this.writeVector3f(this.leftTranslation));
        lc.add("rotation", (JsonElement)this.writeVector3f(this.leftRotation));
        JsonObject rc = new JsonObject();
        rc.add("position", (JsonElement)this.writeVector3f(this.rightTranslation));
        rc.add("rotation", (JsonElement)this.writeVector3f(this.rightRotation));
        json.add("leftController", (JsonElement)lc);
        json.add("rightController", (JsonElement)rc);
        array.add((JsonElement)json);
    }

    private JsonObject writeVector3f(Vector3f vector3f) {
        JsonObject json = new JsonObject();
        if (vector3f.x != 0.0f) {
            json.addProperty("x", (Number)Float.valueOf(vector3f.x));
        }
        if (vector3f.y != 0.0f) {
            json.addProperty("y", (Number)Float.valueOf(vector3f.y));
        }
        if (vector3f.z != 0.0f) {
            json.addProperty("z", (Number)Float.valueOf(vector3f.z));
        }
        return json;
    }

    public Vector3f getLeftTranslation() {
        return this.leftTranslation;
    }

    public Vector3f getRightTranslation() {
        return this.rightTranslation;
    }

    public Vector3f getLeftRotationEuler() {
        return this.leftRotation;
    }

    public Vector3f getRightRotationEuler() {
        return this.rightRotation;
    }

    public Quaternionf getLeftRotation() {
        return new Quaternionf().rotationYXZ(this.leftRotation.y * ((float)Math.PI / 180), this.leftRotation.x * ((float)Math.PI / 180), this.leftRotation.z * ((float)Math.PI / 180));
    }

    public Quaternionf getRightRotation() {
        return new Quaternionf().rotationYXZ(this.rightRotation.y * ((float)Math.PI / 180), this.rightRotation.x * ((float)Math.PI / 180), this.rightRotation.z * ((float)Math.PI / 180));
    }

    public void setLeftTranslation(Vector3f pos) {
        this.leftTranslation = pos;
    }

    public void setRightTranslation(Vector3f pos) {
        this.rightTranslation = pos;
    }

    public void setLeftRotation(Vector3f euler) {
        this.leftRotation = euler;
    }

    public void setRightRotation(Vector3f euler) {
        this.rightRotation = euler;
    }
}

