/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.data;

import com.beatcraft.BeatCraft;
import com.beatcraft.data.ControllerProfile;
import com.beatcraft.utils.JsonUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class PlayerConfig {
    public final File configFile = new File("./config/beatcraft/config.json");
    public final File configFolder = new File("./config/beatcraft/");
    private float audio_volume = 1.0f;
    private float audio_ambientVolumeScale = 0.8f;
    private int audio_latency = 0;
    private boolean audio_overrideLatency = false;
    private boolean quality_smokeGraphics = true;
    private boolean quality_burnMarkTrails = true;
    private boolean quality_sparkParticles = true;
    private ArrayList<String> activeModifiers = new ArrayList();
    private int controller_selectedProfile_index = -1;
    private final ArrayList<ControllerProfile> profiles = new ArrayList();
    private static final ControllerProfile DEFAULT_CONTROLLER_PROFILE = new ControllerProfile();
    private boolean option_reducedDebris = false;
    private boolean setting_placeEnvironmentStructures = true;

    public PlayerConfig(JsonObject json) {
        this();
        this.audio_volume = JsonUtil.getOrDefault(json, "audio.volume", JsonElement::getAsFloat, Float.valueOf(this.audio_volume)).floatValue();
        this.audio_ambientVolumeScale = JsonUtil.getOrDefault(json, "audio.ambient_volume_scale", JsonElement::getAsFloat, Float.valueOf(this.audio_ambientVolumeScale)).floatValue();
        this.audio_latency = JsonUtil.getOrDefault(json, "audio.latency", JsonElement::getAsInt, Integer.valueOf(this.audio_latency));
        this.audio_overrideLatency = JsonUtil.getOrDefault(json, "audio.override_latency", JsonElement::getAsBoolean, Boolean.valueOf(this.audio_overrideLatency));
        this.quality_smokeGraphics = JsonUtil.getOrDefault(json, "quality.smoke_graphics", JsonElement::getAsBoolean, Boolean.valueOf(this.quality_smokeGraphics));
        this.quality_burnMarkTrails = JsonUtil.getOrDefault(json, "quality.burn_mark_trails", JsonElement::getAsBoolean, Boolean.valueOf(this.quality_burnMarkTrails));
        this.quality_sparkParticles = JsonUtil.getOrDefault(json, "quality.spark_particles", JsonElement::getAsBoolean, Boolean.valueOf(this.quality_sparkParticles));
        this.option_reducedDebris = JsonUtil.getOrDefault(json, "option.reduced_debris", JsonElement::getAsBoolean, Boolean.valueOf(this.option_reducedDebris));
        if (json.has("active_modifiers")) {
            JsonArray rawModifiers = json.getAsJsonArray("active_modifiers");
            rawModifiers.forEach(mod -> this.activeModifiers.add(mod.getAsString()));
        }
        this.controller_selectedProfile_index = JsonUtil.getOrDefault(json, "controller.selectedProfile.index", JsonElement::getAsInt, Integer.valueOf(this.controller_selectedProfile_index));
        this.setting_placeEnvironmentStructures = JsonUtil.getOrDefault(json, "setting.placeEnvironmentStructures", JsonElement::getAsBoolean, Boolean.valueOf(this.setting_placeEnvironmentStructures));
        if (json.has("controller.profiles")) {
            JsonArray rawProfiles = json.getAsJsonArray("controller.profiles");
            rawProfiles.forEach(rawProfile -> {
                JsonObject profileData = rawProfile.getAsJsonObject();
                ControllerProfile profile = new ControllerProfile(profileData);
                this.profiles.add(profile);
            });
        }
    }

    private void writeJson(JsonObject json) {
        json.addProperty("audio.volume", (Number)Float.valueOf(this.audio_volume));
        json.addProperty("audio.ambient_volume_scale", (Number)Float.valueOf(this.audio_ambientVolumeScale));
        json.addProperty("audio.latency", (Number)this.audio_latency);
        json.addProperty("audio.override_latency", Boolean.valueOf(this.audio_overrideLatency));
        json.addProperty("quality.smoke_graphics", Boolean.valueOf(this.quality_smokeGraphics));
        json.addProperty("quality.burn_mark_trails", Boolean.valueOf(this.quality_burnMarkTrails));
        json.addProperty("quality.spark_particles", Boolean.valueOf(this.quality_sparkParticles));
        json.addProperty("option.reduced_debris", Boolean.valueOf(this.option_reducedDebris));
        json.addProperty("controller.selectedProfile.index", (Number)this.controller_selectedProfile_index);
        json.addProperty("setting.placeEnvironmentStructures", Boolean.valueOf(this.setting_placeEnvironmentStructures));
        JsonArray array = new JsonArray();
        this.profiles.forEach(profile -> profile.writeJson(array));
        json.add("controller.profiles", (JsonElement)array);
        JsonArray array2 = new JsonArray();
        this.activeModifiers.forEach(arg_0 -> ((JsonArray)array2).add(arg_0));
        json.add("active_modifiers", (JsonElement)array2);
    }

    public PlayerConfig() {
        if (!this.configFile.exists()) {
            boolean bl = this.configFolder.mkdirs();
        }
        if (!this.configFile.exists()) {
            try {
                boolean ignored = this.configFile.createNewFile();
                this.writeToFile();
            }
            catch (IOException e) {
                BeatCraft.LOGGER.error("Error creating player config file: ", (Throwable)e);
            }
        }
    }

    public void setModifier(String modifier, boolean active) {
        if (active && !this.activeModifiers.contains(modifier)) {
            this.activeModifiers.add(modifier);
        } else if (!active) {
            this.activeModifiers.remove(modifier);
        }
    }

    public List<String> getActiveModifiers() {
        return this.activeModifiers;
    }

    public boolean isModifierActive(String modifier) {
        return this.activeModifiers.contains(modifier);
    }

    public void setVolume(float volume) {
        this.audio_volume = volume;
    }

    public float getVolume() {
        return this.audio_volume;
    }

    public float getAmbientAudioScale() {
        return this.audio_ambientVolumeScale;
    }

    public int getLatency() {
        if (this.audio_overrideLatency) {
            return this.audio_latency;
        }
        return 0;
    }

    public void setOverrideLatency(boolean enabled) {
        this.audio_overrideLatency = enabled;
    }

    public boolean getOverrideLatency() {
        return this.audio_overrideLatency;
    }

    public void setLatency(long nanos) {
        this.audio_latency = (int)(nanos * 1000000L);
    }

    public void setSmokeRendering(boolean value) {
        this.quality_smokeGraphics = value;
    }

    public boolean shouldRenderSmoke() {
        return this.quality_smokeGraphics;
    }

    public void setBurnMarkRendering(boolean value) {
        this.quality_burnMarkTrails = value;
    }

    public boolean shouldRenderBurnMarkTrails() {
        return this.quality_burnMarkTrails;
    }

    public void setReducedDebris(boolean value) {
        this.option_reducedDebris = value;
    }

    public boolean isReducedDebris() {
        return this.option_reducedDebris;
    }

    public void setSparkParticles(boolean value) {
        this.quality_sparkParticles = value;
    }

    public boolean doSparkParticles() {
        return this.quality_sparkParticles;
    }

    public boolean doEnvironmentPlacing() {
        return this.setting_placeEnvironmentStructures;
    }

    public void setEnvironmentPlacing(boolean value) {
        this.setting_placeEnvironmentStructures = value;
    }

    public ControllerProfile getActiveControllerProfile() {
        if (this.profiles.isEmpty() || this.controller_selectedProfile_index <= -1) {
            return DEFAULT_CONTROLLER_PROFILE;
        }
        return this.profiles.get(this.controller_selectedProfile_index);
    }

    public int getSelectedControllerProfileIndex() {
        return this.controller_selectedProfile_index;
    }

    public void selectProfile(int index) {
        this.controller_selectedProfile_index = Math.clamp((long)index, -1, this.profiles.size() - 1);
    }

    public int getProfileCount() {
        return this.profiles.size();
    }

    public ControllerProfile addProfile() {
        ControllerProfile profile = new ControllerProfile();
        this.profiles.add(profile);
        return profile;
    }

    public void deleteControllerProfile(int index) {
        if (0 <= index && index < this.profiles.size()) {
            this.profiles.remove(index);
        }
    }

    public static PlayerConfig loadFromFile() {
        try {
            String jsonString = Files.readString(Path.of("./config/beatcraft/config.json", new String[0]));
            JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
            return new PlayerConfig(json);
        }
        catch (IOException e) {
            BeatCraft.LOGGER.error("Failed to load player config! ", (Throwable)e);
            return new PlayerConfig();
        }
    }

    public void writeToFile() {
        try {
            JsonObject json = new JsonObject();
            this.writeJson(json);
            Files.writeString(Path.of("./config/beatcraft/config.json", new String[0]), (CharSequence)json.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            BeatCraft.LOGGER.error("Failed to save player config ", (Throwable)e);
        }
    }
}

