/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.data.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class Stash<T>
implements Iterable<T> {
    private final ArrayList<T> data = new ArrayList();
    private int pointer = 0;
    private int max_size;
    private final boolean isTrail;
    private static int saberTrailSize = 30;

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new StashIterator(this, this.pointer, this.max_size);
    }

    public static void updateTrailSize(int size) {
        saberTrailSize = size;
    }

    public static int getTrailSize() {
        return saberTrailSize;
    }

    public boolean isEmpty() {
        return this.data.getFirst() == null;
    }

    public int getSize() {
        return this.max_size;
    }

    public Stash(int capacity, boolean isTrail) {
        this.isTrail = isTrail;
        this.max_size = capacity;
        for (int i = 0; i <= capacity; ++i) {
            this.data.add(null);
        }
    }

    public void resize(int newSize) {
        this.max_size = newSize;
        this.pointer = 0;
        this.data.clear();
        for (int i = 0; i <= newSize; ++i) {
            this.data.add(null);
        }
    }

    public void push(T element) {
        if (this.isTrail && this.max_size != saberTrailSize) {
            this.resize(saberTrailSize);
        }
        this.data.set(this.pointer, element);
        this.pointer = (this.pointer + 1) % this.max_size;
    }

    public static class StashIterator<T>
    implements Iterator<T> {
        private final Stash<T> parent;
        private int current;
        private int passed;
        private final int size;

        public StashIterator(Stash<T> parent, int pointer, int maxSize) {
            this.parent = parent;
            this.size = maxSize;
            this.current = pointer == 0 ? maxSize - 1 : pointer - 1;
            this.passed = 0;
        }

        @Override
        public boolean hasNext() {
            return this.passed < this.size && this.parent.data.get(this.current) != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object out = this.parent.data.get(this.current);
            this.current = this.current == 0 ? this.size - 1 : this.current - 1;
            ++this.passed;
            return out;
        }
    }
}

