/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.environment.structure_placers;

import com.beatcraft.BeatCraft;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5425;

public interface EnvironmentPlacer {
    public void placeStructure(class_3218 var1);

    public void removeStructure(class_3218 var1);

    default public void placeStructure(class_3218 world, class_2960 id, class_2338 pos) {
        Optional structureOpt = world.method_14183().method_15094(id);
        if (structureOpt.isPresent()) {
            class_3499 struct = (class_3499)structureOpt.get();
            struct.method_15172((class_5425)world, pos, new class_2338(0, 0, 0), new class_3492(), world.field_9229, 2);
        } else {
            BeatCraft.LOGGER.error("Failed to find structure: {}", (Object)id);
        }
    }

    default public void removeStructure(class_3218 world, class_2960 id, class_2338 pos) {
        Optional structureOpt = world.method_14183().method_15094(id);
        if (structureOpt.isPresent()) {
            class_3499 struct = (class_3499)structureOpt.get();
            class_2382 size = struct.method_15160();
            this.fillArea(world, pos, pos.method_10081(size).method_10059(new class_2382(1, 1, 1)), class_2246.field_10124.method_9564());
        }
    }

    default public void fillArea(class_3218 world, class_2338 min, class_2338 max, class_2680 blockState) {
        for (int x = min.method_10263(); x <= max.method_10263(); ++x) {
            for (int y = min.method_10264(); y <= max.method_10264(); ++y) {
                for (int z = min.method_10260(); z <= max.method_10260(); ++z) {
                    world.method_8501(new class_2338(x, y, z), blockState);
                }
            }
        }
    }

    default public void fillLine(class_3218 world, class_2338 start, class_2338 end, class_2680 state) {
        int dz;
        int dy;
        HashSet<class_2338> positions = new HashSet<class_2338>();
        int dx = Math.abs(end.method_10263() - start.method_10263());
        if (dx + (dy = Math.abs(end.method_10264() - start.method_10264())) + (dz = Math.abs(end.method_10260() - start.method_10260())) == 0) {
            world.method_8501(start, state);
            return;
        }
        int maxStep = Math.max(Math.max(dx, dy), dz);
        if (maxStep == dx) {
            for (step = 0; step <= dx; ++step) {
                int x = start.method_10263() + step * Integer.signum(end.method_10263() - start.method_10263());
                int y = Math.round((float)start.method_10264() + (float)step * ((float)dy / (float)dx) * (float)Integer.signum(end.method_10264() - start.method_10264()));
                z = Math.round((float)start.method_10260() + (float)step * ((float)dz / (float)dx) * (float)Integer.signum(end.method_10260() - start.method_10260()));
                positions.add(new class_2338(x, y, z));
            }
        } else if (maxStep == dy) {
            for (step = 0; step <= dy; ++step) {
                int y = start.method_10264() + step * Integer.signum(end.method_10264() - start.method_10264());
                x = Math.round((float)start.method_10263() + (float)step * ((float)dx / (float)dy) * (float)Integer.signum(end.method_10263() - start.method_10263()));
                z = Math.round((float)start.method_10260() + (float)step * ((float)dz / (float)dy) * (float)Integer.signum(end.method_10260() - start.method_10260()));
                positions.add(new class_2338(x, y, z));
            }
        } else {
            for (step = 0; step <= dz; ++step) {
                int z = start.method_10260() + step * Integer.signum(end.method_10260() - start.method_10260());
                x = Math.round((float)start.method_10263() + (float)step * ((float)dx / (float)dz) * (float)Integer.signum(end.method_10263() - start.method_10263()));
                int y = Math.round((float)start.method_10264() + (float)step * ((float)dy / (float)dz) * (float)Integer.signum(end.method_10264() - start.method_10264()));
                positions.add(new class_2338(x, y, z));
            }
        }
        for (class_2338 pos : positions) {
            world.method_8501(pos, state);
        }
    }
}

