/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.event;

import com.beatcraft.event.IEvent;
import com.beatcraft.utils.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class VoidEventHandler<E extends IEvent> {
    private final List<E> events;
    private final List<E> upcoming = new ArrayList();

    public VoidEventHandler(List<E> events) {
        this.events = events;
        this.reset();
    }

    public void reset() {
        this.upcoming.clear();
        this.upcoming.addAll(this.events);
    }

    public void seek(float beat) {
        this.reset();
        this.update(beat);
    }

    public abstract void onEventInterrupted(E var1, float var2);

    public abstract void onInsideEvent(E var1, float var2);

    public abstract void onEventPassed(E var1);

    private void handleEventInterrupted(float startBeat, float endBeat, E currentEvent) {
        IEvent interruptingEvent = (IEvent)this.upcoming.get(1);
        float interruptBeat = interruptingEvent.getEventBeat();
        float normalTime = MathUtil.inverseLerp(startBeat, endBeat, interruptBeat);
        this.onEventInterrupted(currentEvent, normalTime);
        this.upcoming.remove(currentEvent);
    }

    private void handleEventPassed(E currentEvent) {
        this.onEventPassed(currentEvent);
        this.upcoming.remove(currentEvent);
    }

    private boolean handleInsideEvent(float beat, float startBeat, float endBeat, E currentEvent) {
        if (this.upcoming.size() >= 2 && ((IEvent)this.upcoming.get(1)).getEventBeat() < beat) {
            this.handleEventInterrupted(startBeat, endBeat, currentEvent);
            return false;
        }
        float normalTime = MathUtil.inverseLerp(startBeat, endBeat, beat);
        this.onInsideEvent(currentEvent, normalTime);
        return true;
    }

    public void update(float beat) {
        while (!this.upcoming.isEmpty() && ((IEvent)this.upcoming.get(0)).getEventBeat() < beat) {
            IEvent currentEvent = (IEvent)this.upcoming.get(0);
            float startBeat = currentEvent.getEventBeat();
            float endBeat = startBeat + currentEvent.getEventDuration();
            if (endBeat > beat) {
                if (!this.handleInsideEvent(beat, startBeat, endBeat, currentEvent)) continue;
                break;
            }
            this.handleEventPassed(currentEvent);
        }
    }

    public List<E> getEvents() {
        return this.events;
    }
}

