/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.environment;

import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.beatmap.data.EventGroup;
import com.beatcraft.lightshow.environment.Environment;
import com.beatcraft.lightshow.environment.lightgroup.ActionLightGroupV2;
import com.beatcraft.lightshow.environment.lightgroup.LightGroupV2;
import com.beatcraft.lightshow.event.events.LightEvent;
import com.beatcraft.lightshow.event.events.ValueEvent;
import com.beatcraft.lightshow.event.handlers.ActionEventHandlerV2;
import com.beatcraft.lightshow.event.handlers.LightGroupEventHandlerV2;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.minecraft.class_4184;
import net.minecraft.class_4587;

@net.fabricmc.api.Environment(value=EnvType.CLIENT)
public abstract class EnvironmentV2
extends Environment {
    private LightGroupEventHandlerV2 leftRotatingLaserLightHandler = null;
    private LightGroupEventHandlerV2 rightRotatingLaserLightHandler = null;
    private ActionEventHandlerV2 leftRotatingLaserValueHandler = null;
    private ActionEventHandlerV2 rightRotatingLaserValueHandler = null;
    private LightGroupEventHandlerV2 backLaserLightHandler = null;
    private LightGroupEventHandlerV2 centerLaserLightHandler = null;
    private LightGroupEventHandlerV2 ringLightHandler = null;
    private ActionEventHandlerV2 ringZoomHandler = null;
    private ActionEventHandlerV2 ringSpinHandler = null;
    private HashMap<EventGroup, LightGroupV2> lightGroups;
    private ArrayList<LightGroupV2> uniqueGroups;

    public void bindLightGroup(EventGroup eventGroup, LightGroupV2 lightGroup) {
        this.lightGroups.put(eventGroup, lightGroup);
        if (!this.uniqueGroups.contains(lightGroup)) {
            this.uniqueGroups.add(lightGroup);
        }
    }

    @Override
    public void setup() {
        this.lightGroups = new HashMap();
        this.uniqueGroups = new ArrayList();
        LightGroupV2 leftLasers = this.setupLeftLasers();
        this.bindLightGroup(EventGroup.LEFT_LASERS, leftLasers);
        this.bindLightGroup(EventGroup.LEFT_ROTATING_LASERS, leftLasers);
        LightGroupV2 rightLasers = this.setupRightLasers();
        this.bindLightGroup(EventGroup.RIGHT_LASERS, rightLasers);
        this.bindLightGroup(EventGroup.RIGHT_ROTATING_LASERS, rightLasers);
        LightGroupV2 backLasers = this.setupBackLasers();
        this.bindLightGroup(EventGroup.BACK_LASERS, backLasers);
        LightGroupV2 centerLasers = this.setupCenterLasers();
        this.bindLightGroup(EventGroup.CENTER_LASERS, centerLasers);
        LightGroupV2 ringLights = this.setupRingLights();
        this.bindLightGroup(EventGroup.RING_LIGHTS, ringLights);
        this.bindLightGroup(EventGroup.RING_SPIN, ringLights);
        this.bindLightGroup(EventGroup.RING_ZOOM, ringLights);
    }

    protected abstract LightGroupV2 setupLeftLasers();

    protected abstract LightGroupV2 setupRightLasers();

    protected abstract LightGroupV2 setupBackLasers();

    protected abstract LightGroupV2 setupCenterLasers();

    protected abstract LightGroupV2 setupRingLights();

    public void loadLightshow(Difficulty difficulty, JsonObject json) {
        JsonArray events = json.getAsJsonArray("_events");
        ArrayList<LightEvent> lrlEvents = new ArrayList<LightEvent>();
        ArrayList<LightEvent> rrlEvents = new ArrayList<LightEvent>();
        ArrayList<ValueEvent> lrrEvents = new ArrayList<ValueEvent>();
        ArrayList<ValueEvent> rrrEvents = new ArrayList<ValueEvent>();
        ArrayList<LightEvent> backEvents = new ArrayList<LightEvent>();
        ArrayList<LightEvent> centerEvents = new ArrayList<LightEvent>();
        ArrayList<LightEvent> rlEvents = new ArrayList<LightEvent>();
        ArrayList<ValueEvent> rlsEvents = new ArrayList<ValueEvent>();
        ArrayList<ValueEvent> rlzEvents = new ArrayList<ValueEvent>();
        events.forEach(o -> {
            EventGroup group;
            JsonObject obj = o.getAsJsonObject();
            EventGroup selector0$temp = group = EventGroup.fromType(obj.get("_type").getAsInt());
            int index$1 = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"LEFT_LASERS", "RIGHT_LASERS", "LEFT_ROTATING_LASERS", "RIGHT_ROTATING_LASERS", "BACK_LASERS", "CENTER_LASERS", "RING_LIGHTS", "RING_SPIN", "RING_ZOOM"}, (EventGroup)selector0$temp, index$1)) {
                case 0: {
                    lrlEvents.add(new LightEvent().loadV2(obj, difficulty));
                    break;
                }
                case 1: {
                    rrlEvents.add(new LightEvent().loadV2(obj, difficulty));
                    break;
                }
                case 2: {
                    lrrEvents.add(new ValueEvent().loadV2(obj, difficulty));
                    break;
                }
                case 3: {
                    rrrEvents.add(new ValueEvent().loadV2(obj, difficulty));
                    break;
                }
                case 4: {
                    backEvents.add(new LightEvent().loadV2(obj, difficulty));
                    break;
                }
                case 5: {
                    centerEvents.add(new LightEvent().loadV2(obj, difficulty));
                    break;
                }
                case 6: {
                    rlEvents.add(new LightEvent().loadV2(obj, difficulty));
                    break;
                }
                case 7: {
                    rlsEvents.add(new ValueEvent().loadV2(obj, difficulty));
                    break;
                }
                case 8: {
                    rlzEvents.add(new ValueEvent().loadV2(obj, difficulty));
                    break;
                }
            }
        });
        lrlEvents.sort(difficulty::compareObjects);
        rrlEvents.sort(difficulty::compareObjects);
        lrrEvents.sort(difficulty::compareObjects);
        rrrEvents.sort(difficulty::compareObjects);
        backEvents.sort(difficulty::compareObjects);
        centerEvents.sort(difficulty::compareObjects);
        rlEvents.sort(difficulty::compareObjects);
        rlsEvents.sort(difficulty::compareObjects);
        rlzEvents.sort(difficulty::compareObjects);
        this.leftRotatingLaserLightHandler = new LightGroupEventHandlerV2(this.lightGroups.get((Object)EventGroup.LEFT_LASERS), lrlEvents);
        this.rightRotatingLaserLightHandler = new LightGroupEventHandlerV2(this.lightGroups.get((Object)EventGroup.RIGHT_LASERS), rrlEvents);
        this.leftRotatingLaserValueHandler = new ActionEventHandlerV2((ActionLightGroupV2)this.lightGroups.get((Object)EventGroup.LEFT_ROTATING_LASERS), lrrEvents, EventGroup.LEFT_ROTATING_LASERS);
        this.rightRotatingLaserValueHandler = new ActionEventHandlerV2((ActionLightGroupV2)this.lightGroups.get((Object)EventGroup.RIGHT_ROTATING_LASERS), rrrEvents, EventGroup.RIGHT_ROTATING_LASERS);
        this.backLaserLightHandler = new LightGroupEventHandlerV2(this.lightGroups.get((Object)EventGroup.BACK_LASERS), backEvents);
        this.centerLaserLightHandler = new LightGroupEventHandlerV2(this.lightGroups.get((Object)EventGroup.CENTER_LASERS), centerEvents);
        this.ringLightHandler = new LightGroupEventHandlerV2(this.lightGroups.get((Object)EventGroup.RING_LIGHTS), rlEvents);
        this.ringSpinHandler = new ActionEventHandlerV2((ActionLightGroupV2)this.lightGroups.get((Object)EventGroup.RING_SPIN), rlsEvents, EventGroup.RING_SPIN);
        this.ringZoomHandler = new ActionEventHandlerV2((ActionLightGroupV2)this.lightGroups.get((Object)EventGroup.RING_ZOOM), rlzEvents, EventGroup.RING_ZOOM);
    }

    @Override
    public void update(float beat, double deltaTime) {
        super.update(beat, deltaTime);
        this.leftRotatingLaserLightHandler.update(beat);
        this.rightRotatingLaserLightHandler.update(beat);
        this.leftRotatingLaserValueHandler.update(beat);
        this.rightRotatingLaserValueHandler.update(beat);
        this.backLaserLightHandler.update(beat);
        this.centerLaserLightHandler.update(beat);
        this.ringLightHandler.update(beat);
        this.ringSpinHandler.update(beat);
        this.ringZoomHandler.update(beat);
        for (LightGroupV2 group : this.uniqueGroups) {
            group.update(beat, deltaTime);
        }
    }

    @Override
    public void render(class_4587 matrices, class_4184 camera) {
        super.render(matrices, camera);
        this.uniqueGroups.forEach(v -> v.render(matrices, camera));
    }
}

