/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.environment.lightgroup;

import com.beatcraft.BeatmapPlayer;
import com.beatcraft.beatmap.data.EventGroup;
import com.beatcraft.lightshow.environment.lightgroup.ActionLightGroupV2;
import com.beatcraft.lightshow.environment.thefirst.InnerRing;
import com.beatcraft.lightshow.environment.thefirst.OuterRing;
import com.beatcraft.lightshow.event.events.ValueEvent;
import com.beatcraft.lightshow.lights.LightObject;
import com.beatcraft.lightshow.ring_lights.RingLightHandler;
import com.beatcraft.logic.Hitbox;
import com.beatcraft.render.BeatCraftRenderer;
import com.beatcraft.render.lights.GlowingCuboid;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class RingLightGroup
extends ActionLightGroupV2 {
    private final RingLightHandler innerRing = new RingLightHandler(InnerRing::getInstance, (v, q) -> null, 30, new Vector3f(0.0f, 2.0f, 14.0f), 5.0f);
    private final RingLightHandler outerRing = new RingLightHandler(OuterRing::new, this::linkLight, 15, new Vector3f(0.0f, 2.0f, 7.0f), 8.75f);
    private static final float ringRadius = 27.0f;
    private static final float lightLength = 6.0f;
    private static final float lightSize = 0.2f;
    private int linkIndex = 1;

    private static HashMap<Integer, LightObject> buildRingLights() {
        HashMap<Integer, LightObject> map = new HashMap<Integer, LightObject>();
        for (int i = 1; i <= 120; ++i) {
            map.put(i, new GlowingCuboid(new Hitbox(new Vector3f(-3.0f, -0.2f, -0.2f), new Vector3f(3.0f, 0.2f, 0.2f)), new Vector3f(0.0f, 26.79f, 0.2f), new Quaternionf()));
        }
        return map;
    }

    private LightObject linkLight(Vector3f position, Quaternionf orientation) {
        LightObject light = (LightObject)this.lights.get(this.linkIndex++);
        light.setPosition(position);
        light.setRotation(orientation);
        return light;
    }

    public void reset() {
        this.innerRing.reset();
        this.outerRing.reset();
    }

    public RingLightGroup() {
        super(RingLightGroup.buildRingLights());
        float rpd = (float)Math.PI / 180;
        this.innerRing.jumpOffsets = new float[]{-90.0f * rpd, 90.0f * rpd};
        this.outerRing.jumpOffsets = new float[]{-90.0f * rpd, 90.0f * rpd};
        this.innerRing.rotationOffsets = new float[]{0.0f, 3.0f * rpd, -3.0f * rpd, 7.0f * rpd, -7.0f * rpd, 11.0f * rpd, -11.0f * rpd};
        this.outerRing.rotationOffsets = new float[]{0.0f, 1.0f * rpd, 2.0f * rpd, 3.0f * rpd, 4.0f * rpd, 5.0f * rpd, -1.0f * rpd, -2.0f * rpd, -3.0f * rpd, -4.0f * rpd, -5.0f * rpd};
    }

    @Override
    public void handleEvent(ValueEvent event, EventGroup eventGroup) {
        switch (eventGroup) {
            case RING_SPIN: {
                this.handleRingSpin();
                break;
            }
            case RING_ZOOM: {
                this.handleRingZoom();
            }
        }
    }

    private void handleRingSpin() {
        this.innerRing.spinRandom();
        this.outerRing.spinRandom();
    }

    private void handleRingZoom() {
        this.innerRing.setZoom((double)this.innerRing.getZoom() >= 0.99 ? 0.3f : 1.0f);
    }

    @Override
    public void update(float beat, double deltaTime) {
        float t = BeatmapPlayer.getCurrentSeconds();
        this.innerRing.update(t);
        this.outerRing.update(t);
    }

    @Override
    public void render(class_4587 matrices, class_4184 camera) {
        this.innerRing.render(matrices, camera, BeatCraftRenderer.bloomfog);
        this.outerRing.render(matrices, camera, BeatCraftRenderer.bloomfog);
    }
}

