/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.environment.thefirst;

import com.beatcraft.lightshow.environment.EnvironmentV2;
import com.beatcraft.lightshow.environment.lightgroup.LightGroupV2;
import com.beatcraft.lightshow.environment.lightgroup.RingLightGroup;
import com.beatcraft.lightshow.environment.lightgroup.RotatingLightsGroup;
import com.beatcraft.lightshow.environment.lightgroup.StaticLightsGroup;
import com.beatcraft.lightshow.lights.LightObject;
import com.beatcraft.logic.Hitbox;
import com.beatcraft.render.lights.GlowingCuboid;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class TheFirstEnvironment
extends EnvironmentV2 {
    private RingLightGroup ringLights;
    private static final float ROTATING_LIGHT_X = 9.0f;
    private static final float ROTATING_LIGHT_Z = 35.0f;
    private static final float MIDDLE_LIGHT_Z = 60.0f;

    private static GlowingCuboid getRunway(boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid(new Hitbox(new Vector3f(-0.03f, -0.03f, 0.0f), new Vector3f(0.03f, 0.03f, 500.0f)), new Vector3f(3.5f * (float)sign, 0.0f, 8.0f), new Quaternionf());
    }

    private static GlowingCuboid getTowerLight1(boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid(new Hitbox(new Vector3f(-0.1f, -20.0f, -0.1f), new Vector3f(0.1f, 8.5f, 0.1f)), new Vector3f((float)(20 * sign), 0.0f, 16.0f), new Quaternionf());
    }

    private static GlowingCuboid getTowerLight2(boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid(new Hitbox(new Vector3f(-0.1f, -15.0f, -0.1f), new Vector3f(0.1f, 11.5f, 0.1f)), new Vector3f((float)(20 * sign), 0.0f, 19.0f), new Quaternionf());
    }

    private static GlowingCuboid getTowerLight3(boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid(new Hitbox(new Vector3f(-0.1f, -20.0f, -0.1f), new Vector3f(0.1f, 8.5f, 0.1f)), new Vector3f((float)(10 * sign), -6.0f, -17.0f), new Quaternionf());
    }

    private static GlowingCuboid getTowerLight4(boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid(new Hitbox(new Vector3f(-0.1f, -15.0f, -0.1f), new Vector3f(0.1f, 11.5f, 0.1f)), new Vector3f((float)(10 * sign), -6.0f, -14.0f), new Quaternionf());
    }

    private static GlowingCuboid[] getSkyLasers(boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid[]{new GlowingCuboid(new Hitbox(new Vector3f(-0.2f, 0.0f, -0.2f), new Vector3f(0.2f, 350.0f, 0.2f)), new Vector3f(12.5f * (float)sign, 24.0f, -13.5f), new Quaternionf()), new GlowingCuboid(new Hitbox(new Vector3f(-0.2f, 0.0f, -0.2f), new Vector3f(0.2f, 350.0f, 0.2f)), new Vector3f(22.5f * (float)sign, 30.0f, 19.5f), new Quaternionf())};
    }

    private static GlowingCuboid getSlantedLaser(boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid(new Hitbox(new Vector3f(-0.2f, 0.0f, -0.2f), new Vector3f(0.2f, 102.0f, 0.2f)), new Vector3f(3.5f * (float)sign, -64.0f, -0.5f), new Quaternionf().rotationX(-0.34557518f));
    }

    @Override
    protected LightGroupV2 setupLeftLasers() {
        HashMap<Integer, LightObject> rotatingLights = new HashMap<Integer, LightObject>();
        HashMap<Integer, LightObject> staticLights = new HashMap<Integer, LightObject>();
        int lightID = 1;
        Vector3f offset = new Vector3f(0.0f, 0.0f, 8.5f);
        GlowingCuboid left1 = new GlowingCuboid(new Hitbox(new Vector3f(-0.03f, -10.0f, -0.03f), new Vector3f(0.03f, 800.0f, 0.03f)), new Vector3f(9.0f, 2.0f, 35.0f), new Quaternionf().rotationZ(0.9599311f));
        GlowingCuboid left2 = left1.cloneOffset(offset);
        GlowingCuboid left3 = left2.cloneOffset(offset);
        GlowingCuboid left4 = left3.cloneOffset(offset);
        rotatingLights.put(lightID++, left1);
        rotatingLights.put(lightID++, left2);
        rotatingLights.put(lightID++, left3);
        rotatingLights.put(lightID++, left4);
        GlowingCuboid leftRunway = TheFirstEnvironment.getRunway(true);
        GlowingCuboid leftTowerLight1 = TheFirstEnvironment.getTowerLight1(true);
        GlowingCuboid leftTowerLight2 = TheFirstEnvironment.getTowerLight2(true);
        GlowingCuboid leftTowerLight3 = TheFirstEnvironment.getTowerLight3(true);
        GlowingCuboid leftTowerLight4 = TheFirstEnvironment.getTowerLight4(true);
        GlowingCuboid[] skyLasers = TheFirstEnvironment.getSkyLasers(true);
        staticLights.put(lightID++, leftRunway);
        staticLights.put(lightID++, leftTowerLight1);
        staticLights.put(lightID++, leftTowerLight2);
        staticLights.put(lightID++, leftTowerLight3);
        staticLights.put(lightID++, leftTowerLight4);
        staticLights.put(lightID++, skyLasers[0]);
        staticLights.put(lightID++, skyLasers[1]);
        return new RotatingLightsGroup(rotatingLights, staticLights);
    }

    @Override
    protected LightGroupV2 setupRightLasers() {
        HashMap<Integer, LightObject> rotatingLights = new HashMap<Integer, LightObject>();
        HashMap<Integer, LightObject> staticLights = new HashMap<Integer, LightObject>();
        int lightID = 1;
        Vector3f offset = new Vector3f(0.0f, 0.0f, 8.5f);
        GlowingCuboid right1 = new GlowingCuboid(new Hitbox(new Vector3f(-0.03f, -10.0f, -0.03f), new Vector3f(0.03f, 800.0f, 0.03f)), new Vector3f(-9.0f, 2.0f, 35.0f), new Quaternionf().rotationZ(-0.9599311f));
        GlowingCuboid right2 = right1.cloneOffset(offset);
        GlowingCuboid right3 = right2.cloneOffset(offset);
        GlowingCuboid right4 = right3.cloneOffset(offset);
        rotatingLights.put(lightID++, right1);
        rotatingLights.put(lightID++, right2);
        rotatingLights.put(lightID++, right3);
        rotatingLights.put(lightID++, right4);
        GlowingCuboid rightRunway = TheFirstEnvironment.getRunway(false);
        GlowingCuboid rightTowerLight1 = TheFirstEnvironment.getTowerLight1(false);
        GlowingCuboid rightTowerLight2 = TheFirstEnvironment.getTowerLight2(false);
        GlowingCuboid rightTowerLight3 = TheFirstEnvironment.getTowerLight3(false);
        GlowingCuboid rightTowerLight4 = TheFirstEnvironment.getTowerLight4(false);
        GlowingCuboid[] skyLasers = TheFirstEnvironment.getSkyLasers(false);
        staticLights.put(lightID++, rightRunway);
        staticLights.put(lightID++, rightTowerLight1);
        staticLights.put(lightID++, rightTowerLight2);
        staticLights.put(lightID++, rightTowerLight3);
        staticLights.put(lightID++, rightTowerLight4);
        staticLights.put(lightID++, skyLasers[0]);
        staticLights.put(lightID++, skyLasers[1]);
        return new RotatingLightsGroup(rotatingLights, staticLights);
    }

    @Override
    protected LightGroupV2 setupBackLasers() {
        HashMap<Integer, LightObject> lights = new HashMap<Integer, LightObject>();
        int lightID = 1;
        for (int i = 0; i < 5; ++i) {
            float z = 60.0f + (float)(i * 10);
            GlowingCuboid bottomLeftLaser = new GlowingCuboid(new Hitbox(new Vector3f(-0.05f, -150.0f, -0.05f), new Vector3f(0.05f, 0.0f, 0.05f)), new Vector3f(2.0f, -2.0f, z), new Quaternionf().rotationYXZ(0.34906584f, 1.0471976f, 0.0f));
            lights.put(lightID++, bottomLeftLaser);
            GlowingCuboid bottomRightLaser = new GlowingCuboid(new Hitbox(new Vector3f(-0.05f, -150.0f, -0.05f), new Vector3f(0.05f, 0.0f, 0.05f)), new Vector3f(-2.0f, -2.0f, z), new Quaternionf().rotationYXZ(-0.34906584f, 1.0471976f, 0.0f));
            lights.put(lightID++, bottomRightLaser);
        }
        return new StaticLightsGroup(lights);
    }

    @Override
    protected LightGroupV2 setupCenterLasers() {
        HashMap<Integer, LightObject> lights = new HashMap<Integer, LightObject>();
        int lightID = 1;
        for (int i = 0; i < 5; ++i) {
            float z = 60.0f + (float)(i * 10);
            GlowingCuboid topLeftLaser = new GlowingCuboid(new Hitbox(new Vector3f(-0.05f, 0.0f, -0.05f), new Vector3f(0.05f, 200.0f, 0.05f)), new Vector3f(2.0f, -2.0f, z), new Quaternionf().rotationYXZ(0.34906584f, 1.0471976f, 0.0f));
            lights.put(lightID++, topLeftLaser);
            GlowingCuboid topRightLaser = new GlowingCuboid(new Hitbox(new Vector3f(-0.05f, 0.0f, -0.05f), new Vector3f(0.05f, 200.0f, 0.05f)), new Vector3f(-2.0f, -2.0f, z), new Quaternionf().rotationYXZ(-0.34906584f, 1.0471976f, 0.0f));
            lights.put(lightID++, topRightLaser);
        }
        GlowingCuboid leftSlanted = TheFirstEnvironment.getSlantedLaser(true);
        GlowingCuboid rightSlanted = TheFirstEnvironment.getSlantedLaser(false);
        lights.put(lightID++, leftSlanted);
        lights.put(lightID++, rightSlanted);
        GlowingCuboid chevronLeft = new GlowingCuboid(new Hitbox(new Vector3f(-0.1f, -1.6f, -0.1f), new Vector3f(0.1f, 0.035f, 0.1f)), new Vector3f(0.0f, 4.0f, 75.0f), new Quaternionf().rotationZ(0.9599311f));
        lights.put(lightID++, chevronLeft);
        GlowingCuboid chevronRight = new GlowingCuboid(new Hitbox(new Vector3f(-0.1f, -1.6f, -0.1f), new Vector3f(0.1f, 0.035f, 0.1f)), new Vector3f(0.0f, 4.0f, 75.0f), new Quaternionf().rotationZ(-0.9599311f));
        lights.put(lightID++, chevronRight);
        return new StaticLightsGroup(lights);
    }

    @Override
    protected LightGroupV2 setupRingLights() {
        this.ringLights = new RingLightGroup();
        return this.ringLights;
    }

    @Override
    public TheFirstEnvironment reset() {
        this.ringLights.reset();
        return this;
    }
}

